/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJourneyRequest extends PinpointRequest implements
        ToCopyableBuilder<CreateJourneyRequest.Builder, CreateJourneyRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJourneyRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<WriteJourneyRequest> WRITE_JOURNEY_REQUEST_FIELD = SdkField
            .<WriteJourneyRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateJourneyRequest::writeJourneyRequest))
            .setter(setter(Builder::writeJourneyRequest))
            .constructor(WriteJourneyRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteJourneyRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            WRITE_JOURNEY_REQUEST_FIELD));

    private final String applicationId;

    private final WriteJourneyRequest writeJourneyRequest;

    private CreateJourneyRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeJourneyRequest = builder.writeJourneyRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the WriteJourneyRequest property for this object.
     * 
     * @return The value of the WriteJourneyRequest property for this object.
     */
    public WriteJourneyRequest writeJourneyRequest() {
        return writeJourneyRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(writeJourneyRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJourneyRequest)) {
            return false;
        }
        CreateJourneyRequest other = (CreateJourneyRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(writeJourneyRequest(), other.writeJourneyRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateJourneyRequest").add("ApplicationId", applicationId())
                .add("WriteJourneyRequest", writeJourneyRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "WriteJourneyRequest":
            return Optional.ofNullable(clazz.cast(writeJourneyRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJourneyRequest, T> g) {
        return obj -> g.apply((CreateJourneyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJourneyRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the WriteJourneyRequest property for this object.
         *
         * @param writeJourneyRequest
         *        The new value for the WriteJourneyRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeJourneyRequest(WriteJourneyRequest writeJourneyRequest);

        /**
         * Sets the value of the WriteJourneyRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link WriteJourneyRequest.Builder} avoiding the need
         * to create one manually via {@link WriteJourneyRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link WriteJourneyRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #writeJourneyRequest(WriteJourneyRequest)}.
         * 
         * @param writeJourneyRequest
         *        a consumer that will call methods on {@link WriteJourneyRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeJourneyRequest(WriteJourneyRequest)
         */
        default Builder writeJourneyRequest(Consumer<WriteJourneyRequest.Builder> writeJourneyRequest) {
            return writeJourneyRequest(WriteJourneyRequest.builder().applyMutation(writeJourneyRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private WriteJourneyRequest writeJourneyRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJourneyRequest model) {
            super(model);
            applicationId(model.applicationId);
            writeJourneyRequest(model.writeJourneyRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteJourneyRequest.Builder getWriteJourneyRequest() {
            return writeJourneyRequest != null ? writeJourneyRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeJourneyRequest(WriteJourneyRequest writeJourneyRequest) {
            this.writeJourneyRequest = writeJourneyRequest;
            return this;
        }

        public final void setWriteJourneyRequest(WriteJourneyRequest.BuilderImpl writeJourneyRequest) {
            this.writeJourneyRequest = writeJourneyRequest != null ? writeJourneyRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJourneyRequest build() {
            return new CreateJourneyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
