/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVoiceTemplateResponse extends PinpointResponse implements
        ToCopyableBuilder<CreateVoiceTemplateResponse.Builder, CreateVoiceTemplateResponse> {
    private static final SdkField<CreateTemplateMessageBody> CREATE_TEMPLATE_MESSAGE_BODY_FIELD = SdkField
            .<CreateTemplateMessageBody> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVoiceTemplateResponse::createTemplateMessageBody))
            .setter(setter(Builder::createTemplateMessageBody))
            .constructor(CreateTemplateMessageBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTemplateMessageBody").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CREATE_TEMPLATE_MESSAGE_BODY_FIELD));

    private final CreateTemplateMessageBody createTemplateMessageBody;

    private CreateVoiceTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.createTemplateMessageBody = builder.createTemplateMessageBody;
    }

    /**
     * Returns the value of the CreateTemplateMessageBody property for this object.
     * 
     * @return The value of the CreateTemplateMessageBody property for this object.
     */
    public CreateTemplateMessageBody createTemplateMessageBody() {
        return createTemplateMessageBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTemplateMessageBody());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceTemplateResponse)) {
            return false;
        }
        CreateVoiceTemplateResponse other = (CreateVoiceTemplateResponse) obj;
        return Objects.equals(createTemplateMessageBody(), other.createTemplateMessageBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVoiceTemplateResponse").add("CreateTemplateMessageBody", createTemplateMessageBody())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateTemplateMessageBody":
            return Optional.ofNullable(clazz.cast(createTemplateMessageBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceTemplateResponse, T> g) {
        return obj -> g.apply((CreateVoiceTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateVoiceTemplateResponse> {
        /**
         * Sets the value of the CreateTemplateMessageBody property for this object.
         *
         * @param createTemplateMessageBody
         *        The new value for the CreateTemplateMessageBody property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTemplateMessageBody(CreateTemplateMessageBody createTemplateMessageBody);

        /**
         * Sets the value of the CreateTemplateMessageBody property for this object.
         *
         * This is a convenience that creates an instance of the {@link CreateTemplateMessageBody.Builder} avoiding the
         * need to create one manually via {@link CreateTemplateMessageBody#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateTemplateMessageBody.Builder#build()} is called immediately
         * and its result is passed to {@link #createTemplateMessageBody(CreateTemplateMessageBody)}.
         * 
         * @param createTemplateMessageBody
         *        a consumer that will call methods on {@link CreateTemplateMessageBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTemplateMessageBody(CreateTemplateMessageBody)
         */
        default Builder createTemplateMessageBody(Consumer<CreateTemplateMessageBody.Builder> createTemplateMessageBody) {
            return createTemplateMessageBody(CreateTemplateMessageBody.builder().applyMutation(createTemplateMessageBody).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private CreateTemplateMessageBody createTemplateMessageBody;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceTemplateResponse model) {
            super(model);
            createTemplateMessageBody(model.createTemplateMessageBody);
        }

        public final CreateTemplateMessageBody.Builder getCreateTemplateMessageBody() {
            return createTemplateMessageBody != null ? createTemplateMessageBody.toBuilder() : null;
        }

        @Override
        public final Builder createTemplateMessageBody(CreateTemplateMessageBody createTemplateMessageBody) {
            this.createTemplateMessageBody = createTemplateMessageBody;
            return this;
        }

        public final void setCreateTemplateMessageBody(CreateTemplateMessageBody.BuilderImpl createTemplateMessageBody) {
            this.createTemplateMessageBody = createTemplateMessageBody != null ? createTemplateMessageBody.build() : null;
        }

        @Override
        public CreateVoiceTemplateResponse build() {
            return new CreateVoiceTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
