/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies data for one or more attributes that describe the user who's associated with an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointUser implements SdkPojo, Serializable, ToCopyableBuilder<EndpointUser.Builder, EndpointUser> {
    private static final SdkField<Map<String, List<String>>> USER_ATTRIBUTES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(EndpointUser::userAttributes))
            .setter(setter(Builder::userAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointUser::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ATTRIBUTES_FIELD,
            USER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> userAttributes;

    private final String userId;

    private EndpointUser(BuilderImpl builder) {
        this.userAttributes = builder.userAttributes;
        this.userId = builder.userId;
    }

    /**
     * Returns true if the UserAttributes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserAttributes() {
        return userAttributes != null && !(userAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more custom attributes that describe the user by associating a name with an array of values. For example,
     * the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes
     * as filter criteria when you create segments. Attribute names are case sensitive.
     * </p>
     * <p>
     * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you
     * define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question
     * mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names that contain
     * these characters. This restriction doesn't apply to attribute values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more custom attributes that describe the user by associating a name with an array of values. For
     *         example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use
     *         these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p>
     *         <p>
     *         An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters.
     *         When you define the name of a custom attribute, avoid using the following characters: number sign (#),
     *         colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display
     *         attribute names that contain these characters. This restriction doesn't apply to attribute values.
     */
    public Map<String, List<String>> userAttributes() {
        return userAttributes;
    }

    /**
     * <p>
     * The unique identifier for the user.
     * </p>
     * 
     * @return The unique identifier for the user.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointUser)) {
            return false;
        }
        EndpointUser other = (EndpointUser) obj;
        return Objects.equals(userAttributes(), other.userAttributes()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EndpointUser").add("UserAttributes", userAttributes()).add("UserId", userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointUser, T> g) {
        return obj -> g.apply((EndpointUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointUser> {
        /**
         * <p>
         * One or more custom attributes that describe the user by associating a name with an array of values. For
         * example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use
         * these attributes as filter criteria when you create segments. Attribute names are case sensitive.
         * </p>
         * <p>
         * An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When
         * you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:),
         * question mark (?), backslash (\), and slash (/). The Amazon Pinpoint console can't display attribute names
         * that contain these characters. This restriction doesn't apply to attribute values.
         * </p>
         * 
         * @param userAttributes
         *        One or more custom attributes that describe the user by associating a name with an array of values.
         *        For example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You
         *        can use these attributes as filter criteria when you create segments. Attribute names are case
         *        sensitive.</p>
         *        <p>
         *        An attribute name can contain up to 50 characters. An attribute value can contain up to 100
         *        characters. When you define the name of a custom attribute, avoid using the following characters:
         *        number sign (#), colon (:), question mark (?), backslash (\), and slash (/). The Amazon Pinpoint
         *        console can't display attribute names that contain these characters. This restriction doesn't apply to
         *        attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Map<String, ? extends Collection<String>> userAttributes);

        /**
         * <p>
         * The unique identifier for the user.
         * </p>
         * 
         * @param userId
         *        The unique identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> userAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointUser model) {
            userAttributes(model.userAttributes);
            userId(model.userId);
        }

        public final Map<String, ? extends Collection<String>> getUserAttributes() {
            return userAttributes;
        }

        @Override
        public final Builder userAttributes(Map<String, ? extends Collection<String>> userAttributes) {
            this.userAttributes = MapOfListOf__stringCopier.copy(userAttributes);
            return this;
        }

        public final void setUserAttributes(Map<String, ? extends Collection<String>> userAttributes) {
            this.userAttributes = MapOfListOf__stringCopier.copy(userAttributes);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public EndpointUser build() {
            return new EndpointUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
