/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies GPS-based criteria for including or excluding endpoints from a segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GPSPointDimension implements SdkPojo, Serializable,
        ToCopyableBuilder<GPSPointDimension.Builder, GPSPointDimension> {
    private static final SdkField<GPSCoordinates> COORDINATES_FIELD = SdkField.<GPSCoordinates> builder(MarshallingType.SDK_POJO)
            .getter(getter(GPSPointDimension::coordinates)).setter(setter(Builder::coordinates))
            .constructor(GPSCoordinates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinates").build()).build();

    private static final SdkField<Double> RANGE_IN_KILOMETERS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(GPSPointDimension::rangeInKilometers)).setter(setter(Builder::rangeInKilometers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeInKilometers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COORDINATES_FIELD,
            RANGE_IN_KILOMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final GPSCoordinates coordinates;

    private final Double rangeInKilometers;

    private GPSPointDimension(BuilderImpl builder) {
        this.coordinates = builder.coordinates;
        this.rangeInKilometers = builder.rangeInKilometers;
    }

    /**
     * <p>
     * The GPS coordinates to measure distance from.
     * </p>
     * 
     * @return The GPS coordinates to measure distance from.
     */
    public GPSCoordinates coordinates() {
        return coordinates;
    }

    /**
     * <p>
     * The range, in kilometers, from the GPS coordinates.
     * </p>
     * 
     * @return The range, in kilometers, from the GPS coordinates.
     */
    public Double rangeInKilometers() {
        return rangeInKilometers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coordinates());
        hashCode = 31 * hashCode + Objects.hashCode(rangeInKilometers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GPSPointDimension)) {
            return false;
        }
        GPSPointDimension other = (GPSPointDimension) obj;
        return Objects.equals(coordinates(), other.coordinates())
                && Objects.equals(rangeInKilometers(), other.rangeInKilometers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GPSPointDimension").add("Coordinates", coordinates())
                .add("RangeInKilometers", rangeInKilometers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Coordinates":
            return Optional.ofNullable(clazz.cast(coordinates()));
        case "RangeInKilometers":
            return Optional.ofNullable(clazz.cast(rangeInKilometers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GPSPointDimension, T> g) {
        return obj -> g.apply((GPSPointDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GPSPointDimension> {
        /**
         * <p>
         * The GPS coordinates to measure distance from.
         * </p>
         * 
         * @param coordinates
         *        The GPS coordinates to measure distance from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coordinates(GPSCoordinates coordinates);

        /**
         * <p>
         * The GPS coordinates to measure distance from.
         * </p>
         * This is a convenience that creates an instance of the {@link GPSCoordinates.Builder} avoiding the need to
         * create one manually via {@link GPSCoordinates#builder()}.
         *
         * When the {@link Consumer} completes, {@link GPSCoordinates.Builder#build()} is called immediately and its
         * result is passed to {@link #coordinates(GPSCoordinates)}.
         * 
         * @param coordinates
         *        a consumer that will call methods on {@link GPSCoordinates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coordinates(GPSCoordinates)
         */
        default Builder coordinates(Consumer<GPSCoordinates.Builder> coordinates) {
            return coordinates(GPSCoordinates.builder().applyMutation(coordinates).build());
        }

        /**
         * <p>
         * The range, in kilometers, from the GPS coordinates.
         * </p>
         * 
         * @param rangeInKilometers
         *        The range, in kilometers, from the GPS coordinates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeInKilometers(Double rangeInKilometers);
    }

    static final class BuilderImpl implements Builder {
        private GPSCoordinates coordinates;

        private Double rangeInKilometers;

        private BuilderImpl() {
        }

        private BuilderImpl(GPSPointDimension model) {
            coordinates(model.coordinates);
            rangeInKilometers(model.rangeInKilometers);
        }

        public final GPSCoordinates.Builder getCoordinates() {
            return coordinates != null ? coordinates.toBuilder() : null;
        }

        @Override
        public final Builder coordinates(GPSCoordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public final void setCoordinates(GPSCoordinates.BuilderImpl coordinates) {
            this.coordinates = coordinates != null ? coordinates.build() : null;
        }

        public final Double getRangeInKilometers() {
            return rangeInKilometers;
        }

        @Override
        public final Builder rangeInKilometers(Double rangeInKilometers) {
            this.rangeInKilometers = rangeInKilometers;
            return this;
        }

        public final void setRangeInKilometers(Double rangeInKilometers) {
            this.rangeInKilometers = rangeInKilometers;
        }

        @Override
        public GPSPointDimension build() {
            return new GPSPointDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
