/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCampaignResponse extends PinpointResponse implements
        ToCopyableBuilder<GetCampaignResponse.Builder, GetCampaignResponse> {
    private static final SdkField<CampaignResponse> CAMPAIGN_RESPONSE_FIELD = SdkField
            .<CampaignResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetCampaignResponse::campaignResponse))
            .setter(setter(Builder::campaignResponse))
            .constructor(CampaignResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_RESPONSE_FIELD));

    private final CampaignResponse campaignResponse;

    private GetCampaignResponse(BuilderImpl builder) {
        super(builder);
        this.campaignResponse = builder.campaignResponse;
    }

    /**
     * Returns the value of the CampaignResponse property for this object.
     * 
     * @return The value of the CampaignResponse property for this object.
     */
    public CampaignResponse campaignResponse() {
        return campaignResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignResponse)) {
            return false;
        }
        GetCampaignResponse other = (GetCampaignResponse) obj;
        return Objects.equals(campaignResponse(), other.campaignResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCampaignResponse").add("CampaignResponse", campaignResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignResponse":
            return Optional.ofNullable(clazz.cast(campaignResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignResponse, T> g) {
        return obj -> g.apply((GetCampaignResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCampaignResponse> {
        /**
         * Sets the value of the CampaignResponse property for this object.
         *
         * @param campaignResponse
         *        The new value for the CampaignResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignResponse(CampaignResponse campaignResponse);

        /**
         * Sets the value of the CampaignResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link CampaignResponse.Builder} avoiding the need to
         * create one manually via {@link CampaignResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #campaignResponse(CampaignResponse)}.
         * 
         * @param campaignResponse
         *        a consumer that will call methods on {@link CampaignResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignResponse(CampaignResponse)
         */
        default Builder campaignResponse(Consumer<CampaignResponse.Builder> campaignResponse) {
            return campaignResponse(CampaignResponse.builder().applyMutation(campaignResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private CampaignResponse campaignResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignResponse model) {
            super(model);
            campaignResponse(model.campaignResponse);
        }

        public final CampaignResponse.Builder getCampaignResponse() {
            return campaignResponse != null ? campaignResponse.toBuilder() : null;
        }

        @Override
        public final Builder campaignResponse(CampaignResponse campaignResponse) {
            this.campaignResponse = campaignResponse;
            return this;
        }

        public final void setCampaignResponse(CampaignResponse.BuilderImpl campaignResponse) {
            this.campaignResponse = campaignResponse != null ? campaignResponse.build() : null;
        }

        @Override
        public GetCampaignResponse build() {
            return new GetCampaignResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
