/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJourneyDateRangeKpiResponse extends PinpointResponse implements
        ToCopyableBuilder<GetJourneyDateRangeKpiResponse.Builder, GetJourneyDateRangeKpiResponse> {
    private static final SdkField<JourneyDateRangeKpiResponse> JOURNEY_DATE_RANGE_KPI_RESPONSE_FIELD = SdkField
            .<JourneyDateRangeKpiResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetJourneyDateRangeKpiResponse::journeyDateRangeKpiResponse))
            .setter(setter(Builder::journeyDateRangeKpiResponse))
            .constructor(JourneyDateRangeKpiResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyDateRangeKpiResponse")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOURNEY_DATE_RANGE_KPI_RESPONSE_FIELD));

    private final JourneyDateRangeKpiResponse journeyDateRangeKpiResponse;

    private GetJourneyDateRangeKpiResponse(BuilderImpl builder) {
        super(builder);
        this.journeyDateRangeKpiResponse = builder.journeyDateRangeKpiResponse;
    }

    /**
     * Returns the value of the JourneyDateRangeKpiResponse property for this object.
     * 
     * @return The value of the JourneyDateRangeKpiResponse property for this object.
     */
    public JourneyDateRangeKpiResponse journeyDateRangeKpiResponse() {
        return journeyDateRangeKpiResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(journeyDateRangeKpiResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJourneyDateRangeKpiResponse)) {
            return false;
        }
        GetJourneyDateRangeKpiResponse other = (GetJourneyDateRangeKpiResponse) obj;
        return Objects.equals(journeyDateRangeKpiResponse(), other.journeyDateRangeKpiResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetJourneyDateRangeKpiResponse")
                .add("JourneyDateRangeKpiResponse", journeyDateRangeKpiResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JourneyDateRangeKpiResponse":
            return Optional.ofNullable(clazz.cast(journeyDateRangeKpiResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJourneyDateRangeKpiResponse, T> g) {
        return obj -> g.apply((GetJourneyDateRangeKpiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJourneyDateRangeKpiResponse> {
        /**
         * Sets the value of the JourneyDateRangeKpiResponse property for this object.
         *
         * @param journeyDateRangeKpiResponse
         *        The new value for the JourneyDateRangeKpiResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyDateRangeKpiResponse(JourneyDateRangeKpiResponse journeyDateRangeKpiResponse);

        /**
         * Sets the value of the JourneyDateRangeKpiResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link JourneyDateRangeKpiResponse.Builder} avoiding
         * the need to create one manually via {@link JourneyDateRangeKpiResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link JourneyDateRangeKpiResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #journeyDateRangeKpiResponse(JourneyDateRangeKpiResponse)}.
         * 
         * @param journeyDateRangeKpiResponse
         *        a consumer that will call methods on {@link JourneyDateRangeKpiResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journeyDateRangeKpiResponse(JourneyDateRangeKpiResponse)
         */
        default Builder journeyDateRangeKpiResponse(Consumer<JourneyDateRangeKpiResponse.Builder> journeyDateRangeKpiResponse) {
            return journeyDateRangeKpiResponse(JourneyDateRangeKpiResponse.builder().applyMutation(journeyDateRangeKpiResponse)
                    .build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private JourneyDateRangeKpiResponse journeyDateRangeKpiResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJourneyDateRangeKpiResponse model) {
            super(model);
            journeyDateRangeKpiResponse(model.journeyDateRangeKpiResponse);
        }

        public final JourneyDateRangeKpiResponse.Builder getJourneyDateRangeKpiResponse() {
            return journeyDateRangeKpiResponse != null ? journeyDateRangeKpiResponse.toBuilder() : null;
        }

        @Override
        public final Builder journeyDateRangeKpiResponse(JourneyDateRangeKpiResponse journeyDateRangeKpiResponse) {
            this.journeyDateRangeKpiResponse = journeyDateRangeKpiResponse;
            return this;
        }

        public final void setJourneyDateRangeKpiResponse(JourneyDateRangeKpiResponse.BuilderImpl journeyDateRangeKpiResponse) {
            this.journeyDateRangeKpiResponse = journeyDateRangeKpiResponse != null ? journeyDateRangeKpiResponse.build() : null;
        }

        @Override
        public GetJourneyDateRangeKpiResponse build() {
            return new GetJourneyDateRangeKpiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
