/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommenderConfigurationsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetRecommenderConfigurationsResponse.Builder, GetRecommenderConfigurationsResponse> {
    private static final SdkField<ListRecommenderConfigurationsResponse> LIST_RECOMMENDER_CONFIGURATIONS_RESPONSE_FIELD = SdkField
            .<ListRecommenderConfigurationsResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetRecommenderConfigurationsResponse::listRecommenderConfigurationsResponse))
            .setter(setter(Builder::listRecommenderConfigurationsResponse))
            .constructor(ListRecommenderConfigurationsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ListRecommenderConfigurationsResponse").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LIST_RECOMMENDER_CONFIGURATIONS_RESPONSE_FIELD));

    private final ListRecommenderConfigurationsResponse listRecommenderConfigurationsResponse;

    private GetRecommenderConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.listRecommenderConfigurationsResponse = builder.listRecommenderConfigurationsResponse;
    }

    /**
     * Returns the value of the ListRecommenderConfigurationsResponse property for this object.
     * 
     * @return The value of the ListRecommenderConfigurationsResponse property for this object.
     */
    public ListRecommenderConfigurationsResponse listRecommenderConfigurationsResponse() {
        return listRecommenderConfigurationsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listRecommenderConfigurationsResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommenderConfigurationsResponse)) {
            return false;
        }
        GetRecommenderConfigurationsResponse other = (GetRecommenderConfigurationsResponse) obj;
        return Objects.equals(listRecommenderConfigurationsResponse(), other.listRecommenderConfigurationsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRecommenderConfigurationsResponse")
                .add("ListRecommenderConfigurationsResponse", listRecommenderConfigurationsResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListRecommenderConfigurationsResponse":
            return Optional.ofNullable(clazz.cast(listRecommenderConfigurationsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommenderConfigurationsResponse, T> g) {
        return obj -> g.apply((GetRecommenderConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommenderConfigurationsResponse> {
        /**
         * Sets the value of the ListRecommenderConfigurationsResponse property for this object.
         *
         * @param listRecommenderConfigurationsResponse
         *        The new value for the ListRecommenderConfigurationsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listRecommenderConfigurationsResponse(ListRecommenderConfigurationsResponse listRecommenderConfigurationsResponse);

        /**
         * Sets the value of the ListRecommenderConfigurationsResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link ListRecommenderConfigurationsResponse.Builder}
         * avoiding the need to create one manually via {@link ListRecommenderConfigurationsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListRecommenderConfigurationsResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #listRecommenderConfigurationsResponse(ListRecommenderConfigurationsResponse)}.
         * 
         * @param listRecommenderConfigurationsResponse
         *        a consumer that will call methods on {@link ListRecommenderConfigurationsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listRecommenderConfigurationsResponse(ListRecommenderConfigurationsResponse)
         */
        default Builder listRecommenderConfigurationsResponse(
                Consumer<ListRecommenderConfigurationsResponse.Builder> listRecommenderConfigurationsResponse) {
            return listRecommenderConfigurationsResponse(ListRecommenderConfigurationsResponse.builder()
                    .applyMutation(listRecommenderConfigurationsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ListRecommenderConfigurationsResponse listRecommenderConfigurationsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommenderConfigurationsResponse model) {
            super(model);
            listRecommenderConfigurationsResponse(model.listRecommenderConfigurationsResponse);
        }

        public final ListRecommenderConfigurationsResponse.Builder getListRecommenderConfigurationsResponse() {
            return listRecommenderConfigurationsResponse != null ? listRecommenderConfigurationsResponse.toBuilder() : null;
        }

        @Override
        public final Builder listRecommenderConfigurationsResponse(
                ListRecommenderConfigurationsResponse listRecommenderConfigurationsResponse) {
            this.listRecommenderConfigurationsResponse = listRecommenderConfigurationsResponse;
            return this;
        }

        public final void setListRecommenderConfigurationsResponse(
                ListRecommenderConfigurationsResponse.BuilderImpl listRecommenderConfigurationsResponse) {
            this.listRecommenderConfigurationsResponse = listRecommenderConfigurationsResponse != null ? listRecommenderConfigurationsResponse
                    .build() : null;
        }

        @Override
        public GetRecommenderConfigurationsResponse build() {
            return new GetRecommenderConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
