/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about all the recommender model configurations that are associated with your Amazon Pinpoint
 * account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommenderConfigurationsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ListRecommenderConfigurationsResponse.Builder, ListRecommenderConfigurationsResponse> {
    private static final SdkField<List<RecommenderConfigurationResponse>> ITEM_FIELD = SdkField
            .<List<RecommenderConfigurationResponse>> builder(MarshallingType.LIST)
            .getter(getter(ListRecommenderConfigurationsResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommenderConfigurationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommenderConfigurationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecommenderConfigurationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RecommenderConfigurationResponse> item;

    private final String nextToken;

    private ListRecommenderConfigurationsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Item property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of responses, one for each recommender model configuration that's associated with your Amazon Pinpoint
     * account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItem()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of responses, one for each recommender model configuration that's associated with your Amazon
     *         Pinpoint account.
     */
    public List<RecommenderConfigurationResponse> item() {
        return item;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommenderConfigurationsResponse)) {
            return false;
        }
        ListRecommenderConfigurationsResponse other = (ListRecommenderConfigurationsResponse) obj;
        return Objects.equals(item(), other.item()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRecommenderConfigurationsResponse").add("Item", item()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommenderConfigurationsResponse, T> g) {
        return obj -> g.apply((ListRecommenderConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListRecommenderConfigurationsResponse> {
        /**
         * <p>
         * An array of responses, one for each recommender model configuration that's associated with your Amazon
         * Pinpoint account.
         * </p>
         * 
         * @param item
         *        An array of responses, one for each recommender model configuration that's associated with your Amazon
         *        Pinpoint account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<RecommenderConfigurationResponse> item);

        /**
         * <p>
         * An array of responses, one for each recommender model configuration that's associated with your Amazon
         * Pinpoint account.
         * </p>
         * 
         * @param item
         *        An array of responses, one for each recommender model configuration that's associated with your Amazon
         *        Pinpoint account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(RecommenderConfigurationResponse... item);

        /**
         * <p>
         * An array of responses, one for each recommender model configuration that's associated with your Amazon
         * Pinpoint account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommenderConfigurationResponse>.Builder}
         * avoiding the need to create one manually via {@link List<RecommenderConfigurationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommenderConfigurationResponse>.Builder#build()} is called
         * immediately and its result is passed to {@link #item(List<RecommenderConfigurationResponse>)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link List<RecommenderConfigurationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(List<RecommenderConfigurationResponse>)
         */
        Builder item(Consumer<RecommenderConfigurationResponse.Builder>... item);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<RecommenderConfigurationResponse> item = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommenderConfigurationsResponse model) {
            item(model.item);
            nextToken(model.nextToken);
        }

        public final Collection<RecommenderConfigurationResponse.Builder> getItem() {
            return item != null ? item.stream().map(RecommenderConfigurationResponse::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder item(Collection<RecommenderConfigurationResponse> item) {
            this.item = ListOfRecommenderConfigurationResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(RecommenderConfigurationResponse... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<RecommenderConfigurationResponse.Builder>... item) {
            item(Stream.of(item).map(c -> RecommenderConfigurationResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<RecommenderConfigurationResponse.BuilderImpl> item) {
            this.item = ListOfRecommenderConfigurationResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRecommenderConfigurationsResponse build() {
            return new ListRecommenderConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
