/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about all the versions of a specific message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateVersionsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateVersionsResponse.Builder, TemplateVersionsResponse> {
    private static final SdkField<List<TemplateVersionResponse>> ITEM_FIELD = SdkField
            .<List<TemplateVersionResponse>> builder(MarshallingType.LIST)
            .getter(getter(TemplateVersionsResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateVersionResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateVersionResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateVersionsResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TemplateVersionsResponse::requestID)).setter(setter(Builder::requestID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, MESSAGE_FIELD,
            NEXT_TOKEN_FIELD, REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TemplateVersionResponse> item;

    private final String message;

    private final String nextToken;

    private final String requestID;

    private TemplateVersionsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.message = builder.message;
        this.nextToken = builder.nextToken;
        this.requestID = builder.requestID;
    }

    /**
     * Returns true if the Item property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of responses, one for each version of the message template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItem()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of responses, one for each version of the message template.
     */
    public List<TemplateVersionResponse> item() {
        return item;
    }

    /**
     * <p>
     * The message that's returned from the API for the request to retrieve information about all the versions of the
     * message template.
     * </p>
     * 
     * @return The message that's returned from the API for the request to retrieve information about all the versions
     *         of the message template.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The unique identifier for the request to retrieve information about all the versions of the message template.
     * </p>
     * 
     * @return The unique identifier for the request to retrieve information about all the versions of the message
     *         template.
     */
    public String requestID() {
        return requestID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestID());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateVersionsResponse)) {
            return false;
        }
        TemplateVersionsResponse other = (TemplateVersionsResponse) obj;
        return Objects.equals(item(), other.item()) && Objects.equals(message(), other.message())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(requestID(), other.requestID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TemplateVersionsResponse").add("Item", item()).add("Message", message())
                .add("NextToken", nextToken()).add("RequestID", requestID()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestID":
            return Optional.ofNullable(clazz.cast(requestID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateVersionsResponse, T> g) {
        return obj -> g.apply((TemplateVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateVersionsResponse> {
        /**
         * <p>
         * An array of responses, one for each version of the message template.
         * </p>
         * 
         * @param item
         *        An array of responses, one for each version of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<TemplateVersionResponse> item);

        /**
         * <p>
         * An array of responses, one for each version of the message template.
         * </p>
         * 
         * @param item
         *        An array of responses, one for each version of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(TemplateVersionResponse... item);

        /**
         * <p>
         * An array of responses, one for each version of the message template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TemplateVersionResponse>.Builder} avoiding
         * the need to create one manually via {@link List<TemplateVersionResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateVersionResponse>.Builder#build()} is called
         * immediately and its result is passed to {@link #item(List<TemplateVersionResponse>)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link List<TemplateVersionResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(List<TemplateVersionResponse>)
         */
        Builder item(Consumer<TemplateVersionResponse.Builder>... item);

        /**
         * <p>
         * The message that's returned from the API for the request to retrieve information about all the versions of
         * the message template.
         * </p>
         * 
         * @param message
         *        The message that's returned from the API for the request to retrieve information about all the
         *        versions of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The unique identifier for the request to retrieve information about all the versions of the message template.
         * </p>
         * 
         * @param requestID
         *        The unique identifier for the request to retrieve information about all the versions of the message
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestID(String requestID);
    }

    static final class BuilderImpl implements Builder {
        private List<TemplateVersionResponse> item = DefaultSdkAutoConstructList.getInstance();

        private String message;

        private String nextToken;

        private String requestID;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateVersionsResponse model) {
            item(model.item);
            message(model.message);
            nextToken(model.nextToken);
            requestID(model.requestID);
        }

        public final Collection<TemplateVersionResponse.Builder> getItem() {
            return item != null ? item.stream().map(TemplateVersionResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<TemplateVersionResponse> item) {
            this.item = ListOfTemplateVersionResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(TemplateVersionResponse... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<TemplateVersionResponse.Builder>... item) {
            item(Stream.of(item).map(c -> TemplateVersionResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<TemplateVersionResponse.BuilderImpl> item) {
            this.item = ListOfTemplateVersionResponseCopier.copyFromBuilder(item);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestID() {
            return requestID;
        }

        @Override
        public final Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public final void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        @Override
        public TemplateVersionsResponse build() {
            return new TemplateVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
