/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container element for specifying the default Object Lock retention settings for new objects placed in the
 * specified bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultRetention implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultRetention.Builder, DefaultRetention> {
    private static final SdkField<String> MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultRetention::modeAsString))
            .setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode")
                    .unmarshallLocationName("Mode").build()).build();

    private static final SdkField<Integer> DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DefaultRetention::days))
            .setter(setter(Builder::days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Days")
                    .unmarshallLocationName("Days").build()).build();

    private static final SdkField<Integer> YEARS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DefaultRetention::years))
            .setter(setter(Builder::years))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Years")
                    .unmarshallLocationName("Years").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, DAYS_FIELD,
            YEARS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final Integer days;

    private final Integer years;

    private DefaultRetention(BuilderImpl builder) {
        this.mode = builder.mode;
        this.days = builder.days;
        this.years = builder.years;
    }

    /**
     * <p>
     * The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ObjectLockRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
     * @see ObjectLockRetentionMode
     */
    public ObjectLockRetentionMode mode() {
        return ObjectLockRetentionMode.fromValue(mode);
    }

    /**
     * <p>
     * The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ObjectLockRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
     * @see ObjectLockRetentionMode
     */
    public String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The number of days that you want to specify for the default retention period.
     * </p>
     * 
     * @return The number of days that you want to specify for the default retention period.
     */
    public Integer days() {
        return days;
    }

    /**
     * <p>
     * The number of years that you want to specify for the default retention period.
     * </p>
     * 
     * @return The number of years that you want to specify for the default retention period.
     */
    public Integer years() {
        return years;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(days());
        hashCode = 31 * hashCode + Objects.hashCode(years());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultRetention)) {
            return false;
        }
        DefaultRetention other = (DefaultRetention) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(days(), other.days())
                && Objects.equals(years(), other.years());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DefaultRetention").add("Mode", modeAsString()).add("Days", days()).add("Years", years()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Days":
            return Optional.ofNullable(clazz.cast(days()));
        case "Years":
            return Optional.ofNullable(clazz.cast(years()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultRetention, T> g) {
        return obj -> g.apply((DefaultRetention) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultRetention> {
        /**
         * <p>
         * The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
         * </p>
         * 
         * @param mode
         *        The default Object Lock retention mode you want to apply to new objects placed in the specified
         *        bucket.
         * @see ObjectLockRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectLockRetentionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The default Object Lock retention mode you want to apply to new objects placed in the specified bucket.
         * </p>
         * 
         * @param mode
         *        The default Object Lock retention mode you want to apply to new objects placed in the specified
         *        bucket.
         * @see ObjectLockRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectLockRetentionMode
         */
        Builder mode(ObjectLockRetentionMode mode);

        /**
         * <p>
         * The number of days that you want to specify for the default retention period.
         * </p>
         * 
         * @param days
         *        The number of days that you want to specify for the default retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * <p>
         * The number of years that you want to specify for the default retention period.
         * </p>
         * 
         * @param years
         *        The number of years that you want to specify for the default retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder years(Integer years);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private Integer days;

        private Integer years;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultRetention model) {
            mode(model.mode);
            days(model.days);
            years(model.years);
        }

        public final String getModeAsString() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ObjectLockRetentionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final Integer getDays() {
            return days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final Integer getYears() {
            return years;
        }

        @Override
        public final Builder years(Integer years) {
            this.years = years;
            return this;
        }

        public final void setYears(Integer years) {
            this.years = years;
        }

        @Override
        public DefaultRetention build() {
            return new DefaultRetention(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
