/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.resource;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.internal.resource.S3ResourceType;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class S3ObjectResource
implements S3Resource,
ToCopyableBuilder<Builder, S3ObjectResource> {
    private static final S3ResourceType S3_RESOURCE_TYPE = S3ResourceType.OBJECT;
    private final String partition;
    private final String region;
    private final String accountId;
    private final String bucketName;
    private final String key;

    private S3ObjectResource(Builder b) {
        this.bucketName = (String)Validate.paramNotBlank((CharSequence)b.bucketName, (String)"bucketName");
        this.key = (String)Validate.paramNotBlank((CharSequence)b.key, (String)"key");
        this.partition = (String)Validate.paramNotBlank((CharSequence)b.partition, (String)"partition");
        this.region = b.region;
        this.accountId = b.accountId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String type() {
        return S3_RESOURCE_TYPE.toString();
    }

    @Override
    public Optional<String> partition() {
        return Optional.ofNullable(this.partition);
    }

    @Override
    public Optional<String> region() {
        return Optional.ofNullable(this.region);
    }

    @Override
    public Optional<String> accountId() {
        return Optional.ofNullable(this.accountId);
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ObjectResource that = (S3ObjectResource)o;
        if (this.partition != null ? !this.partition.equals(that.partition) : that.partition != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (!this.bucketName.equals(that.bucketName)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.partition != null ? this.partition.hashCode() : 0;
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + this.bucketName.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public Builder toBuilder() {
        return S3ObjectResource.builder().partition(this.partition).region(this.region).accountId(this.accountId).bucketName(this.bucketName).key(this.key);
    }

    public static final class Builder
    implements CopyableBuilder<Builder, S3ObjectResource> {
        private String partition;
        private String region;
        private String accountId;
        private String bucketName;
        private String key;

        private Builder() {
        }

        public void setPartition(String partition) {
            this.partition(partition);
        }

        public Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public void setRegion(String region) {
            this.region(region);
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public void setAccountId(String accountId) {
            this.accountId(accountId);
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public void setBucketName(String bucketName) {
            this.bucketName(bucketName);
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public void setKey(String key) {
            this.key(key);
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public S3ObjectResource build() {
            return new S3ObjectResource(this);
        }
    }
}

