/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.DefaultS3AsyncClient;
import software.amazon.awssdk.services.s3.DefaultS3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3ServiceClientConfiguration;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;

@SdkInternalApi
final class DefaultS3AsyncClientBuilder
extends DefaultS3BaseClientBuilder<S3AsyncClientBuilder, S3AsyncClient>
implements S3AsyncClientBuilder {
    DefaultS3AsyncClientBuilder() {
    }

    @Override
    public DefaultS3AsyncClientBuilder endpointProvider(S3EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final S3AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultS3AsyncClientBuilder.validateClientOptions(clientConfiguration);
        S3ServiceClientConfiguration serviceClientConfiguration = S3ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultS3AsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

