/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.ServerType;
import software.amazon.awssdk.services.sms.model.VmServer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Server
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Server> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Server.getter(Server::serverId)).setter(Server.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverId").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Server.getter(Server::serverTypeAsString)).setter(Server.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()}).build();
    private static final SdkField<VmServer> VM_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Server.getter(Server::vmServer)).setter(Server.setter(Builder::vmServer)).constructor(VmServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServer").build()}).build();
    private static final SdkField<String> REPLICATION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Server.getter(Server::replicationJobId)).setter(Server.setter(Builder::replicationJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobId").build()}).build();
    private static final SdkField<Boolean> REPLICATION_JOB_TERMINATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Server.getter(Server::replicationJobTerminated)).setter(Server.setter(Builder::replicationJobTerminated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobTerminated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, SERVER_TYPE_FIELD, VM_SERVER_FIELD, REPLICATION_JOB_ID_FIELD, REPLICATION_JOB_TERMINATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serverId;
    private final String serverType;
    private final VmServer vmServer;
    private final String replicationJobId;
    private final Boolean replicationJobTerminated;

    private Server(BuilderImpl builder) {
        this.serverId = builder.serverId;
        this.serverType = builder.serverType;
        this.vmServer = builder.vmServer;
        this.replicationJobId = builder.replicationJobId;
        this.replicationJobTerminated = builder.replicationJobTerminated;
    }

    public String serverId() {
        return this.serverId;
    }

    public ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public String serverTypeAsString() {
        return this.serverType;
    }

    public VmServer vmServer() {
        return this.vmServer;
    }

    public String replicationJobId() {
        return this.replicationJobId;
    }

    public Boolean replicationJobTerminated() {
        return this.replicationJobTerminated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJobTerminated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server other = (Server)obj;
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.vmServer(), other.vmServer()) && Objects.equals(this.replicationJobId(), other.replicationJobId()) && Objects.equals(this.replicationJobTerminated(), other.replicationJobTerminated());
    }

    public String toString() {
        return ToString.builder((String)"Server").add("ServerId", (Object)this.serverId()).add("ServerType", (Object)this.serverTypeAsString()).add("VmServer", (Object)this.vmServer()).add("ReplicationJobId", (Object)this.replicationJobId()).add("ReplicationJobTerminated", (Object)this.replicationJobTerminated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "vmServer": {
                return Optional.ofNullable(clazz.cast(this.vmServer()));
            }
            case "replicationJobId": {
                return Optional.ofNullable(clazz.cast(this.replicationJobId()));
            }
            case "replicationJobTerminated": {
                return Optional.ofNullable(clazz.cast(this.replicationJobTerminated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Server, T> g) {
        return obj -> g.apply((Server)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverId;
        private String serverType;
        private VmServer vmServer;
        private String replicationJobId;
        private Boolean replicationJobTerminated;

        private BuilderImpl() {
        }

        private BuilderImpl(Server model) {
            this.serverId(model.serverId);
            this.serverType(model.serverType);
            this.vmServer(model.vmServer);
            this.replicationJobId(model.replicationJobId);
            this.replicationJobTerminated(model.replicationJobTerminated);
        }

        public final String getServerId() {
            return this.serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getServerType() {
            return this.serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public final VmServer.Builder getVmServer() {
            return this.vmServer != null ? this.vmServer.toBuilder() : null;
        }

        @Override
        public final Builder vmServer(VmServer vmServer) {
            this.vmServer = vmServer;
            return this;
        }

        public final void setVmServer(VmServer.BuilderImpl vmServer) {
            this.vmServer = vmServer != null ? vmServer.build() : null;
        }

        public final String getReplicationJobId() {
            return this.replicationJobId;
        }

        @Override
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        public final Boolean getReplicationJobTerminated() {
            return this.replicationJobTerminated;
        }

        @Override
        public final Builder replicationJobTerminated(Boolean replicationJobTerminated) {
            this.replicationJobTerminated = replicationJobTerminated;
            return this;
        }

        public final void setReplicationJobTerminated(Boolean replicationJobTerminated) {
            this.replicationJobTerminated = replicationJobTerminated;
        }

        public Server build() {
            return new Server(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Server> {
        public Builder serverId(String var1);

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder vmServer(VmServer var1);

        default public Builder vmServer(Consumer<VmServer.Builder> vmServer) {
            return this.vmServer((VmServer)((VmServer.Builder)VmServer.builder().applyMutation(vmServer)).build());
        }

        public Builder replicationJobId(String var1);

        public Builder replicationJobTerminated(Boolean var1);
    }
}

