/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchema;

public class GetInventorySchemaIterable
implements SdkIterable<GetInventorySchemaResponse> {
    private final SsmClient client;
    private final GetInventorySchemaRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInventorySchemaIterable(SsmClient client, GetInventorySchemaRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetInventorySchemaResponseFetcher();
    }

    public Iterator<GetInventorySchemaResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InventoryItemSchema> schemas() {
        Function<GetInventorySchemaResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemas() != null) {
                return response.schemas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetInventorySchemaResponseFetcher
    implements SyncPageFetcher<GetInventorySchemaResponse> {
        private GetInventorySchemaResponseFetcher() {
        }

        public boolean hasNextPage(GetInventorySchemaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInventorySchemaResponse nextPage(GetInventorySchemaResponse previousPage) {
            if (previousPage == null) {
                return GetInventorySchemaIterable.this.client.getInventorySchema(GetInventorySchemaIterable.this.firstRequest);
            }
            return GetInventorySchemaIterable.this.client.getInventorySchema((GetInventorySchemaRequest)((Object)GetInventorySchemaIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

