// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * The configuration information for the bucket.
 */
public class CreateBucketConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the information about the bucket that will be created.
     *
     * This functionality is only supported by directory buckets.
     */
    public val bucket: aws.sdk.kotlin.services.s3.model.BucketInfo? = builder.bucket
    /**
     * Specifies the location where the bucket will be created.
     *
     * For directory buckets, the location type is Availability Zone.
     *
     * This functionality is only supported by directory buckets.
     */
    public val location: aws.sdk.kotlin.services.s3.model.LocationInfo? = builder.location
    /**
     * Specifies the Region where the bucket will be created. You might choose a Region to optimize latency, minimize costs, or address regulatory requirements. For example, if you reside in Europe, you will probably find it advantageous to create buckets in the Europe (Ireland) Region. For more information, see [Accessing a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro) in the *Amazon S3 User Guide*.
     *
     * If you don't specify a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1) by default.
     *
     * This functionality is not supported for directory buckets.
     */
    public val locationConstraint: aws.sdk.kotlin.services.s3.model.BucketLocationConstraint? = builder.locationConstraint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBucketConfiguration(")
        append("bucket=$bucket,")
        append("location=$location,")
        append("locationConstraint=$locationConstraint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (locationConstraint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBucketConfiguration

        if (bucket != other.bucket) return false
        if (location != other.location) return false
        if (locationConstraint != other.locationConstraint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the information about the bucket that will be created.
         *
         * This functionality is only supported by directory buckets.
         */
        public var bucket: aws.sdk.kotlin.services.s3.model.BucketInfo? = null
        /**
         * Specifies the location where the bucket will be created.
         *
         * For directory buckets, the location type is Availability Zone.
         *
         * This functionality is only supported by directory buckets.
         */
        public var location: aws.sdk.kotlin.services.s3.model.LocationInfo? = null
        /**
         * Specifies the Region where the bucket will be created. You might choose a Region to optimize latency, minimize costs, or address regulatory requirements. For example, if you reside in Europe, you will probably find it advantageous to create buckets in the Europe (Ireland) Region. For more information, see [Accessing a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro) in the *Amazon S3 User Guide*.
         *
         * If you don't specify a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1) by default.
         *
         * This functionality is not supported for directory buckets.
         */
        public var locationConstraint: aws.sdk.kotlin.services.s3.model.BucketLocationConstraint? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration) : this() {
            this.bucket = x.bucket
            this.location = x.location
            this.locationConstraint = x.locationConstraint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration = CreateBucketConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.BucketInfo] inside the given [block]
         */
        public fun bucket(block: aws.sdk.kotlin.services.s3.model.BucketInfo.Builder.() -> kotlin.Unit) {
            this.bucket = aws.sdk.kotlin.services.s3.model.BucketInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.LocationInfo] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.s3.model.LocationInfo.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.s3.model.LocationInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
