// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model

import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.time.Instant

public class GetObjectResponse private constructor(builder: Builder) {
    /**
     * Indicates that a range of bytes was specified in the request.
     */
    public val acceptRanges: kotlin.String? = builder.acceptRanges
    /**
     * Object data.
     */
    public val body: aws.smithy.kotlin.runtime.content.ByteStream? = builder.body
    /**
     * Indicates whether the object uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).
     *
     * This functionality is not supported for directory buckets.
     */
    public val bucketKeyEnabled: kotlin.Boolean? = builder.bucketKeyEnabled
    /**
     * Specifies caching behavior along the request/reply chain.
     */
    public val cacheControl: kotlin.String? = builder.cacheControl
    /**
     * The base64-encoded, 32-bit CRC32 checksum of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     */
    public val checksumCrc32: kotlin.String? = builder.checksumCrc32
    /**
     * The base64-encoded, 32-bit CRC32C checksum of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     */
    public val checksumCrc32C: kotlin.String? = builder.checksumCrc32C
    /**
     * The base64-encoded, 160-bit SHA-1 digest of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     */
    public val checksumSha1: kotlin.String? = builder.checksumSha1
    /**
     * The base64-encoded, 256-bit SHA-256 digest of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     */
    public val checksumSha256: kotlin.String? = builder.checksumSha256
    /**
     * Specifies presentational information for the object.
     */
    public val contentDisposition: kotlin.String? = builder.contentDisposition
    /**
     * Indicates what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.
     */
    public val contentEncoding: kotlin.String? = builder.contentEncoding
    /**
     * The language the content is in.
     */
    public val contentLanguage: kotlin.String? = builder.contentLanguage
    /**
     * Size of the body in bytes.
     */
    public val contentLength: kotlin.Long? = builder.contentLength
    /**
     * The portion of the object returned in the response.
     */
    public val contentRange: kotlin.String? = builder.contentRange
    /**
     * A standard MIME type describing the format of the object data.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Indicates whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.
     *
     * + If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and includes `x-amz-delete-marker: true` in the response.
     * + If the specified version in the request is a delete marker, the response returns a `405 Method Not Allowed` error and the `Last-Modified: timestamp` response header.
     */
    public val deleteMarker: kotlin.Boolean? = builder.deleteMarker
    /**
     * An entity tag (ETag) is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.
     */
    public val eTag: kotlin.String? = builder.eTag
    /**
     * If the object expiration is configured (see `PutBucketLifecycleConfiguration`[](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)), the response includes this header. It includes the `expiry-date` and `rule-id` key-value pairs providing object expiration information. The value of the `rule-id` is URL-encoded.
     *
     * This functionality is not supported for directory buckets.
     */
    public val expiration: kotlin.String? = builder.expiration
    /**
     * The date and time at which the object is no longer cacheable.
     */
    public val expires: aws.smithy.kotlin.runtime.time.Instant? = builder.expires
    /**
     * Date and time when the object was last modified.
     *
     * **General purpose buckets ** - When you specify a `versionId` of the object in your request, if the specified version in the request is a delete marker, the response returns a `405 Method Not Allowed` error and the `Last-Modified: timestamp` response header.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * A map of metadata to store with the object in S3.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * This is set to the number of metadata entries not returned in the headers that are prefixed with `x-amz-meta-`. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.
     *
     * This functionality is not supported for directory buckets.
     */
    public val missingMeta: kotlin.Int? = builder.missingMeta
    /**
     * Indicates whether this object has an active legal hold. This field is only returned if you have permission to view an object's legal hold status.
     *
     * This functionality is not supported for directory buckets.
     */
    public val objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3.model.ObjectLockLegalHoldStatus? = builder.objectLockLegalHoldStatus
    /**
     * The Object Lock mode that's currently in place for this object.
     *
     * This functionality is not supported for directory buckets.
     */
    public val objectLockMode: aws.sdk.kotlin.services.s3.model.ObjectLockMode? = builder.objectLockMode
    /**
     * The date and time when this object's Object Lock will expire.
     *
     * This functionality is not supported for directory buckets.
     */
    public val objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = builder.objectLockRetainUntilDate
    /**
     * The count of parts this object has. This value is only returned if you specify `partNumber` in your request and the object was uploaded as a multipart upload.
     */
    public val partsCount: kotlin.Int? = builder.partsCount
    /**
     * Amazon S3 can return this if your request involves a bucket that is either a source or destination in a replication rule.
     *
     * This functionality is not supported for directory buckets.
     */
    public val replicationStatus: aws.sdk.kotlin.services.s3.model.ReplicationStatus? = builder.replicationStatus
    /**
     * If present, indicates that the requester was successfully charged for the request.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = builder.requestCharged
    /**
     * Provides information about object restoration action and expiration time of the restored object copy.
     *
     * This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
     */
    public val restore: kotlin.String? = builder.restore
    /**
     * The server-side encryption algorithm used when you store this object in Amazon S3 (for example, `AES256`, `aws:kms`, `aws:kms:dsse`).
     *
     * For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (`AES256`) is supported.
     */
    public val serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = builder.serverSideEncryption
    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.
     *
     * This functionality is not supported for directory buckets.
     */
    public val sseCustomerAlgorithm: kotlin.String? = builder.sseCustomerAlgorithm
    /**
     * If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.
     *
     * This functionality is not supported for directory buckets.
     */
    public val sseCustomerKeyMd5: kotlin.String? = builder.sseCustomerKeyMd5
    /**
     * If present, indicates the ID of the Key Management Service (KMS) symmetric encryption customer managed key that was used for the object.
     *
     * This functionality is not supported for directory buckets.
     */
    public val ssekmsKeyId: kotlin.String? = builder.ssekmsKeyId
    /**
     * Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.
     *
     * **Directory buckets ** - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
     */
    public val storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = builder.storageClass
    /**
     * The number of tags, if any, on the object, when you have the relevant permission to read object tags.
     *
     * You can use [GetObjectTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html) to retrieve the tag set associated with an object.
     *
     * This functionality is not supported for directory buckets.
     */
    public val tagCount: kotlin.Int? = builder.tagCount
    /**
     * Version ID of the object.
     *
     * This functionality is not supported for directory buckets.
     */
    public val versionId: kotlin.String? = builder.versionId
    /**
     * If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.
     *
     * This functionality is not supported for directory buckets.
     */
    public val websiteRedirectLocation: kotlin.String? = builder.websiteRedirectLocation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.GetObjectResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetObjectResponse(")
        append("acceptRanges=$acceptRanges,")
        append("body=$body,")
        append("bucketKeyEnabled=$bucketKeyEnabled,")
        append("cacheControl=$cacheControl,")
        append("checksumCrc32=$checksumCrc32,")
        append("checksumCrc32C=$checksumCrc32C,")
        append("checksumSha1=$checksumSha1,")
        append("checksumSha256=$checksumSha256,")
        append("contentDisposition=$contentDisposition,")
        append("contentEncoding=$contentEncoding,")
        append("contentLanguage=$contentLanguage,")
        append("contentLength=$contentLength,")
        append("contentRange=$contentRange,")
        append("contentType=$contentType,")
        append("deleteMarker=$deleteMarker,")
        append("eTag=$eTag,")
        append("expiration=$expiration,")
        append("expires=$expires,")
        append("lastModified=$lastModified,")
        append("metadata=$metadata,")
        append("missingMeta=$missingMeta,")
        append("objectLockLegalHoldStatus=$objectLockLegalHoldStatus,")
        append("objectLockMode=$objectLockMode,")
        append("objectLockRetainUntilDate=$objectLockRetainUntilDate,")
        append("partsCount=$partsCount,")
        append("replicationStatus=$replicationStatus,")
        append("requestCharged=$requestCharged,")
        append("restore=$restore,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("sseCustomerAlgorithm=$sseCustomerAlgorithm,")
        append("sseCustomerKeyMd5=$sseCustomerKeyMd5,")
        append("ssekmsKeyId=*** Sensitive Data Redacted ***,")
        append("storageClass=$storageClass,")
        append("tagCount=$tagCount,")
        append("versionId=$versionId,")
        append("websiteRedirectLocation=$websiteRedirectLocation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptRanges?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (bucketKeyEnabled?.hashCode() ?: 0)
        result = 31 * result + (cacheControl?.hashCode() ?: 0)
        result = 31 * result + (checksumCrc32?.hashCode() ?: 0)
        result = 31 * result + (checksumCrc32C?.hashCode() ?: 0)
        result = 31 * result + (checksumSha1?.hashCode() ?: 0)
        result = 31 * result + (checksumSha256?.hashCode() ?: 0)
        result = 31 * result + (contentDisposition?.hashCode() ?: 0)
        result = 31 * result + (contentEncoding?.hashCode() ?: 0)
        result = 31 * result + (contentLanguage?.hashCode() ?: 0)
        result = 31 * result + (contentLength?.hashCode() ?: 0)
        result = 31 * result + (contentRange?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (deleteMarker?.hashCode() ?: 0)
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (expires?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (missingMeta ?: 0)
        result = 31 * result + (objectLockLegalHoldStatus?.hashCode() ?: 0)
        result = 31 * result + (objectLockMode?.hashCode() ?: 0)
        result = 31 * result + (objectLockRetainUntilDate?.hashCode() ?: 0)
        result = 31 * result + (partsCount ?: 0)
        result = 31 * result + (replicationStatus?.hashCode() ?: 0)
        result = 31 * result + (requestCharged?.hashCode() ?: 0)
        result = 31 * result + (restore?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sseCustomerKeyMd5?.hashCode() ?: 0)
        result = 31 * result + (ssekmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tagCount ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        result = 31 * result + (websiteRedirectLocation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetObjectResponse

        if (acceptRanges != other.acceptRanges) return false
        if (body != other.body) return false
        if (bucketKeyEnabled != other.bucketKeyEnabled) return false
        if (cacheControl != other.cacheControl) return false
        if (checksumCrc32 != other.checksumCrc32) return false
        if (checksumCrc32C != other.checksumCrc32C) return false
        if (checksumSha1 != other.checksumSha1) return false
        if (checksumSha256 != other.checksumSha256) return false
        if (contentDisposition != other.contentDisposition) return false
        if (contentEncoding != other.contentEncoding) return false
        if (contentLanguage != other.contentLanguage) return false
        if (contentLength != other.contentLength) return false
        if (contentRange != other.contentRange) return false
        if (contentType != other.contentType) return false
        if (deleteMarker != other.deleteMarker) return false
        if (eTag != other.eTag) return false
        if (expiration != other.expiration) return false
        if (expires != other.expires) return false
        if (lastModified != other.lastModified) return false
        if (metadata != other.metadata) return false
        if (missingMeta != other.missingMeta) return false
        if (objectLockLegalHoldStatus != other.objectLockLegalHoldStatus) return false
        if (objectLockMode != other.objectLockMode) return false
        if (objectLockRetainUntilDate != other.objectLockRetainUntilDate) return false
        if (partsCount != other.partsCount) return false
        if (replicationStatus != other.replicationStatus) return false
        if (requestCharged != other.requestCharged) return false
        if (restore != other.restore) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (sseCustomerAlgorithm != other.sseCustomerAlgorithm) return false
        if (sseCustomerKeyMd5 != other.sseCustomerKeyMd5) return false
        if (ssekmsKeyId != other.ssekmsKeyId) return false
        if (storageClass != other.storageClass) return false
        if (tagCount != other.tagCount) return false
        if (versionId != other.versionId) return false
        if (websiteRedirectLocation != other.websiteRedirectLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.GetObjectResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates that a range of bytes was specified in the request.
         */
        public var acceptRanges: kotlin.String? = null
        /**
         * Object data.
         */
        public var body: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * Indicates whether the object uses an S3 Bucket Key for server-side encryption with Key Management Service (KMS) keys (SSE-KMS).
         *
         * This functionality is not supported for directory buckets.
         */
        public var bucketKeyEnabled: kotlin.Boolean? = null
        /**
         * Specifies caching behavior along the request/reply chain.
         */
        public var cacheControl: kotlin.String? = null
        /**
         * The base64-encoded, 32-bit CRC32 checksum of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         */
        public var checksumCrc32: kotlin.String? = null
        /**
         * The base64-encoded, 32-bit CRC32C checksum of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         */
        public var checksumCrc32C: kotlin.String? = null
        /**
         * The base64-encoded, 160-bit SHA-1 digest of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         */
        public var checksumSha1: kotlin.String? = null
        /**
         * The base64-encoded, 256-bit SHA-256 digest of the object. This will only be present if it was uploaded with the object. For more information, see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         */
        public var checksumSha256: kotlin.String? = null
        /**
         * Specifies presentational information for the object.
         */
        public var contentDisposition: kotlin.String? = null
        /**
         * Indicates what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.
         */
        public var contentEncoding: kotlin.String? = null
        /**
         * The language the content is in.
         */
        public var contentLanguage: kotlin.String? = null
        /**
         * Size of the body in bytes.
         */
        public var contentLength: kotlin.Long? = null
        /**
         * The portion of the object returned in the response.
         */
        public var contentRange: kotlin.String? = null
        /**
         * A standard MIME type describing the format of the object data.
         */
        public var contentType: kotlin.String? = null
        /**
         * Indicates whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.
         *
         * + If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and includes `x-amz-delete-marker: true` in the response.
         * + If the specified version in the request is a delete marker, the response returns a `405 Method Not Allowed` error and the `Last-Modified: timestamp` response header.
         */
        public var deleteMarker: kotlin.Boolean? = null
        /**
         * An entity tag (ETag) is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.
         */
        public var eTag: kotlin.String? = null
        /**
         * If the object expiration is configured (see `PutBucketLifecycleConfiguration`[](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)), the response includes this header. It includes the `expiry-date` and `rule-id` key-value pairs providing object expiration information. The value of the `rule-id` is URL-encoded.
         *
         * This functionality is not supported for directory buckets.
         */
        public var expiration: kotlin.String? = null
        /**
         * The date and time at which the object is no longer cacheable.
         */
        public var expires: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Date and time when the object was last modified.
         *
         * **General purpose buckets ** - When you specify a `versionId` of the object in your request, if the specified version in the request is a delete marker, the response returns a `405 Method Not Allowed` error and the `Last-Modified: timestamp` response header.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A map of metadata to store with the object in S3.
         */
        public var metadata: Map<String, String>? = null
        /**
         * This is set to the number of metadata entries not returned in the headers that are prefixed with `x-amz-meta-`. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.
         *
         * This functionality is not supported for directory buckets.
         */
        public var missingMeta: kotlin.Int? = null
        /**
         * Indicates whether this object has an active legal hold. This field is only returned if you have permission to view an object's legal hold status.
         *
         * This functionality is not supported for directory buckets.
         */
        public var objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3.model.ObjectLockLegalHoldStatus? = null
        /**
         * The Object Lock mode that's currently in place for this object.
         *
         * This functionality is not supported for directory buckets.
         */
        public var objectLockMode: aws.sdk.kotlin.services.s3.model.ObjectLockMode? = null
        /**
         * The date and time when this object's Object Lock will expire.
         *
         * This functionality is not supported for directory buckets.
         */
        public var objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The count of parts this object has. This value is only returned if you specify `partNumber` in your request and the object was uploaded as a multipart upload.
         */
        public var partsCount: kotlin.Int? = null
        /**
         * Amazon S3 can return this if your request involves a bucket that is either a source or destination in a replication rule.
         *
         * This functionality is not supported for directory buckets.
         */
        public var replicationStatus: aws.sdk.kotlin.services.s3.model.ReplicationStatus? = null
        /**
         * If present, indicates that the requester was successfully charged for the request.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestCharged: aws.sdk.kotlin.services.s3.model.RequestCharged? = null
        /**
         * Provides information about object restoration action and expiration time of the restored object copy.
         *
         * This functionality is not supported for directory buckets. Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
         */
        public var restore: kotlin.String? = null
        /**
         * The server-side encryption algorithm used when you store this object in Amazon S3 (for example, `AES256`, `aws:kms`, `aws:kms:dsse`).
         *
         * For directory buckets, only server-side encryption with Amazon S3 managed keys (SSE-S3) (`AES256`) is supported.
         */
        public var serverSideEncryption: aws.sdk.kotlin.services.s3.model.ServerSideEncryption? = null
        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include this header to confirm the encryption algorithm that's used.
         *
         * This functionality is not supported for directory buckets.
         */
        public var sseCustomerAlgorithm: kotlin.String? = null
        /**
         * If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide the round-trip message integrity verification of the customer-provided encryption key.
         *
         * This functionality is not supported for directory buckets.
         */
        public var sseCustomerKeyMd5: kotlin.String? = null
        /**
         * If present, indicates the ID of the Key Management Service (KMS) symmetric encryption customer managed key that was used for the object.
         *
         * This functionality is not supported for directory buckets.
         */
        public var ssekmsKeyId: kotlin.String? = null
        /**
         * Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.
         *
         * **Directory buckets ** - Only the S3 Express One Zone storage class is supported by directory buckets to store objects.
         */
        public var storageClass: aws.sdk.kotlin.services.s3.model.StorageClass? = null
        /**
         * The number of tags, if any, on the object, when you have the relevant permission to read object tags.
         *
         * You can use [GetObjectTagging](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html) to retrieve the tag set associated with an object.
         *
         * This functionality is not supported for directory buckets.
         */
        public var tagCount: kotlin.Int? = null
        /**
         * Version ID of the object.
         *
         * This functionality is not supported for directory buckets.
         */
        public var versionId: kotlin.String? = null
        /**
         * If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.
         *
         * This functionality is not supported for directory buckets.
         */
        public var websiteRedirectLocation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.GetObjectResponse) : this() {
            this.acceptRanges = x.acceptRanges
            this.body = x.body
            this.bucketKeyEnabled = x.bucketKeyEnabled
            this.cacheControl = x.cacheControl
            this.checksumCrc32 = x.checksumCrc32
            this.checksumCrc32C = x.checksumCrc32C
            this.checksumSha1 = x.checksumSha1
            this.checksumSha256 = x.checksumSha256
            this.contentDisposition = x.contentDisposition
            this.contentEncoding = x.contentEncoding
            this.contentLanguage = x.contentLanguage
            this.contentLength = x.contentLength
            this.contentRange = x.contentRange
            this.contentType = x.contentType
            this.deleteMarker = x.deleteMarker
            this.eTag = x.eTag
            this.expiration = x.expiration
            this.expires = x.expires
            this.lastModified = x.lastModified
            this.metadata = x.metadata
            this.missingMeta = x.missingMeta
            this.objectLockLegalHoldStatus = x.objectLockLegalHoldStatus
            this.objectLockMode = x.objectLockMode
            this.objectLockRetainUntilDate = x.objectLockRetainUntilDate
            this.partsCount = x.partsCount
            this.replicationStatus = x.replicationStatus
            this.requestCharged = x.requestCharged
            this.restore = x.restore
            this.serverSideEncryption = x.serverSideEncryption
            this.sseCustomerAlgorithm = x.sseCustomerAlgorithm
            this.sseCustomerKeyMd5 = x.sseCustomerKeyMd5
            this.ssekmsKeyId = x.ssekmsKeyId
            this.storageClass = x.storageClass
            this.tagCount = x.tagCount
            this.versionId = x.versionId
            this.websiteRedirectLocation = x.websiteRedirectLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.GetObjectResponse = GetObjectResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
