// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.IntelligentTieringAccessTier
import aws.sdk.kotlin.services.s3.model.InvalidObjectState
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class InvalidObjectStateDeserializer: HttpDeserialize<InvalidObjectState> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InvalidObjectState {
        val response = call.response
        val builder = InvalidObjectState.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeInvalidObjectStateError(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

internal fun deserializeInvalidObjectStateError(builder: InvalidObjectState.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val errReader = unwrapXmlErrorResponse(root)

    loop@while (true) {
        val curr = errReader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessTier com.amazonaws.s3#InvalidObjectState$AccessTier
            "AccessTier" -> builder.accessTier = curr.tryData()
                .parse { IntelligentTieringAccessTier.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#IntelligentTieringAccessTier`)" }
            // StorageClass com.amazonaws.s3#InvalidObjectState$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { StorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#StorageClass`)" }
            else -> {}
        }
        curr.drop()
    }
}
