// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.CommonPrefix
import aws.sdk.kotlin.services.s3.model.EncodingType
import aws.sdk.kotlin.services.s3.model.ListMultipartUploadsResponse
import aws.sdk.kotlin.services.s3.model.MultipartUpload
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListMultipartUploadsOperationDeserializer: HttpDeserialize<ListMultipartUploadsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListMultipartUploadsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListMultipartUploadsError(context, call)
        }
        val builder = ListMultipartUploadsResponse.Builder()

        builder.requestCharged = response.headers["x-amz-request-charged"]?.let { RequestCharged.fromValue(it) }

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListMultipartUploadsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListMultipartUploadsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null && call.response.status == HttpStatusCode.NotFound) {
            S3ErrorDetails(code = "NotFound")
        } else {
            checkNotNull(payload){ "unable to parse error from empty response" }
            parseS3ErrorResponse(payload)
        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as 'restXml' error", ex).also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListMultipartUploadsOperationBody(builder: ListMultipartUploadsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // Bucket com.amazonaws.s3#ListMultipartUploadsOutput$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#BucketName`)" }
            // CommonPrefixes com.amazonaws.s3#ListMultipartUploadsOutput$CommonPrefixes
            "CommonPrefixes" -> builder.commonPrefixes = run {
                val el = deserializeCommonPrefixDocument(curr)
                createOrAppend(builder.commonPrefixes, el)
            }
            // Delimiter com.amazonaws.s3#ListMultipartUploadsOutput$Delimiter
            "Delimiter" -> builder.delimiter = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Delimiter`)" }
            // EncodingType com.amazonaws.s3#ListMultipartUploadsOutput$EncodingType
            "EncodingType" -> builder.encodingType = curr.tryData()
                .parse { EncodingType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#EncodingType`)" }
            // IsTruncated com.amazonaws.s3#ListMultipartUploadsOutput$IsTruncated
            "IsTruncated" -> builder.isTruncated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsTruncated`)" }
            // KeyMarker com.amazonaws.s3#ListMultipartUploadsOutput$KeyMarker
            "KeyMarker" -> builder.keyMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#KeyMarker`)" }
            // MaxUploads com.amazonaws.s3#ListMultipartUploadsOutput$MaxUploads
            "MaxUploads" -> builder.maxUploads = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#MaxUploads`)" }
            // NextKeyMarker com.amazonaws.s3#ListMultipartUploadsOutput$NextKeyMarker
            "NextKeyMarker" -> builder.nextKeyMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextKeyMarker`)" }
            // NextUploadIdMarker com.amazonaws.s3#ListMultipartUploadsOutput$NextUploadIdMarker
            "NextUploadIdMarker" -> builder.nextUploadIdMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextUploadIdMarker`)" }
            // Prefix com.amazonaws.s3#ListMultipartUploadsOutput$Prefix
            "Prefix" -> builder.prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Prefix`)" }
            // UploadIdMarker com.amazonaws.s3#ListMultipartUploadsOutput$UploadIdMarker
            "UploadIdMarker" -> builder.uploadIdMarker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#UploadIdMarker`)" }
            // Uploads com.amazonaws.s3#ListMultipartUploadsOutput$Uploads
            "Upload" -> builder.uploads = run {
                val el = deserializeMultipartUploadDocument(curr)
                createOrAppend(builder.uploads, el)
            }
            else -> {}
        }
        curr.drop()
    }
}
