// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.EncodingType
import aws.sdk.kotlin.services.s3.model.ListMultipartUploadsRequest
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ListMultipartUploadsOperationSerializer: HttpSerialize<ListMultipartUploadsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListMultipartUploadsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            path.trailingSlash = true
            parameters.decodedParameters {
                add("uploads", "")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.delimiter != null) add("delimiter", input.delimiter)
                if (input.encodingType != null) add("encoding-type", input.encodingType.value)
                if (input.keyMarker != null) add("key-marker", input.keyMarker)
                if (input.maxUploads != null) add("max-uploads", "${input.maxUploads}")
                if (input.prefix != null) add("prefix", input.prefix)
                if (input.uploadIdMarker != null) add("upload-id-marker", input.uploadIdMarker)
            }
        }

        builder.headers {
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
        }

        return builder
    }
}
