/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.collections.views;

import aws.smithy.kotlin.runtime.collections.views.CollectionView;
import aws.smithy.kotlin.runtime.collections.views.ConvertersKt;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010*\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B;\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00028\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Laws/smithy/kotlin/runtime/collections/views/ListView;", "Src", "Dest", "", "Laws/smithy/kotlin/runtime/collections/views/CollectionView;", "src", "src2Dest", "Lkotlin/Function1;", "dest2Src", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "get", "index", "", "(I)Ljava/lang/Object;", "indexOf", "element", "(Ljava/lang/Object;)I", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "runtime-core"})
public class ListView<Src, Dest>
extends CollectionView<Src, Dest>
implements List<Dest>,
KMappedMarker {
    @NotNull
    private final List<Src> src;
    @NotNull
    private final Function1<Src, Dest> src2Dest;
    @NotNull
    private final Function1<Dest, Src> dest2Src;

    public ListView(@NotNull List<? extends Src> src, @NotNull Function1<? super Src, ? extends Dest> src2Dest, @NotNull Function1<? super Dest, ? extends Src> dest2Src) {
        Intrinsics.checkNotNullParameter(src, (String)"src");
        Intrinsics.checkNotNullParameter(src2Dest, (String)"src2Dest");
        Intrinsics.checkNotNullParameter(dest2Src, (String)"dest2Src");
        super((Collection)src, src2Dest, dest2Src);
        this.src = src;
        this.src2Dest = src2Dest;
        this.dest2Src = dest2Src;
    }

    @Override
    public Dest get(int index) {
        return (Dest)this.src2Dest.invoke(this.src.get(index));
    }

    @Override
    public int indexOf(Object element) {
        return this.src.indexOf(this.dest2Src.invoke(element));
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.src.lastIndexOf(this.dest2Src.invoke(element));
    }

    @Override
    @NotNull
    public ListIterator<Dest> listIterator() {
        return ConvertersKt.asView(this.src.listIterator(), this.src2Dest);
    }

    @Override
    @NotNull
    public ListIterator<Dest> listIterator(int index) {
        return ConvertersKt.asView(this.src.listIterator(index), this.src2Dest);
    }

    @Override
    @NotNull
    public List<Dest> subList(int fromIndex, int toIndex) {
        return ConvertersKt.asView(this.src.subList(fromIndex, toIndex), this.src2Dest, this.dest2Src);
    }

    @Override
    public void add(int index, Dest element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Dest> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Dest remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<Dest> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Dest set(int index, Dest element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super Dest> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

