/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.time;

import aws.smithy.kotlin.runtime.time.InstantJVMKt;
import aws.smithy.kotlin.runtime.time.ParsedDatetime;
import aws.smithy.kotlin.runtime.time.ParsersKt;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\nH\u0016J\u001b\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010\u001dJ\b\u0010 \u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"Laws/smithy/kotlin/runtime/time/Instant;", "", "value", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "epochSeconds", "", "getEpochSeconds", "()J", "nanosecondsOfSecond", "", "getNanosecondsOfSecond", "()I", "getValue$runtime_core", "()Ljava/time/Instant;", "compareTo", "other", "equals", "", "", "format", "", "fmt", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "hashCode", "minus", "duration", "Lkotlin/time/Duration;", "minus-LRDsOJo", "(J)Laws/smithy/kotlin/runtime/time/Instant;", "plus", "plus-LRDsOJo", "toString", "Companion", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nInstantJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstantJVM.kt\naws/smithy/kotlin/runtime/time/Instant\n+ 2 Duration.kt\nkotlin/time/Duration\n*L\n1#1,234:1\n731#2,2:235\n*S KotlinDebug\n*F\n+ 1 InstantJVM.kt\naws/smithy/kotlin/runtime/time/Instant\n*L\n48#1:235,2\n*E\n"})
public final class Instant
implements Comparable<Instant> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.Instant value;
    @NotNull
    private static final DateTimeFormatter RFC_5322_FIXED_DATE_TIME = InstantJVMKt.access$buildRfc5322Formatter();
    private static final ZoneId utcZone = ZoneId.of("Z");
    @NotNull
    private static final DateTimeFormatter ISO_8601_CONDENSED;
    @NotNull
    private static final DateTimeFormatter ISO_8601_CONDENSED_DATE;
    @NotNull
    private static final Instant MIN_VALUE;
    @NotNull
    private static final Instant MAX_VALUE;

    public Instant(@NotNull java.time.Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final java.time.Instant getValue$runtime_core() {
        return this.value;
    }

    public final long getEpochSeconds() {
        return this.value.getEpochSecond();
    }

    public final int getNanosecondsOfSecond() {
        return this.value.getNano();
    }

    @Override
    public int compareTo(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Instant && Intrinsics.areEqual((Object)this.value, (Object)((Instant)other).value);
    }

    @NotNull
    public String toString() {
        return this.format(TimestampFormat.ISO_8601);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Instant plus-LRDsOJo(long duration) {
        void nanoseconds;
        boolean bl = false;
        int n = Duration.getNanosecondsComponent-impl((long)duration);
        long seconds = Duration.getInWholeSeconds-impl((long)duration);
        boolean bl2 = false;
        return Companion.fromEpochSeconds(this.getEpochSeconds() + seconds, this.getNanosecondsOfSecond() + nanoseconds);
    }

    @NotNull
    public final Instant minus-LRDsOJo(long duration) {
        return this.plus-LRDsOJo(Duration.unaryMinus-UwyO8pc((long)duration));
    }

    @NotNull
    public final String format(@NotNull TimestampFormat fmt) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)fmt), (String)"fmt");
        switch (WhenMappings.$EnumSwitchMapping$0[fmt.ordinal()]) {
            case 1: {
                String string2 = DateTimeFormatter.ISO_INSTANT.format(this.value.truncatedTo(ChronoUnit.MICROS));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                break;
            }
            case 2: {
                String string3 = ISO_8601_CONDENSED.format(this.value);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                break;
            }
            case 3: {
                String string4 = ISO_8601_CONDENSED_DATE.format(this.value);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                break;
            }
            case 4: {
                String string5 = RFC_5322_FIXED_DATE_TIME.format(ZonedDateTime.ofInstant(this.value, ZoneOffset.UTC));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                break;
            }
            case 5: {
                StringBuffer sb = new StringBuffer(String.valueOf(this.getEpochSeconds()));
                if (this.getNanosecondsOfSecond() > 0) {
                    sb.append(".");
                    String ns = String.valueOf(this.getNanosecondsOfSecond());
                    String leadingZeros = StringsKt.repeat((CharSequence)"0", (int)(9 - ns.length()));
                    sb.append(leadingZeros);
                    sb.append(ns);
                    char[] cArray = new char[]{'0'};
                    string = ((Object)StringsKt.trimEnd((CharSequence)sb, (char[])cArray)).toString();
                    break;
                }
                String string6 = sb.toString();
                Intrinsics.checkNotNull((Object)string6);
                string = string6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(utcZone);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        ISO_8601_CONDENSED = dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(utcZone);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"withZone(...)");
        ISO_8601_CONDENSED_DATE = dateTimeFormatter2;
        java.time.Instant instant = java.time.Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        MIN_VALUE = new Instant(instant);
        java.time.Instant instant2 = java.time.Instant.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"MAX");
        MAX_VALUE = new Instant(instant2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/time/Instant$Companion;", "", "()V", "ISO_8601_CONDENSED", "Ljava/time/format/DateTimeFormatter;", "ISO_8601_CONDENSED_DATE", "MAX_VALUE", "Laws/smithy/kotlin/runtime/time/Instant;", "getMAX_VALUE", "()Laws/smithy/kotlin/runtime/time/Instant;", "MIN_VALUE", "getMIN_VALUE", "RFC_5322_FIXED_DATE_TIME", "utcZone", "Ljava/time/ZoneId;", "kotlin.jvm.PlatformType", "fromEpochSeconds", "seconds", "", "ns", "", "ts", "", "fromIso8601", "fromRfc5322", "now", "runtime-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Instant fromIso8601(@NotNull String ts) {
            Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
            ParsedDatetime parsed = ParsersKt.parseIso8601(ts);
            return InstantJVMKt.access$fromParsedDateTime(parsed);
        }

        @NotNull
        public final Instant fromRfc5322(@NotNull String ts) {
            Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
            ParsedDatetime parsed = ParsersKt.parseRfc5322(ts);
            return InstantJVMKt.access$fromParsedDateTime(parsed);
        }

        @NotNull
        public final Instant fromEpochSeconds(long seconds, int ns) {
            java.time.Instant instant = java.time.Instant.ofEpochSecond(seconds, ns);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
            return new Instant(instant);
        }

        public static /* synthetic */ Instant fromEpochSeconds$default(Companion companion, long l, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromEpochSeconds(l, n);
        }

        @NotNull
        public final Instant fromEpochSeconds(@NotNull String ts) {
            Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
            return ParsersKt.parseEpoch(ts);
        }

        @NotNull
        public final Instant now() {
            java.time.Instant instant = java.time.Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            return new Instant(instant);
        }

        @NotNull
        public final Instant getMIN_VALUE() {
            return MIN_VALUE;
        }

        @NotNull
        public final Instant getMAX_VALUE() {
            return MAX_VALUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampFormat.values().length];
            try {
                nArray[TimestampFormat.ISO_8601.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_CONDENSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.ISO_8601_CONDENSED_DATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.RFC_5322.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormat.EPOCH_SECONDS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

