/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.compression;

import aws.smithy.kotlin.runtime.compression.CompressionAlgorithm;
import aws.smithy.kotlin.runtime.content.ByteStream;
import aws.smithy.kotlin.runtime.io.GzipByteReadChannel;
import aws.smithy.kotlin.runtime.io.GzipSdkSource;
import aws.smithy.kotlin.runtime.io.SdkByteReadChannel;
import aws.smithy.kotlin.runtime.io.SdkSource;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\f"}, d2={"Laws/smithy/kotlin/runtime/compression/Gzip;", "Laws/smithy/kotlin/runtime/compression/CompressionAlgorithm;", "()V", "contentEncoding", "", "getContentEncoding", "()Ljava/lang/String;", "id", "getId", "compress", "Laws/smithy/kotlin/runtime/content/ByteStream;", "stream", "runtime-core"})
public final class Gzip
implements CompressionAlgorithm {
    @NotNull
    private final String id;
    @NotNull
    private final String contentEncoding;

    public Gzip() {
        this.id = "gzip";
        this.contentEncoding = "gzip";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    @NotNull
    public ByteStream compress(@NotNull ByteStream stream) {
        ByteStream byteStream;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        ByteStream byteStream2 = stream;
        if (byteStream2 instanceof ByteStream.Buffer) {
            byteStream = new ByteStream.Buffer(stream){
                @Nullable
                private final Long contentLength;
                final /* synthetic */ ByteStream $stream;
                {
                    this.$stream = $stream;
                }

                @NotNull
                public byte[] bytes() {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    gzipOutputStream.write(((ByteStream.Buffer)this.$stream).bytes());
                    gzipOutputStream.close();
                    byte[] compressedBody = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    Intrinsics.checkNotNull((Object)compressedBody);
                    return compressedBody;
                }

                @Nullable
                public Long getContentLength() {
                    return this.contentLength;
                }
            };
        } else if (byteStream2 instanceof ByteStream.ChannelStream) {
            byteStream = new ByteStream.ChannelStream(stream){
                @Nullable
                private final Long contentLength;
                private final boolean isOneShot;
                final /* synthetic */ ByteStream $stream;
                {
                    this.$stream = $stream;
                    this.isOneShot = $stream.isOneShot();
                }

                @NotNull
                public SdkByteReadChannel readFrom() {
                    return new GzipByteReadChannel(((ByteStream.ChannelStream)this.$stream).readFrom());
                }

                @Nullable
                public Long getContentLength() {
                    return this.contentLength;
                }

                public boolean isOneShot() {
                    return this.isOneShot;
                }
            };
        } else if (byteStream2 instanceof ByteStream.SourceStream) {
            byteStream = new ByteStream.SourceStream(stream){
                @Nullable
                private final Long contentLength;
                private final boolean isOneShot;
                final /* synthetic */ ByteStream $stream;
                {
                    this.$stream = $stream;
                    this.isOneShot = $stream.isOneShot();
                }

                @NotNull
                public SdkSource readFrom() {
                    return new GzipSdkSource(((ByteStream.SourceStream)this.$stream).readFrom());
                }

                @Nullable
                public Long getContentLength() {
                    return this.contentLength;
                }

                public boolean isOneShot() {
                    return this.isOneShot;
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byteStream;
    }
}

