/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.retries.delay;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.retries.delay.DelayProvider;
import aws.smithy.kotlin.runtime.util.DslFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider;", "config", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "(Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;)V", "getConfig", "()Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "random", "Lkotlin/random/Random$Default;", "backoff", "", "attempt", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "Config", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nExponentialBackoffWithJitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExponentialBackoffWithJitter.kt\naws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class ExponentialBackoffWithJitter
implements DelayProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final Random.Default random;

    public ExponentialBackoffWithJitter(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.config = config2;
        this.random = Random.Default;
    }

    public /* synthetic */ ExponentialBackoffWithJitter(Config config2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config2 = Config.Companion.getDefault();
        }
        this(config2);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    @Nullable
    public Object backoff(int attempt, @NotNull Continuation<? super Unit> $completion) {
        if (!(attempt > 0)) {
            boolean bl = false;
            String string = "attempt was " + attempt + " but must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        double calculatedDelayMs = (double)Duration.getInWholeMilliseconds-impl((long)this.getConfig().getInitialDelay-UwyO8pc()) * Math.pow(this.getConfig().getScaleFactor(), attempt - 1);
        double maxDelayMs = Math.min(calculatedDelayMs, Duration.toDouble-impl((long)this.getConfig().getMaxBackoff-UwyO8pc(), (DurationUnit)DurationUnit.MILLISECONDS));
        double jitterProportion = this.getConfig().getJitter() > 0.0 ? this.random.nextDouble(this.getConfig().getJitter()) : 0.0;
        double delayMs = maxDelayMs * (1.0 - jitterProportion);
        Object object = DelayKt.delay((long)((long)delayMs), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public ExponentialBackoffWithJitter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00032\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tH\u0096\u0002\u00a8\u0006\n"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Companion;", "Laws/smithy/kotlin/runtime/util/DslFactory;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter;", "()V", "invoke", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "runtime-core"})
    public static final class Companion
    implements DslFactory<Config.Builder, ExponentialBackoffWithJitter> {
        private Companion() {
        }

        @Override
        @NotNull
        public ExponentialBackoffWithJitter invoke(@NotNull Function1<? super Config.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return new ExponentialBackoffWithJitter(Config.Companion.invoke(block));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016H\u0017R\u0019\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider$Config;", "builder", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "(Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;)V", "initialDelay", "Lkotlin/time/Duration;", "getInitialDelay-UwyO8pc", "()J", "J", "jitter", "", "getJitter", "()D", "maxBackoff", "getMaxBackoff-UwyO8pc", "scaleFactor", "getScaleFactor", "toBuilderApplicator", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider$Config$Builder;", "", "Lkotlin/ExtensionFunctionType;", "Builder", "Companion", "runtime-core"})
    public static final class Config
    implements DelayProvider.Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long initialDelay;
        private final double scaleFactor;
        private final double jitter;
        private final long maxBackoff;
        @NotNull
        private static final Config Default = new Config(new Builder());

        public Config(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.initialDelay = builder.getInitialDelay-UwyO8pc();
            this.scaleFactor = builder.getScaleFactor();
            this.jitter = builder.getJitter();
            this.maxBackoff = builder.getMaxBackoff-UwyO8pc();
        }

        public final long getInitialDelay-UwyO8pc() {
            return this.initialDelay;
        }

        public final double getScaleFactor() {
            return this.scaleFactor;
        }

        public final double getJitter() {
            return this.jitter;
        }

        public final long getMaxBackoff-UwyO8pc() {
            return this.maxBackoff;
        }

        @Override
        @InternalApi
        @NotNull
        public Function1<DelayProvider.Config.Builder, Unit> toBuilderApplicator() {
            return (Function1)new Function1<DelayProvider.Config.Builder, Unit>(this){
                final /* synthetic */ Config this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull DelayProvider.Config.Builder $this$null) {
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    if ($this$null instanceof Builder) {
                        ((Builder)$this$null).setInitialDelay-LRDsOJo(this.this$0.getInitialDelay-UwyO8pc());
                        ((Builder)$this$null).setScaleFactor(this.this$0.getScaleFactor());
                        ((Builder)$this$null).setJitter(this.this$0.getJitter());
                        ((Builder)$this$null).setMaxBackoff-LRDsOJo(this.this$0.getMaxBackoff-UwyO8pc());
                    }
                }
            };
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u00020\u0004X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\bR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "Laws/smithy/kotlin/runtime/retries/delay/DelayProvider$Config$Builder;", "()V", "initialDelay", "Lkotlin/time/Duration;", "getInitialDelay-UwyO8pc", "()J", "setInitialDelay-LRDsOJo", "(J)V", "J", "jitter", "", "getJitter", "()D", "setJitter", "(D)V", "maxBackoff", "getMaxBackoff-UwyO8pc", "setMaxBackoff-LRDsOJo", "scaleFactor", "getScaleFactor", "setScaleFactor", "runtime-core"})
        public static final class Builder
        implements DelayProvider.Config.Builder {
            private long initialDelay = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MILLISECONDS);
            private double scaleFactor = 1.5;
            private double jitter = 1.0;
            private long maxBackoff = DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.SECONDS);

            public final long getInitialDelay-UwyO8pc() {
                return this.initialDelay;
            }

            public final void setInitialDelay-LRDsOJo(long l) {
                this.initialDelay = l;
            }

            public final double getScaleFactor() {
                return this.scaleFactor;
            }

            public final void setScaleFactor(double d) {
                this.scaleFactor = d;
            }

            public final double getJitter() {
                return this.jitter;
            }

            public final void setJitter(double d) {
                this.jitter = d;
            }

            public final long getMaxBackoff-UwyO8pc() {
                return this.maxBackoff;
            }

            public final void setMaxBackoff-LRDsOJo(long l) {
                this.maxBackoff = l;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\u00042\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Companion;", "", "()V", "Default", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "getDefault", "()Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config;", "invoke", "block", "Lkotlin/Function1;", "Laws/smithy/kotlin/runtime/retries/delay/ExponentialBackoffWithJitter$Config$Builder;", "", "Lkotlin/ExtensionFunctionType;", "runtime-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Config getDefault() {
                return Default;
            }

            @NotNull
            public final Config invoke(@NotNull Function1<? super Builder, Unit> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                Builder builder = new Builder();
                block.invoke((Object)builder);
                return new Config(builder);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

