/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration;

import co.kuali.coeus.data.migration.custom.CoeusMigrationResolver;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlywayMigrator {
    private static final Logger LOG = LoggerFactory.getLogger(FlywayMigrator.class);
    protected String initVersion;
    protected DataSource dataSource;
    protected DataSource riceDataSource;
    protected CoeusMigrationResolver coeusMigrationResolver;
    protected String sqlMigrationPath;
    protected String javaMigrationPath;
    protected String kcPath = "kc";
    protected String ricePath = "rice";
    protected String riceServer = "rice_server";
    protected String riceDataOnly = "rice_data_only";
    protected String embeddedClientScripts = "kc/embedded_client_scripts";
    protected String bootstrapPath = "bootstrap";
    protected String testingPath = "testing";
    protected String stagingDataPath = "staging";
    protected String demoDataPath = "demo";
    protected String grmDataPath = "grm";
    protected Boolean enabled;
    protected Boolean applyTesting;
    protected Boolean applyStaging;
    protected Boolean applyDemo;
    protected Boolean grm;
    protected Boolean manageRice;
    protected Boolean embeddedMode;
    private List<String> mysqlPreMigrationSql = new ArrayList<String>(){
        {
            this.add("update schema_version set checksum = 1918600927 where version = '601.017'");
            this.add("update schema_version set checksum = 1404031275 where version = '601.023'");
            this.add("update schema_version set checksum = 1179166139 where version = '601.024'");
            this.add("update schema_version set checksum = -1603565051 where version = '1506.018'");
            this.add("update schema_version set checksum = 2015457550 where version = '1507.005'");
            this.add("update schema_version set checksum = -762710623 where version = '602.010'");
            this.add("update schema_version set checksum = -908474437 where version = '1507.021'");
            this.add("update schema_version set checksum = -1186567654 where version = '1508.005'");
            this.add("update schema_version set checksum = -685100822 where version ='1509.003'");
            this.add("update schema_version set checksum = -1409970834 where version = '1510.004'");
            this.add("update schema_version set checksum = -1941154260 where version = '1510.005'");
            this.add("update schema_version set checksum = -1637553841 where version = '1508.008'");
            this.add("update schema_version set checksum = 2027168568 where version = '1510.002'");
            this.add("update schema_version set checksum = -774762741 where version = '1510.012'");
        }
    };
    private List<String> oraclePreMigrationSql = new ArrayList<String>(){
        {
            this.add("update \"schema_version\" set \"checksum\" = -1680368468 where \"version\" = '602.010'");
            this.add("update \"schema_version\" set \"checksum\" = -908474437 where \"version\" = '1507.021'");
            this.add("update \"schema_version\" set \"checksum\" = 46590859 where \"version\" = '1509.003'");
            this.add("update \"schema_version\" set \"checksum\" = -1975851000 where \"version\" = '1510.004'");
            this.add("update \"schema_version\" set \"checksum\" = -1564650848 where \"version\" = '1510.005'");
            this.add("update \"schema_version\" set \"checksum\" = 2011481093 where \"version\" = '1508.008'");
            this.add("update \"schema_version\" set \"checksum\" = -432638131 where \"version\" = '1510.002'");
        }
    };

    public void migrate() throws SQLException {
        if (!this.enabled.booleanValue()) {
            LOG.info("Flyway Migration is not enabled. Skipping.");
            return;
        }
        if (this.dataSource == null) {
            throw new IllegalStateException("dataSource == null");
        }
        if (this.riceDataSource == null) {
            throw new IllegalStateException("riceDataSource == null");
        }
        if (!this.embeddedMode.booleanValue()) {
            this.manageRice = true;
        }
        ArrayList<String> kcLocations = new ArrayList<String>();
        kcLocations.addAll(this.buildLocations(this.kcPath));
        if (!this.embeddedMode.booleanValue()) {
            kcLocations.addAll(this.buildLocations(this.ricePath));
            kcLocations.addAll(this.buildLocations(this.riceServer));
        } else {
            kcLocations.add(this.embeddedClientScripts);
        }
        if (this.grm.booleanValue()) {
            kcLocations.add(this.grmDataPath);
        }
        this.coeusMigrationResolver = new CoeusMigrationResolver(this.riceDataSource);
        this.coeusMigrationResolver.setJavaMigrationPath(this.getJavaMigrationPath());
        this.performMigration(this.dataSource, kcLocations, this.coeusMigrationResolver);
        if (this.embeddedMode.booleanValue()) {
            ArrayList<String> riceLocations = new ArrayList<String>();
            riceLocations.addAll(this.buildLocations(this.ricePath));
            if (this.manageRice.booleanValue()) {
                riceLocations.addAll(this.buildLocations(this.riceServer));
            } else {
                riceLocations.addAll(this.buildLocations(this.riceDataOnly));
            }
            this.performMigration(this.riceDataSource, riceLocations, new MigrationResolver[0]);
        }
    }

    protected void performMigration(DataSource dataSource, List<String> locations, MigrationResolver ... migrationResolvers) {
        this.runPreMigrationSql(dataSource);
        Flyway flyway = new Flyway();
        flyway.setDataSource(dataSource);
        flyway.setLocations(this.filterForExistence(this.prefixLocationsWithDb(this.getSqlMigrationPath(), locations)));
        flyway.setResolvers(migrationResolvers);
        flyway.setPlaceholderPrefix("PLACEHOLDERS_DISABLED$$$$$");
        flyway.setBaselineOnMigrate(true);
        flyway.setBaselineVersion(MigrationVersion.fromVersion((String)this.getBaselineVersion(dataSource)));
        for (MigrationInfo i : flyway.info().all()) {
            LOG.info("flyway migration: " + i.getVersion() + " : '" + i.getDescription() + "' from file: " + i.getScript());
        }
        int numApplied = flyway.migrate();
        LOG.info("flyway migrations applied: " + numApplied);
    }

    protected String[] prefixLocationsWithDb(String dbPath, List<String> locations) {
        String[] result = new String[locations.size()];
        for (int i = 0; i < locations.size(); ++i) {
            result[i] = dbPath + "/" + locations.get(i);
        }
        return result;
    }

    protected String[] filterForExistence(String ... locations) {
        ArrayList<String> result = new ArrayList<String>();
        for (String location : locations) {
            if (this.getClass().getClassLoader().getResource(location) == null) continue;
            result.add(location);
        }
        return result.toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getBaselineVersion(DataSource dataSource) {
        String maxVersion = "0";
        try (Connection conn = dataSource.getConnection();){
            ResultSet rs = conn.createStatement().executeQuery("select max(version) from schema_version");
            if (rs.next()) {
                maxVersion = rs.getString(1);
            }
            if (Double.valueOf(maxVersion).compareTo(2.014E11) <= 0) return "0";
            conn.createStatement().executeUpdate("delete from schema_version");
            String string = "600";
            return string;
        }
        catch (Exception e) {
            LOG.warn("Unable to detect flyway schema version " + e.getMessage());
        }
        return "0";
    }

    protected void runPreMigrationSql(DataSource dataSource) {
        try (Connection conn = dataSource.getConnection();){
            String databaseProductName = conn.getMetaData().getDatabaseProductName();
            if (StringUtils.containsIgnoreCase((CharSequence)databaseProductName, (CharSequence)"oracle")) {
                this.runSpecificPreMigrationSql(conn, this.oraclePreMigrationSql);
            } else {
                this.runSpecificPreMigrationSql(conn, this.mysqlPreMigrationSql);
            }
        }
        catch (SQLException e) {
            LOG.warn("Error getting connection to run pre migration sql " + e.getMessage());
        }
    }

    void runSpecificPreMigrationSql(Connection conn, List<String> preMigrationSql) {
        for (String preSql : preMigrationSql) {
            try {
                Statement stmt = conn.createStatement();
                Throwable throwable = null;
                try {
                    stmt.executeUpdate(preSql);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmt == null) continue;
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LOG.warn("Error running pre migration sql " + e.getMessage());
            }
        }
    }

    protected List<String> buildLocations(String rootPath) {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add(rootPath + "/" + this.bootstrapPath);
        if (this.getApplyTesting().booleanValue()) {
            locations.add(rootPath + "/" + this.testingPath);
        }
        if (this.getApplyStaging().booleanValue()) {
            locations.add(rootPath + "/" + this.stagingDataPath);
        }
        if (this.getApplyDemo().booleanValue()) {
            locations.add(rootPath + "/" + this.demoDataPath);
        }
        return locations;
    }

    protected Boolean getDefinedOption(String option, Boolean defaultValue) {
        if (System.getProperty(option) != null) {
            return Boolean.valueOf(System.getProperty(option));
        }
        if (System.getenv().containsKey(option)) {
            return Boolean.valueOf(System.getProperty(option));
        }
        return defaultValue;
    }

    protected String getDefinedOption(String option, String defaultValue) {
        if (System.getProperty(option) != null) {
            return System.getProperty(option);
        }
        if (System.getenv().containsKey(option)) {
            return System.getProperty(option);
        }
        return defaultValue;
    }

    public void setInitVersion(String initVersion) {
        this.initVersion = initVersion;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getRiceDataSource() {
        return this.riceDataSource;
    }

    public void setRiceDataSource(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public String getBootstrapPath() {
        return this.bootstrapPath;
    }

    public void setBootstrapPath(String bootstrapPath) {
        this.bootstrapPath = bootstrapPath;
    }

    public String getTestingPath() {
        return this.testingPath;
    }

    public void setTestingPath(String testingPath) {
        this.testingPath = testingPath;
    }

    public String getStagingDataPath() {
        return this.stagingDataPath;
    }

    public void setStagingDataPath(String stagingDataPath) {
        this.stagingDataPath = stagingDataPath;
    }

    public String getDemoDataPath() {
        return this.demoDataPath;
    }

    public void setDemoDataPath(String demoDataPath) {
        this.demoDataPath = demoDataPath;
    }

    public String getGrmDataPath() {
        return this.grmDataPath;
    }

    public void setGrmDataPath(String grmDataPath) {
        this.grmDataPath = grmDataPath;
    }

    public Boolean getApplyTesting() {
        if (this.applyTesting == null) {
            this.applyTesting = this.getDefinedOption("kc.flyway.testing", Boolean.FALSE);
        }
        return this.applyTesting;
    }

    public void setApplyTesting(boolean applyTesting) {
        this.applyTesting = applyTesting;
    }

    public Boolean getApplyStaging() {
        if (this.applyStaging == null) {
            this.applyStaging = this.getDefinedOption("kc.flyway.staging", Boolean.FALSE);
        }
        return this.applyStaging;
    }

    public void setApplyStaging(boolean applyStaging) {
        this.applyStaging = applyStaging;
    }

    public Boolean getApplyDemo() {
        if (this.applyDemo == null) {
            this.applyDemo = this.getDefinedOption("kc.flyway.demo", Boolean.FALSE);
        }
        return this.applyDemo;
    }

    public void setApplyDemo(boolean applyDemo) {
        this.applyDemo = applyDemo;
    }

    public String getInitVersion() {
        return this.initVersion;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Boolean getManageRice() {
        if (this.manageRice == null) {
            this.manageRice = this.getDefinedOption("kc.flyway.manageRice", Boolean.TRUE);
        }
        return this.manageRice;
    }

    public void setManageRice(Boolean manageRice) {
        this.manageRice = manageRice;
    }

    public Boolean getEmbeddedMode() {
        if (this.embeddedMode == null) {
            this.embeddedMode = this.getDefinedOption("kc.flyway.embedded", Boolean.FALSE);
        }
        return this.embeddedMode;
    }

    public void setEmbeddedMode(Boolean embeddedMode) {
        this.embeddedMode = embeddedMode;
    }

    public Boolean getGrm() {
        if (this.embeddedMode == null) {
            this.embeddedMode = this.getDefinedOption("kc.flyway.grm", Boolean.FALSE);
        }
        return this.embeddedMode;
    }

    public void setGrm(Boolean grm) {
        this.grm = grm;
    }

    public CoeusMigrationResolver getCoeusMigrationResolver() {
        return this.coeusMigrationResolver;
    }

    public void setCoeusMigrationResolver(CoeusMigrationResolver coeusMigrationResolver) {
        this.coeusMigrationResolver = coeusMigrationResolver;
    }

    public Boolean getEnabled() {
        if (this.enabled == null) {
            this.enabled = this.getDefinedOption("kc.flyway.enabled", Boolean.TRUE);
        }
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getSqlMigrationPath() {
        if (this.sqlMigrationPath == null) {
            this.sqlMigrationPath = this.getDefinedOption("kc.flyway.sql.migration.path", "");
        }
        return this.sqlMigrationPath;
    }

    public void setSqlMigrationPath(String migrationPath) {
        this.sqlMigrationPath = migrationPath;
    }

    public String getJavaMigrationPath() {
        if (this.javaMigrationPath == null) {
            this.javaMigrationPath = this.getDefinedOption("kc.flyway.java.migration.path", "");
        }
        return this.javaMigrationPath;
    }

    public void setJavaMigrationPath(String javaMigrationPath) {
        this.javaMigrationPath = javaMigrationPath;
    }
}

