/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.Finding;
import com.amazonaws.services.computeoptimizer.model.InstanceRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.RecommendationSource;
import com.amazonaws.services.computeoptimizer.model.UtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.transform.InstanceRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class InstanceRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceArn;
    private String accountId;
    private String instanceName;
    private String currentInstanceType;
    private String finding;
    private List<UtilizationMetric> utilizationMetrics;
    private Double lookBackPeriodInDays;
    private List<InstanceRecommendationOption> recommendationOptions;
    private List<RecommendationSource> recommendationSources;
    private Date lastRefreshTimestamp;

    public void setInstanceArn(String instanceArn) {
        this.instanceArn = instanceArn;
    }

    public String getInstanceArn() {
        return this.instanceArn;
    }

    public InstanceRecommendation withInstanceArn(String instanceArn) {
        this.setInstanceArn(instanceArn);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public InstanceRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public InstanceRecommendation withInstanceName(String instanceName) {
        this.setInstanceName(instanceName);
        return this;
    }

    public void setCurrentInstanceType(String currentInstanceType) {
        this.currentInstanceType = currentInstanceType;
    }

    public String getCurrentInstanceType() {
        return this.currentInstanceType;
    }

    public InstanceRecommendation withCurrentInstanceType(String currentInstanceType) {
        this.setCurrentInstanceType(currentInstanceType);
        return this;
    }

    public void setFinding(String finding) {
        this.finding = finding;
    }

    public String getFinding() {
        return this.finding;
    }

    public InstanceRecommendation withFinding(String finding) {
        this.setFinding(finding);
        return this;
    }

    public InstanceRecommendation withFinding(Finding finding) {
        this.finding = finding.toString();
        return this;
    }

    public List<UtilizationMetric> getUtilizationMetrics() {
        return this.utilizationMetrics;
    }

    public void setUtilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
        if (utilizationMetrics == null) {
            this.utilizationMetrics = null;
            return;
        }
        this.utilizationMetrics = new ArrayList<UtilizationMetric>(utilizationMetrics);
    }

    public InstanceRecommendation withUtilizationMetrics(UtilizationMetric ... utilizationMetrics) {
        if (this.utilizationMetrics == null) {
            this.setUtilizationMetrics(new ArrayList<UtilizationMetric>(utilizationMetrics.length));
        }
        for (UtilizationMetric ele : utilizationMetrics) {
            this.utilizationMetrics.add(ele);
        }
        return this;
    }

    public InstanceRecommendation withUtilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
        this.setUtilizationMetrics(utilizationMetrics);
        return this;
    }

    public void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
        this.lookBackPeriodInDays = lookBackPeriodInDays;
    }

    public Double getLookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public InstanceRecommendation withLookBackPeriodInDays(Double lookBackPeriodInDays) {
        this.setLookBackPeriodInDays(lookBackPeriodInDays);
        return this;
    }

    public List<InstanceRecommendationOption> getRecommendationOptions() {
        return this.recommendationOptions;
    }

    public void setRecommendationOptions(Collection<InstanceRecommendationOption> recommendationOptions) {
        if (recommendationOptions == null) {
            this.recommendationOptions = null;
            return;
        }
        this.recommendationOptions = new ArrayList<InstanceRecommendationOption>(recommendationOptions);
    }

    public InstanceRecommendation withRecommendationOptions(InstanceRecommendationOption ... recommendationOptions) {
        if (this.recommendationOptions == null) {
            this.setRecommendationOptions(new ArrayList<InstanceRecommendationOption>(recommendationOptions.length));
        }
        for (InstanceRecommendationOption ele : recommendationOptions) {
            this.recommendationOptions.add(ele);
        }
        return this;
    }

    public InstanceRecommendation withRecommendationOptions(Collection<InstanceRecommendationOption> recommendationOptions) {
        this.setRecommendationOptions(recommendationOptions);
        return this;
    }

    public List<RecommendationSource> getRecommendationSources() {
        return this.recommendationSources;
    }

    public void setRecommendationSources(Collection<RecommendationSource> recommendationSources) {
        if (recommendationSources == null) {
            this.recommendationSources = null;
            return;
        }
        this.recommendationSources = new ArrayList<RecommendationSource>(recommendationSources);
    }

    public InstanceRecommendation withRecommendationSources(RecommendationSource ... recommendationSources) {
        if (this.recommendationSources == null) {
            this.setRecommendationSources(new ArrayList<RecommendationSource>(recommendationSources.length));
        }
        for (RecommendationSource ele : recommendationSources) {
            this.recommendationSources.add(ele);
        }
        return this;
    }

    public InstanceRecommendation withRecommendationSources(Collection<RecommendationSource> recommendationSources) {
        this.setRecommendationSources(recommendationSources);
        return this;
    }

    public void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public InstanceRecommendation withLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceArn() != null) {
            sb.append("InstanceArn: ").append(this.getInstanceArn()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getInstanceName() != null) {
            sb.append("InstanceName: ").append(this.getInstanceName()).append(",");
        }
        if (this.getCurrentInstanceType() != null) {
            sb.append("CurrentInstanceType: ").append(this.getCurrentInstanceType()).append(",");
        }
        if (this.getFinding() != null) {
            sb.append("Finding: ").append(this.getFinding()).append(",");
        }
        if (this.getUtilizationMetrics() != null) {
            sb.append("UtilizationMetrics: ").append(this.getUtilizationMetrics()).append(",");
        }
        if (this.getLookBackPeriodInDays() != null) {
            sb.append("LookBackPeriodInDays: ").append(this.getLookBackPeriodInDays()).append(",");
        }
        if (this.getRecommendationOptions() != null) {
            sb.append("RecommendationOptions: ").append(this.getRecommendationOptions()).append(",");
        }
        if (this.getRecommendationSources() != null) {
            sb.append("RecommendationSources: ").append(this.getRecommendationSources()).append(",");
        }
        if (this.getLastRefreshTimestamp() != null) {
            sb.append("LastRefreshTimestamp: ").append(this.getLastRefreshTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRecommendation)) {
            return false;
        }
        InstanceRecommendation other = (InstanceRecommendation)obj;
        if (other.getInstanceArn() == null ^ this.getInstanceArn() == null) {
            return false;
        }
        if (other.getInstanceArn() != null && !other.getInstanceArn().equals(this.getInstanceArn())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getInstanceName() == null ^ this.getInstanceName() == null) {
            return false;
        }
        if (other.getInstanceName() != null && !other.getInstanceName().equals(this.getInstanceName())) {
            return false;
        }
        if (other.getCurrentInstanceType() == null ^ this.getCurrentInstanceType() == null) {
            return false;
        }
        if (other.getCurrentInstanceType() != null && !other.getCurrentInstanceType().equals(this.getCurrentInstanceType())) {
            return false;
        }
        if (other.getFinding() == null ^ this.getFinding() == null) {
            return false;
        }
        if (other.getFinding() != null && !other.getFinding().equals(this.getFinding())) {
            return false;
        }
        if (other.getUtilizationMetrics() == null ^ this.getUtilizationMetrics() == null) {
            return false;
        }
        if (other.getUtilizationMetrics() != null && !other.getUtilizationMetrics().equals(this.getUtilizationMetrics())) {
            return false;
        }
        if (other.getLookBackPeriodInDays() == null ^ this.getLookBackPeriodInDays() == null) {
            return false;
        }
        if (other.getLookBackPeriodInDays() != null && !other.getLookBackPeriodInDays().equals(this.getLookBackPeriodInDays())) {
            return false;
        }
        if (other.getRecommendationOptions() == null ^ this.getRecommendationOptions() == null) {
            return false;
        }
        if (other.getRecommendationOptions() != null && !other.getRecommendationOptions().equals(this.getRecommendationOptions())) {
            return false;
        }
        if (other.getRecommendationSources() == null ^ this.getRecommendationSources() == null) {
            return false;
        }
        if (other.getRecommendationSources() != null && !other.getRecommendationSources().equals(this.getRecommendationSources())) {
            return false;
        }
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null) {
            return false;
        }
        return other.getLastRefreshTimestamp() == null || other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceArn() == null ? 0 : this.getInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceName() == null ? 0 : this.getInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentInstanceType() == null ? 0 : this.getCurrentInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getFinding() == null ? 0 : this.getFinding().hashCode());
        hashCode = 31 * hashCode + (this.getUtilizationMetrics() == null ? 0 : this.getUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getLookBackPeriodInDays() == null ? 0 : this.getLookBackPeriodInDays().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationOptions() == null ? 0 : this.getRecommendationOptions().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationSources() == null ? 0 : this.getRecommendationSources().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTimestamp() == null ? 0 : this.getLastRefreshTimestamp().hashCode());
        return hashCode;
    }

    public InstanceRecommendation clone() {
        try {
            return (InstanceRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

