/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.honeycode.model.DataItem;

@SdkInternalApi
public class DataItemMarshaller {
    private static final MarshallingInfo<String> OVERRIDEFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("overrideFormat").build();
    private static final MarshallingInfo<String> RAWVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rawValue").build();
    private static final MarshallingInfo<String> FORMATTEDVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("formattedValue").build();
    private static final DataItemMarshaller instance = new DataItemMarshaller();

    public static DataItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataItem dataItem, ProtocolMarshaller protocolMarshaller) {
        if (dataItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataItem.getOverrideFormat(), OVERRIDEFORMAT_BINDING);
            protocolMarshaller.marshall((Object)dataItem.getRawValue(), RAWVALUE_BINDING);
            protocolMarshaller.marshall((Object)dataItem.getFormattedValue(), FORMATTEDVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

