/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal;

import com.amazonaws.Request;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.services.s3control.S3ControlClientOptions;
import com.amazonaws.util.StringUtils;

@SdkInternalApi
public final class HandlerUtils {
    public static final String X_AMZ_ACCOUNT_ID = "x-amz-account-id";
    public static final String S3_OUTPOSTS = "s3-outposts";

    private HandlerUtils() {
    }

    public static boolean isDualstackEnabled(Request<?> request) {
        return HandlerUtils.isAdvancedConfigFlagTrue(request, S3ControlClientOptions.DUALSTACK_ENABLED);
    }

    public static boolean isFipsEnabledInClientConfig(Request<?> request) {
        return HandlerUtils.isAdvancedConfigFlagTrue(request, S3ControlClientOptions.FIPS_ENABLED);
    }

    public static boolean isAdvancedConfigFlagTrue(Request<?> request, AdvancedConfig.Key<Boolean> key) {
        AdvancedConfig advancedConfig = (AdvancedConfig)request.getHandlerContext(HandlerContextKey.ADVANCED_CONFIG);
        if (advancedConfig == null) {
            return false;
        }
        Boolean flag = (Boolean)advancedConfig.get(key);
        return Boolean.TRUE.equals(flag);
    }

    public static boolean isFipsRegionProvided(String clientRegion, String arnRegion, boolean useArnRegion) {
        if (useArnRegion) {
            return HandlerUtils.isFipsRegion(arnRegion);
        }
        return HandlerUtils.isFipsRegion(clientRegion);
    }

    public static boolean isFipsRegion(String regionName) {
        if (StringUtils.isNullOrEmpty((String)regionName)) {
            return false;
        }
        return regionName.startsWith("fips-") || regionName.endsWith("-fips");
    }
}

