/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.services.s3control.S3ControlResponseMetadata;
import com.amazonaws.services.s3control.model.AccessPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAccessPointsResult
extends AmazonWebServiceResult<S3ControlResponseMetadata>
implements Serializable,
Cloneable {
    private List<AccessPoint> accessPointList;
    private String nextToken;

    public List<AccessPoint> getAccessPointList() {
        return this.accessPointList;
    }

    public void setAccessPointList(Collection<AccessPoint> accessPointList) {
        if (accessPointList == null) {
            this.accessPointList = null;
            return;
        }
        this.accessPointList = new ArrayList<AccessPoint>(accessPointList);
    }

    public ListAccessPointsResult withAccessPointList(AccessPoint ... accessPointList) {
        if (this.accessPointList == null) {
            this.setAccessPointList(new ArrayList<AccessPoint>(accessPointList.length));
        }
        for (AccessPoint ele : accessPointList) {
            this.accessPointList.add(ele);
        }
        return this;
    }

    public ListAccessPointsResult withAccessPointList(Collection<AccessPoint> accessPointList) {
        this.setAccessPointList(accessPointList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAccessPointsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessPointList() != null) {
            sb.append("AccessPointList: ").append(this.getAccessPointList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPointsResult)) {
            return false;
        }
        ListAccessPointsResult other = (ListAccessPointsResult)obj;
        if (other.getAccessPointList() == null ^ this.getAccessPointList() == null) {
            return false;
        }
        if (other.getAccessPointList() != null && !other.getAccessPointList().equals(this.getAccessPointList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessPointList() == null ? 0 : this.getAccessPointList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAccessPointsResult clone() {
        try {
            return (ListAccessPointsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

