/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DescribeJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DescribeJobRequestMarshaller
implements Marshaller<Request<DescribeJobRequest>, DescribeJobRequest> {
    public Request<DescribeJobRequest> marshall(DescribeJobRequest describeJobRequest) {
        if (describeJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeJobRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (describeJobRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)describeJobRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/jobs/{id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "id", describeJobRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

