/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Function;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

public interface WeakMap<K, V> {
    public int size();

    public boolean containsKey(K var1);

    public V get(K var1);

    public void put(K var1, V var2);

    public void putIfAbsent(K var1, V var2);

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public static class MapAdapter<K, V>
    implements WeakMap<K, V> {
        private final Object[] locks = new Object[16];
        private final Map<K, V> map;

        public MapAdapter(Map<K, V> map) {
            this.map = map;
            for (int i = 0; i < this.locks.length; ++i) {
                this.locks[i] = new Object();
            }
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean containsKey(K key) {
            return this.map.containsKey(key);
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        @Override
        public void put(K key, V value) {
            this.map.put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putIfAbsent(K key, V value) {
            if (!this.map.containsKey(key)) {
                Object object = this.locks[key.hashCode() & this.locks.length - 1];
                synchronized (object) {
                    if (!this.map.containsKey(key)) {
                        this.map.put(key, value);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> supplier) {
            V value = this.map.get(key);
            if (null == value) {
                Object object = this.locks[key.hashCode() & this.locks.length - 1];
                synchronized (object) {
                    value = this.map.get(key);
                    if (null == value) {
                        value = supplier.apply(key);
                        this.map.put(key, value);
                    }
                }
            }
            return value;
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static interface Implementation {
        public static final Implementation DEFAULT = new Default();

        public <K, V> WeakMap<K, V> get();

        public static class Default
        implements Implementation {
            private static final Logger log = LoggerFactory.getLogger(Default.class);

            @Override
            public <K, V> WeakMap<K, V> get() {
                log.debug("WeakMap.Supplier not registered. Returning a synchronized WeakHashMap.");
                return new MapAdapter(Collections.synchronizedMap(new WeakHashMap()));
            }
        }
    }

    public static class Provider {
        private static final Logger log = LoggerFactory.getLogger(Provider.class);
        private static final AtomicReference<Implementation> provider = new AtomicReference<Implementation>(Implementation.DEFAULT);

        public static void registerIfAbsent(Implementation provider) {
            if (provider != null && provider != Implementation.DEFAULT && Provider.provider.compareAndSet(Implementation.DEFAULT, provider)) {
                log.debug("Weak map provider set to {}", (Object)provider);
            }
        }

        public static boolean isProviderRegistered() {
            return provider.get() != Implementation.DEFAULT;
        }

        public static <K, V> WeakMap<K, V> newWeakMap() {
            return provider.get().get();
        }
    }
}

