/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExcludeFilter {
    private static final ExcludeType[] SKIP_TYPE_VALUES = ExcludeType.values();
    private static final ClassValue<EnumSet<ExcludeType>> SKIP = new ClassValue<EnumSet<ExcludeType>>(){

        @Override
        protected EnumSet<ExcludeType> computeValue(Class<?> clazz) {
            EnumSet<ExcludeType> skipTypes = EnumSet.noneOf(ExcludeType.class);
            String name = clazz.getName();
            for (ExcludeType type : SKIP_TYPE_VALUES) {
                if (!ExcludeFilter.exclude(type, name)) continue;
                skipTypes.add(type);
            }
            return skipTypes;
        }
    };
    private static final EnumMap<ExcludeType, Set<String>> excludedClassNames = new EnumMap(ExcludeType.class);

    public static boolean exclude(ExcludeType type, Object instance) {
        return SKIP.get(instance.getClass()).contains((Object)type);
    }

    public static boolean exclude(ExcludeType type, String className) {
        return excludedClassNames.get((Object)type).contains(className);
    }

    public static void add(Map<ExcludeType, ? extends Collection<String>> excludeTypes) {
        if (excludeTypes.isEmpty()) {
            return;
        }
        for (Map.Entry<ExcludeType, ? extends Collection<String>> entry : excludeTypes.entrySet()) {
            Set<String> currentExcluded = excludedClassNames.get((Object)entry.getKey());
            currentExcluded.addAll(entry.getValue());
        }
    }

    static {
        for (ExcludeType type : ExcludeType.values()) {
            excludedClassNames.put(type, new HashSet());
        }
    }

    public static enum ExcludeType {
        RUNNABLE,
        CALLABLE,
        FUTURE,
        FORK_JOIN_TASK,
        RUNNABLE_FUTURE,
        EXECUTOR;


        public static ExcludeType fromFieldType(String typeName) {
            switch (typeName) {
                case "java.lang.Runnable": {
                    return RUNNABLE;
                }
                case "java.util.concurrent.Callable": {
                    return CALLABLE;
                }
                case "java.util.concurrent.Future": {
                    return FUTURE;
                }
                case "java.util.concurrent.ForkJoinTask": {
                    return FORK_JOIN_TASK;
                }
                case "java.util.concurrent.RunnableFuture": {
                    return RUNNABLE_FUTURE;
                }
            }
            return null;
        }
    }
}

