/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec;

import com.epages.restdocs.apispec.DescriptorValidator;
import com.epages.restdocs.apispec.HeaderDescriptorWithType;
import com.epages.restdocs.apispec.ParameterDescriptorWithType;
import com.epages.restdocs.apispec.ResourceSnippet;
import com.epages.restdocs.apispec.ResourceSnippetParameters;
import com.epages.restdocs.apispec.Schema;
import com.epages.restdocs.apispec.SecurityRequirements;
import com.epages.restdocs.apispec.SecurityRequirementsHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.Closeable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.snippet.PlaceholderResolverFactory;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolverFactory;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.snippet.StandardWriterResolver;
import org.springframework.restdocs.templates.TemplateFormat;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.util.UriComponents;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u001f !\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\n \u0007*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\n \u0007*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e*\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet;", "Lorg/springframework/restdocs/snippet/Snippet;", "resourceSnippetParameters", "Lcom/epages/restdocs/apispec/ResourceSnippetParameters;", "(Lcom/epages/restdocs/apispec/ResourceSnippetParameters;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "propertyPlaceholderHelper", "Lorg/springframework/util/PropertyPlaceholderHelper;", "createModel", "Lcom/epages/restdocs/apispec/ResourceSnippet$ResourceModel;", "operation", "Lorg/springframework/restdocs/operation/Operation;", "placeholderResolverFactory", "Lorg/springframework/restdocs/snippet/PlaceholderResolverFactory;", "context", "Lorg/springframework/restdocs/RestDocumentationContext;", "document", "", "getContentTypeOrDefault", "", "headers", "Lorg/springframework/http/HttpHeaders;", "getUriComponents", "Lorg/springframework/web/util/UriComponents;", "getUriPath", "withExample", "Lcom/epages/restdocs/apispec/HeaderDescriptorWithType;", "withExampleValues", "", "JsonTemplateFormat", "MissingUrlTemplateException", "RequestModel", "ResourceModel", "ResponseModel", "restdocs-api-spec"})
public final class ResourceSnippet
implements Snippet {
    private final ObjectMapper objectMapper;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper;
    private final ResourceSnippetParameters resourceSnippetParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void document(@NotNull Operation operation) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Object v = operation.getAttributes().get(RestDocumentationContext.class.getName());
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.springframework.restdocs.RestDocumentationContext");
        }
        RestDocumentationContext context = (RestDocumentationContext)v;
        DescriptorValidator.INSTANCE.validatePresentParameters(this.resourceSnippetParameters, operation);
        RestDocumentationContextPlaceholderResolverFactory placeholderResolverFactory = new RestDocumentationContextPlaceholderResolverFactory();
        ResourceModel model = this.createModel(operation, (PlaceholderResolverFactory)placeholderResolverFactory, context);
        Closeable closeable = new StandardWriterResolver((PlaceholderResolverFactory)placeholderResolverFactory, Charsets.UTF_8.name(), (TemplateFormat)JsonTemplateFormat.INSTANCE).resolve(operation.getName(), "resource", context);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Writer it = (Writer)closeable;
            boolean bl2 = false;
            Writer writer = it.append(this.objectMapper.writeValueAsString((Object)model));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final ResourceModel createModel(Operation operation, PlaceholderResolverFactory placeholderResolverFactory, RestDocumentationContext context) {
        String string;
        List list;
        String string2;
        String string3;
        List list2;
        ParameterDescriptorWithType it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Object $this$filter$iv;
        String string4;
        String string5;
        Set set;
        String operationId = this.propertyPlaceholderHelper.replacePlaceholders(operation.getName(), placeholderResolverFactory.create(context));
        OperationRequest operationRequest = operation.getRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)operationRequest, (String)"operation.request");
        String string6 = operationRequest.getContentAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"operation.request.contentAsString");
        CharSequence charSequence = string6;
        boolean bl = false;
        boolean hasRequestBody = charSequence.length() > 0;
        OperationResponse operationResponse = operation.getResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)operationResponse, (String)"operation.response");
        String string7 = operationResponse.getContentAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"operation.response.contentAsString");
        CharSequence charSequence2 = string7;
        boolean bl2 = false;
        boolean hasResponseBody = charSequence2.length() > 0;
        SecurityRequirements securityRequirements = new SecurityRequirementsHandler().extractSecurityRequirements(operation);
        if (this.resourceSnippetParameters.getTags().isEmpty()) {
            UriComponents uriComponents = this.getUriComponents(operation);
            Intrinsics.checkExpressionValueIsNotNull((Object)uriComponents, (String)"getUriComponents(operation)");
            List list3 = uriComponents.getPathSegments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"getUriComponents(operation).pathSegments");
            set = Optional.ofNullable(CollectionsKt.firstOrNull((List)list3)).map(createModel.tags.1.INSTANCE).orElse(SetsKt.emptySet());
        } else {
            set = this.resourceSnippetParameters.getTags();
        }
        Set tags2 = set;
        String string8 = operationId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"operationId");
        String string9 = this.resourceSnippetParameters.getSummary();
        if (string9 == null) {
            string9 = this.resourceSnippetParameters.getDescription();
        }
        if ((string5 = this.resourceSnippetParameters.getDescription()) == null) {
            string5 = this.resourceSnippetParameters.getSummary();
        }
        boolean bl3 = this.resourceSnippetParameters.getPrivateResource();
        boolean bl4 = this.resourceSnippetParameters.getDeprecated();
        Set set2 = tags2;
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"tags");
        String string10 = this.getUriPath(operation);
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"getUriPath(operation)");
        OperationRequest operationRequest2 = operation.getRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)operationRequest2, (String)"operation.request");
        String string11 = operationRequest2.getMethod().name();
        if (hasRequestBody) {
            OperationRequest operationRequest3 = operation.getRequest();
            Intrinsics.checkExpressionValueIsNotNull((Object)operationRequest3, (String)"operation.request");
            HttpHeaders httpHeaders = operationRequest3.getHeaders();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHeaders, (String)"operation.request.headers");
            string4 = this.getContentTypeOrDefault(httpHeaders);
        } else {
            string4 = null;
        }
        List<HeaderDescriptorWithType> list4 = this.resourceSnippetParameters.getRequestHeaders();
        OperationRequest operationRequest4 = operation.getRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)operationRequest4, (String)"operation.request");
        HttpHeaders httpHeaders = operationRequest4.getHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpHeaders, (String)"operation.request.headers");
        Object object = this.resourceSnippetParameters.getPathParameters();
        List<HeaderDescriptorWithType> list5 = this.withExampleValues(list4, httpHeaders);
        String string12 = string4;
        String string13 = string11;
        String string14 = string10;
        Set set3 = set2;
        boolean bl5 = bl4;
        boolean bl6 = bl3;
        String string15 = string5;
        String string16 = string9;
        String string17 = string8;
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ParameterDescriptorWithType)((Object)element$iv$iv);
            boolean bl7 = false;
            if (!(!it.isIgnored())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object3 = (List)destination$iv$iv;
        $this$filter$iv = this.resourceSnippetParameters.getRequestParameters();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ParameterDescriptorWithType)((Object)element$iv$iv);
            boolean bl8 = false;
            if (!(!it.isIgnored())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list6 = (List)destination$iv$iv;
        String string18 = string17;
        String string19 = string16;
        String string20 = string15;
        boolean bl9 = bl6;
        boolean bl10 = bl5;
        Set set4 = set3;
        String string21 = string14;
        String string22 = string13;
        String string23 = string12;
        List<HeaderDescriptorWithType> list7 = list5;
        List list8 = object3;
        List list9 = list6;
        Schema schema = this.resourceSnippetParameters.getRequestSchema();
        if (hasRequestBody) {
            $this$filter$iv = this.resourceSnippetParameters.getRequestFields();
            Schema schema2 = schema;
            list6 = list9;
            object3 = list8;
            list5 = list7;
            string12 = string23;
            string13 = string22;
            string14 = string21;
            set3 = set4;
            bl5 = bl10;
            bl6 = bl9;
            string15 = string20;
            string16 = string19;
            string17 = string18;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (FieldDescriptor)element$iv$iv;
                boolean bl11 = false;
                if (!(!it.isIgnored())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list10 = (List)destination$iv$iv;
            string18 = string17;
            string19 = string16;
            string20 = string15;
            bl9 = bl6;
            bl10 = bl5;
            set4 = set3;
            string21 = string14;
            string22 = string13;
            string23 = string12;
            list7 = list5;
            list8 = object3;
            list9 = list6;
            schema = schema2;
            list2 = list10;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        if (hasRequestBody) {
            OperationRequest operationRequest5 = operation.getRequest();
            Intrinsics.checkExpressionValueIsNotNull((Object)operationRequest5, (String)"operation.request");
            string3 = operationRequest5.getContentAsString();
        } else {
            string3 = null;
        }
        $this$filter$iv = securityRequirements;
        String $i$f$filter2 = string3;
        $this$filterTo$iv$iv = list2;
        destination$iv$iv = schema;
        List $i$f$filterTo2 = list9;
        iterator = list8;
        element$iv$iv = list7;
        Object object4 = $this$filter$iv;
        String string24 = $i$f$filter2;
        Iterable iterable = $this$filterTo$iv$iv;
        List list11 = $i$f$filterTo2;
        Iterator iterator2 = iterator;
        Object object5 = element$iv$iv;
        Object object6 = destination$iv$iv;
        String string25 = string23;
        String string26 = string22;
        String string27 = string21;
        RequestModel requestModel = new RequestModel(string27, string26, string25, (Schema)object6, (List<HeaderDescriptorWithType>)object5, (List<ParameterDescriptorWithType>)((Object)iterator2), list11, (List<? extends FieldDescriptor>)iterable, string24, (SecurityRequirements)object4);
        OperationResponse operationResponse2 = operation.getResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)operationResponse2, (String)"operation.response");
        int n = operationResponse2.getStatus().value();
        if (hasResponseBody) {
            OperationResponse operationResponse3 = operation.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)operationResponse3, (String)"operation.response");
            HttpHeaders httpHeaders2 = operationResponse3.getHeaders();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHeaders2, (String)"operation.response.headers");
            string2 = this.getContentTypeOrDefault(httpHeaders2);
        } else {
            string2 = null;
        }
        List<HeaderDescriptorWithType> list12 = this.resourceSnippetParameters.getResponseHeaders();
        OperationResponse operationResponse4 = operation.getResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)operationResponse4, (String)"operation.response");
        HttpHeaders httpHeaders3 = operationResponse4.getHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpHeaders3, (String)"operation.response.headers");
        List<HeaderDescriptorWithType> list13 = this.withExampleValues(list12, httpHeaders3);
        Object object7 = this.resourceSnippetParameters.getResponseSchema();
        if (hasResponseBody) {
            $this$filter$iv = this.resourceSnippetParameters.getResponseFields();
            object3 = object7;
            list5 = list13;
            string12 = string2;
            int n2 = n;
            RequestModel requestModel2 = requestModel;
            set3 = set4;
            bl5 = bl10;
            bl6 = bl9;
            string15 = string20;
            string16 = string19;
            string17 = string18;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (FieldDescriptor)element$iv$iv;
                boolean bl12 = false;
                if (!(!it.isIgnored())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list6 = (List)destination$iv$iv;
            string18 = string17;
            string19 = string16;
            string20 = string15;
            bl9 = bl6;
            bl10 = bl5;
            set4 = set3;
            requestModel = requestModel2;
            n = n2;
            string2 = string12;
            list13 = list5;
            object7 = object3;
            list = list6;
        } else {
            list = CollectionsKt.emptyList();
        }
        if (hasResponseBody) {
            OperationResponse operationResponse5 = operation.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)operationResponse5, (String)"operation.response");
            string = operationResponse5.getContentAsString();
        } else {
            string = null;
        }
        object = string;
        Object object8 = list;
        object2 = object7;
        List<HeaderDescriptorWithType> list14 = list13;
        Iterable iterable2 = object;
        List list15 = object8;
        List<HeaderDescriptorWithType> list16 = list14;
        Schema schema3 = object2;
        String string28 = string2;
        int n3 = n;
        object = new ResponseModel(n3, string28, schema3, list16, list15, (String)((Object)iterable2));
        object8 = requestModel;
        Object object9 = object2 = set4;
        Object object10 = object;
        Object object11 = object8;
        boolean bl13 = bl10;
        boolean bl14 = bl9;
        String string29 = string20;
        String string30 = string19;
        String string31 = string18;
        return new ResourceModel(string31, string30, string29, bl14, bl13, (RequestModel)object11, (ResponseModel)object10, (Set<String>)object9);
    }

    /*
     * WARNING - void declaration
     */
    private final List<HeaderDescriptorWithType> withExampleValues(@NotNull List<HeaderDescriptorWithType> $this$withExampleValues, HttpHeaders headers) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$withExampleValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HeaderDescriptorWithType headerDescriptorWithType = (HeaderDescriptorWithType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HeaderDescriptorWithType headerDescriptorWithType2 = this.withExample((HeaderDescriptorWithType)it, headers);
            collection.add(headerDescriptorWithType2);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return $this$withExampleValues;
    }

    private final HeaderDescriptorWithType withExample(@NotNull HeaderDescriptorWithType $this$withExample, HttpHeaders headers) {
        block0: {
            String string = headers.getFirst($this$withExample.getName());
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            $this$withExample.setExample(it);
        }
        return $this$withExample;
    }

    private final UriComponents getUriComponents(Operation operation) {
        Object v = operation.getAttributes().get("org.springframework.restdocs.urlTemplate");
        if (!(v instanceof String)) {
            v = null;
        }
        return (UriComponents)Optional.ofNullable((String)v).map(getUriComponents.1.INSTANCE).orElseThrow(getUriComponents.2.INSTANCE);
    }

    private final String getUriPath(Operation operation) {
        UriComponents uriComponents = this.getUriComponents(operation);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriComponents, (String)"getUriComponents(operation)");
        return uriComponents.getPath();
    }

    private final String getContentTypeOrDefault(HttpHeaders headers) {
        String string = Optional.ofNullable(headers.getContentType()).map(getContentTypeOrDefault.1.INSTANCE).orElse(MediaType.APPLICATION_JSON).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Optional.ofNullable(head\u2026)\n            .toString()");
        return string;
    }

    public ResourceSnippet(@NotNull ResourceSnippetParameters resourceSnippetParameters) {
        Intrinsics.checkParameterIsNotNull((Object)resourceSnippetParameters, (String)"resourceSnippetParameters");
        this.resourceSnippetParameters = resourceSnippetParameters;
        this.objectMapper = ExtensionsKt.jacksonObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        this.propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$JsonTemplateFormat;", "Lorg/springframework/restdocs/templates/TemplateFormat;", "()V", "getFileExtension", "", "getId", "restdocs-api-spec"})
    public static final class JsonTemplateFormat
    implements TemplateFormat {
        public static final JsonTemplateFormat INSTANCE;

        @NotNull
        public String getId() {
            return "json";
        }

        @NotNull
        public String getFileExtension() {
            return "json";
        }

        private JsonTemplateFormat() {
        }

        static {
            JsonTemplateFormat jsonTemplateFormat;
            INSTANCE = jsonTemplateFormat = new JsonTemplateFormat();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0003Jc\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$ResourceModel;", "", "operationId", "", "summary", "description", "privateResource", "", "deprecated", "request", "Lcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;", "response", "Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;", "tags", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;Ljava/util/Set;)V", "getDeprecated", "()Z", "getDescription", "()Ljava/lang/String;", "getOperationId", "getPrivateResource", "getRequest", "()Lcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;", "getResponse", "()Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;", "getSummary", "getTags", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "restdocs-api-spec"})
    private static final class ResourceModel {
        @NotNull
        private final String operationId;
        @Nullable
        private final String summary;
        @Nullable
        private final String description;
        private final boolean privateResource;
        private final boolean deprecated;
        @NotNull
        private final RequestModel request;
        @NotNull
        private final ResponseModel response;
        @NotNull
        private final Set<String> tags;

        @NotNull
        public final String getOperationId() {
            return this.operationId;
        }

        @Nullable
        public final String getSummary() {
            return this.summary;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final boolean getPrivateResource() {
            return this.privateResource;
        }

        public final boolean getDeprecated() {
            return this.deprecated;
        }

        @NotNull
        public final RequestModel getRequest() {
            return this.request;
        }

        @NotNull
        public final ResponseModel getResponse() {
            return this.response;
        }

        @NotNull
        public final Set<String> getTags() {
            return this.tags;
        }

        public ResourceModel(@NotNull String operationId, @Nullable String summary, @Nullable String description, boolean privateResource, boolean deprecated, @NotNull RequestModel request, @NotNull ResponseModel response, @NotNull Set<String> tags2) {
            Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            Intrinsics.checkParameterIsNotNull(tags2, (String)"tags");
            this.operationId = operationId;
            this.summary = summary;
            this.description = description;
            this.privateResource = privateResource;
            this.deprecated = deprecated;
            this.request = request;
            this.response = response;
            this.tags = tags2;
        }

        @NotNull
        public final String component1() {
            return this.operationId;
        }

        @Nullable
        public final String component2() {
            return this.summary;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        public final boolean component4() {
            return this.privateResource;
        }

        public final boolean component5() {
            return this.deprecated;
        }

        @NotNull
        public final RequestModel component6() {
            return this.request;
        }

        @NotNull
        public final ResponseModel component7() {
            return this.response;
        }

        @NotNull
        public final Set<String> component8() {
            return this.tags;
        }

        @NotNull
        public final ResourceModel copy(@NotNull String operationId, @Nullable String summary, @Nullable String description, boolean privateResource, boolean deprecated, @NotNull RequestModel request, @NotNull ResponseModel response, @NotNull Set<String> tags2) {
            Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            Intrinsics.checkParameterIsNotNull(tags2, (String)"tags");
            return new ResourceModel(operationId, summary, description, privateResource, deprecated, request, response, tags2);
        }

        public static /* synthetic */ ResourceModel copy$default(ResourceModel resourceModel, String string, String string2, String string3, boolean bl, boolean bl2, RequestModel requestModel, ResponseModel responseModel, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = resourceModel.operationId;
            }
            if ((n & 2) != 0) {
                string2 = resourceModel.summary;
            }
            if ((n & 4) != 0) {
                string3 = resourceModel.description;
            }
            if ((n & 8) != 0) {
                bl = resourceModel.privateResource;
            }
            if ((n & 0x10) != 0) {
                bl2 = resourceModel.deprecated;
            }
            if ((n & 0x20) != 0) {
                requestModel = resourceModel.request;
            }
            if ((n & 0x40) != 0) {
                responseModel = resourceModel.response;
            }
            if ((n & 0x80) != 0) {
                set = resourceModel.tags;
            }
            return resourceModel.copy(string, string2, string3, bl, bl2, requestModel, responseModel, set);
        }

        @NotNull
        public String toString() {
            return "ResourceModel(operationId=" + this.operationId + ", summary=" + this.summary + ", description=" + this.description + ", privateResource=" + this.privateResource + ", deprecated=" + this.deprecated + ", request=" + this.request + ", response=" + this.response + ", tags=" + this.tags + ")";
        }

        public int hashCode() {
            String string = this.operationId;
            String string2 = this.summary;
            String string3 = this.description;
            int n = (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31;
            int n2 = this.privateResource ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.deprecated ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            RequestModel requestModel = this.request;
            ResponseModel responseModel = this.response;
            Set<String> set = this.tags;
            return (((n3 + n4) * 31 + (requestModel != null ? ((Object)requestModel).hashCode() : 0)) * 31 + (responseModel != null ? ((Object)responseModel).hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ResourceModel)) break block3;
                    ResourceModel resourceModel = (ResourceModel)object;
                    if (!Intrinsics.areEqual((Object)this.operationId, (Object)resourceModel.operationId) || !Intrinsics.areEqual((Object)this.summary, (Object)resourceModel.summary) || !Intrinsics.areEqual((Object)this.description, (Object)resourceModel.description) || !(this.privateResource == resourceModel.privateResource) || !(this.deprecated == resourceModel.deprecated) || !Intrinsics.areEqual((Object)this.request, (Object)resourceModel.request) || !Intrinsics.areEqual((Object)this.response, (Object)resourceModel.response) || !Intrinsics.areEqual(this.tags, resourceModel.tags)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u008d\u0001\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00063"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$RequestModel;", "", "path", "", "method", "contentType", "schema", "Lcom/epages/restdocs/apispec/Schema;", "headers", "", "Lcom/epages/restdocs/apispec/HeaderDescriptorWithType;", "pathParameters", "Lcom/epages/restdocs/apispec/ParameterDescriptorWithType;", "requestParameters", "requestFields", "Lorg/springframework/restdocs/payload/FieldDescriptor;", "example", "securityRequirements", "Lcom/epages/restdocs/apispec/SecurityRequirements;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/epages/restdocs/apispec/Schema;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Lcom/epages/restdocs/apispec/SecurityRequirements;)V", "getContentType", "()Ljava/lang/String;", "getExample", "getHeaders", "()Ljava/util/List;", "getMethod", "getPath", "getPathParameters", "getRequestFields", "getRequestParameters", "getSchema", "()Lcom/epages/restdocs/apispec/Schema;", "getSecurityRequirements", "()Lcom/epages/restdocs/apispec/SecurityRequirements;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "restdocs-api-spec"})
    private static final class RequestModel {
        @NotNull
        private final String path;
        @NotNull
        private final String method;
        @Nullable
        private final String contentType;
        @Nullable
        private final Schema schema;
        @NotNull
        private final List<HeaderDescriptorWithType> headers;
        @NotNull
        private final List<ParameterDescriptorWithType> pathParameters;
        @NotNull
        private final List<ParameterDescriptorWithType> requestParameters;
        @NotNull
        private final List<FieldDescriptor> requestFields;
        @Nullable
        private final String example;
        @Nullable
        private final SecurityRequirements securityRequirements;

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @Nullable
        public final String getContentType() {
            return this.contentType;
        }

        @Nullable
        public final Schema getSchema() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> getPathParameters() {
            return this.pathParameters;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> getRequestParameters() {
            return this.requestParameters;
        }

        @NotNull
        public final List<FieldDescriptor> getRequestFields() {
            return this.requestFields;
        }

        @Nullable
        public final String getExample() {
            return this.example;
        }

        @Nullable
        public final SecurityRequirements getSecurityRequirements() {
            return this.securityRequirements;
        }

        public RequestModel(@NotNull String path, @NotNull String method, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<ParameterDescriptorWithType> pathParameters, @NotNull List<ParameterDescriptorWithType> requestParameters, @NotNull List<? extends FieldDescriptor> requestFields, @Nullable String example, @Nullable SecurityRequirements securityRequirements) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
            Intrinsics.checkParameterIsNotNull(pathParameters, (String)"pathParameters");
            Intrinsics.checkParameterIsNotNull(requestParameters, (String)"requestParameters");
            Intrinsics.checkParameterIsNotNull(requestFields, (String)"requestFields");
            this.path = path;
            this.method = method;
            this.contentType = contentType;
            this.schema = schema;
            this.headers = headers;
            this.pathParameters = pathParameters;
            this.requestParameters = requestParameters;
            this.requestFields = requestFields;
            this.example = example;
            this.securityRequirements = securityRequirements;
        }

        public /* synthetic */ RequestModel(String string, String string2, String string3, Schema schema, List list, List list2, List list3, List list4, String string4, SecurityRequirements securityRequirements, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                schema = null;
            }
            this(string, string2, string3, schema, list, list2, list3, list4, string4, securityRequirements);
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.method;
        }

        @Nullable
        public final String component3() {
            return this.contentType;
        }

        @Nullable
        public final Schema component4() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> component5() {
            return this.headers;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> component6() {
            return this.pathParameters;
        }

        @NotNull
        public final List<ParameterDescriptorWithType> component7() {
            return this.requestParameters;
        }

        @NotNull
        public final List<FieldDescriptor> component8() {
            return this.requestFields;
        }

        @Nullable
        public final String component9() {
            return this.example;
        }

        @Nullable
        public final SecurityRequirements component10() {
            return this.securityRequirements;
        }

        @NotNull
        public final RequestModel copy(@NotNull String path, @NotNull String method, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<ParameterDescriptorWithType> pathParameters, @NotNull List<ParameterDescriptorWithType> requestParameters, @NotNull List<? extends FieldDescriptor> requestFields, @Nullable String example, @Nullable SecurityRequirements securityRequirements) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
            Intrinsics.checkParameterIsNotNull(pathParameters, (String)"pathParameters");
            Intrinsics.checkParameterIsNotNull(requestParameters, (String)"requestParameters");
            Intrinsics.checkParameterIsNotNull(requestFields, (String)"requestFields");
            return new RequestModel(path, method, contentType, schema, headers, pathParameters, requestParameters, requestFields, example, securityRequirements);
        }

        public static /* synthetic */ RequestModel copy$default(RequestModel requestModel, String string, String string2, String string3, Schema schema, List list, List list2, List list3, List list4, String string4, SecurityRequirements securityRequirements, int n, Object object) {
            if ((n & 1) != 0) {
                string = requestModel.path;
            }
            if ((n & 2) != 0) {
                string2 = requestModel.method;
            }
            if ((n & 4) != 0) {
                string3 = requestModel.contentType;
            }
            if ((n & 8) != 0) {
                schema = requestModel.schema;
            }
            if ((n & 0x10) != 0) {
                list = requestModel.headers;
            }
            if ((n & 0x20) != 0) {
                list2 = requestModel.pathParameters;
            }
            if ((n & 0x40) != 0) {
                list3 = requestModel.requestParameters;
            }
            if ((n & 0x80) != 0) {
                list4 = requestModel.requestFields;
            }
            if ((n & 0x100) != 0) {
                string4 = requestModel.example;
            }
            if ((n & 0x200) != 0) {
                securityRequirements = requestModel.securityRequirements;
            }
            return requestModel.copy(string, string2, string3, schema, list, list2, list3, list4, string4, securityRequirements);
        }

        @NotNull
        public String toString() {
            return "RequestModel(path=" + this.path + ", method=" + this.method + ", contentType=" + this.contentType + ", schema=" + this.schema + ", headers=" + this.headers + ", pathParameters=" + this.pathParameters + ", requestParameters=" + this.requestParameters + ", requestFields=" + this.requestFields + ", example=" + this.example + ", securityRequirements=" + this.securityRequirements + ")";
        }

        public int hashCode() {
            String string = this.path;
            String string2 = this.method;
            String string3 = this.contentType;
            Schema schema = this.schema;
            List<HeaderDescriptorWithType> list = this.headers;
            List<ParameterDescriptorWithType> list2 = this.pathParameters;
            List<ParameterDescriptorWithType> list3 = this.requestParameters;
            List<FieldDescriptor> list4 = this.requestFields;
            String string4 = this.example;
            SecurityRequirements securityRequirements = this.securityRequirements;
            return (((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (schema != null ? ((Object)schema).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (list4 != null ? ((Object)list4).hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (securityRequirements != null ? securityRequirements.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RequestModel)) break block3;
                    RequestModel requestModel = (RequestModel)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)requestModel.path) || !Intrinsics.areEqual((Object)this.method, (Object)requestModel.method) || !Intrinsics.areEqual((Object)this.contentType, (Object)requestModel.contentType) || !Intrinsics.areEqual((Object)this.schema, (Object)requestModel.schema) || !Intrinsics.areEqual(this.headers, requestModel.headers) || !Intrinsics.areEqual(this.pathParameters, requestModel.pathParameters) || !Intrinsics.areEqual(this.requestParameters, requestModel.requestParameters) || !Intrinsics.areEqual(this.requestFields, requestModel.requestFields) || !Intrinsics.areEqual((Object)this.example, (Object)requestModel.example) || !Intrinsics.areEqual((Object)this.securityRequirements, (Object)requestModel.securityRequirements)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JW\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$ResponseModel;", "", "status", "", "contentType", "", "schema", "Lcom/epages/restdocs/apispec/Schema;", "headers", "", "Lcom/epages/restdocs/apispec/HeaderDescriptorWithType;", "responseFields", "Lorg/springframework/restdocs/payload/FieldDescriptor;", "example", "(ILjava/lang/String;Lcom/epages/restdocs/apispec/Schema;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getContentType", "()Ljava/lang/String;", "getExample", "getHeaders", "()Ljava/util/List;", "getResponseFields", "getSchema", "()Lcom/epages/restdocs/apispec/Schema;", "getStatus", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "restdocs-api-spec"})
    private static final class ResponseModel {
        private final int status;
        @Nullable
        private final String contentType;
        @Nullable
        private final Schema schema;
        @NotNull
        private final List<HeaderDescriptorWithType> headers;
        @NotNull
        private final List<FieldDescriptor> responseFields;
        @Nullable
        private final String example;

        public final int getStatus() {
            return this.status;
        }

        @Nullable
        public final String getContentType() {
            return this.contentType;
        }

        @Nullable
        public final Schema getSchema() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final List<FieldDescriptor> getResponseFields() {
            return this.responseFields;
        }

        @Nullable
        public final String getExample() {
            return this.example;
        }

        public ResponseModel(int status, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<? extends FieldDescriptor> responseFields, @Nullable String example) {
            Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
            Intrinsics.checkParameterIsNotNull(responseFields, (String)"responseFields");
            this.status = status;
            this.contentType = contentType;
            this.schema = schema;
            this.headers = headers;
            this.responseFields = responseFields;
            this.example = example;
        }

        public /* synthetic */ ResponseModel(int n, String string, Schema schema, List list, List list2, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                schema = null;
            }
            this(n, string, schema, list, list2, string2);
        }

        public final int component1() {
            return this.status;
        }

        @Nullable
        public final String component2() {
            return this.contentType;
        }

        @Nullable
        public final Schema component3() {
            return this.schema;
        }

        @NotNull
        public final List<HeaderDescriptorWithType> component4() {
            return this.headers;
        }

        @NotNull
        public final List<FieldDescriptor> component5() {
            return this.responseFields;
        }

        @Nullable
        public final String component6() {
            return this.example;
        }

        @NotNull
        public final ResponseModel copy(int status, @Nullable String contentType, @Nullable Schema schema, @NotNull List<HeaderDescriptorWithType> headers, @NotNull List<? extends FieldDescriptor> responseFields, @Nullable String example) {
            Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
            Intrinsics.checkParameterIsNotNull(responseFields, (String)"responseFields");
            return new ResponseModel(status, contentType, schema, headers, responseFields, example);
        }

        public static /* synthetic */ ResponseModel copy$default(ResponseModel responseModel, int n, String string, Schema schema, List list, List list2, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = responseModel.status;
            }
            if ((n2 & 2) != 0) {
                string = responseModel.contentType;
            }
            if ((n2 & 4) != 0) {
                schema = responseModel.schema;
            }
            if ((n2 & 8) != 0) {
                list = responseModel.headers;
            }
            if ((n2 & 0x10) != 0) {
                list2 = responseModel.responseFields;
            }
            if ((n2 & 0x20) != 0) {
                string2 = responseModel.example;
            }
            return responseModel.copy(n, string, schema, list, list2, string2);
        }

        @NotNull
        public String toString() {
            return "ResponseModel(status=" + this.status + ", contentType=" + this.contentType + ", schema=" + this.schema + ", headers=" + this.headers + ", responseFields=" + this.responseFields + ", example=" + this.example + ")";
        }

        public int hashCode() {
            String string = this.contentType;
            Schema schema = this.schema;
            List<HeaderDescriptorWithType> list = this.headers;
            List<FieldDescriptor> list2 = this.responseFields;
            String string2 = this.example;
            return ((((Integer.hashCode(this.status) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (schema != null ? ((Object)schema).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ResponseModel)) break block3;
                    ResponseModel responseModel = (ResponseModel)object;
                    if (!(this.status == responseModel.status) || !Intrinsics.areEqual((Object)this.contentType, (Object)responseModel.contentType) || !Intrinsics.areEqual((Object)this.schema, (Object)responseModel.schema) || !Intrinsics.areEqual(this.headers, responseModel.headers) || !Intrinsics.areEqual(this.responseFields, responseModel.responseFields) || !Intrinsics.areEqual((Object)this.example, (Object)responseModel.example)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/epages/restdocs/apispec/ResourceSnippet$MissingUrlTemplateException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "restdocs-api-spec"})
    public static final class MissingUrlTemplateException
    extends RuntimeException {
        public MissingUrlTemplateException() {
            super("Missing URL template - please use RestDocumentationRequestBuilders with urlTemplate to construct the request");
        }
    }
}

