/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.instantdb;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.enhydra.instantdb.jdbc.ConnectionExtensions;
import org.enhydra.jdbc.instantdb.IdbXADataSource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.enhydra.jdbc.standard.StandardXAStatefulConnection;

public final class IdbXAConnection
extends StandardXAConnection {
    public IdbXAConnection(StandardXADataSource dataSource, String user, String password) throws SQLException {
        super(dataSource, user, password);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.doStart(xid, flags);
        this.curCon.commitOnPrepare = false;
        ConnectionExtensions conExt = (ConnectionExtensions)this.curCon.con;
        conExt.startGlobalTransaction(xid);
        this.curCon = null;
        this.con = null;
    }

    public int prepare(Xid xid) throws XAException {
        StandardXAStatefulConnection stateCon = this.checkPreparedState(xid);
        ConnectionExtensions con = (ConnectionExtensions)stateCon.con;
        int status = con.prepare();
        if (status == 3) {
            this.xaDataSource.freeConnection(xid, false);
        }
        return status;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (super.isSameRM(xares)) {
            return true;
        }
        if (xares instanceof IdbXAConnection) {
            IdbXAConnection xac = (IdbXAConnection)xares;
            IdbXADataSource cmpds = (IdbXADataSource)xac.dataSource;
            IdbXADataSource ds = (IdbXADataSource)this.dataSource;
            if (ds.databaseId.equals(cmpds.databaseId)) {
                return true;
            }
        }
        return false;
    }
}

