/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="bower", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class BowerMojo
extends AbstractFrontendMojo {
    @Parameter(defaultValue="install", property="frontend.bower.arguments", required=false)
    private String arguments;
    @Parameter(property="skip.bower", defaultValue="${skip.bower}")
    private boolean skip;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="frontend.bower.bowerInheritsProxyConfigFromMaven", required=false, defaultValue="true")
    private boolean bowerInheritsProxyConfigFromMaven;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    protected synchronized void execute(FrontendPluginFactory factory) throws Exception {
        ProxyConfig proxyConfig = this.getProxyConfig();
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.arguments, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.BOWER, (String)this.getFrontendMavenPluginVersion(), (boolean)false, (boolean)false, () -> factory.getBowerRunner(proxyConfig).execute(this.arguments, this.environmentVariables));
    }

    private ProxyConfig getProxyConfig() {
        if (this.bowerInheritsProxyConfigFromMaven) {
            return MojoUtils.getProxyConfig(this.session, this.decrypter);
        }
        this.getLog().info((CharSequence)"bower not inheriting proxy config from Maven");
        return new ProxyConfig(Collections.emptyList());
    }
}

