/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetric;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricOperatingSystem;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricType;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsIncremental;
import com.github.eirslett.maven.plugins.frontend.lib.ThrowingConsumer;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianDevMetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(AtlassianDevMetricsReporter.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("dev-metrics-reporter-frontend-maven-plugin");
        return thread;
    });
    private static final HttpClient HTTP_CLIENT = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((int)TimeUnit.SECONDS.toMillis(10L)).setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L)).setSocketTimeout((int)TimeUnit.SECONDS.toMillis(5L)).build()).setMaxConnPerRoute(10).build();
    private static final String METRIC_NAME_PREFIX = "frontend.maven.plugin.fork.";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String METRICS_ENDPOINT = "https://devmetrics-publisher.prod.atl-paas.net/1/metrics";
    private static final Pattern BUN_VERSION_PATTERN = Pattern.compile("v?(\\d+\\.\\d+).*");
    public static final String RUNTIME_VERSION_TAG_NAME = "runtime-version";
    public static final String METRIC_BY_ARTIFACT_SUFFIX = ".by.artifact";
    private static volatile boolean isOffline = false;

    private AtlassianDevMetricsReporter() {
        throw new UnsupportedOperationException("util class");
    }

    private static void sendMetricOverHttp(Object toSendAsJson) {
        try {
            HttpPost httpPost = new HttpPost(METRICS_ENDPOINT);
            String jsonString = OBJECT_MAPPER.writeValueAsString(toSendAsJson);
            StringEntity body = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)body);
            HttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new RuntimeException("Status not OK, was " + response.getStatusLine());
            }
            response.getEntity();
        }
        catch (Exception e) {
            isOffline = true;
            log.warn("Could not send frontend-maven-plugin dev metric, see debug logs for why");
            log.debug("Failed to send dev metric because:", (Throwable)e);
        }
    }

    private static Map<String, String> getDefaultTags(final String artifactId, final String forkVersion) {
        final boolean isCi = "true".equalsIgnoreCase(System.getenv("CI")) || "1".equals(System.getenv("CI")) || System.getenv().containsKey("bamboo_planKey");
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("dm_environment", isCi ? "ci" : "local_dev");
                this.put("dm_devmode", Boolean.toString(Boolean.getBoolean("atlassian.dev.mode") || Boolean.getBoolean("jira.dev.mode") || Boolean.getBoolean("confluence.devmode")));
                this.put("dm_java_version", System.getProperty("java.specification.version"));
                this.put("dm_profiler-os", AtlassianDevMetricOperatingSystem.getOs());
                this.put("fork-version", forkVersion);
                this.put("profiler-artifact-id", artifactId);
            }
        };
        return tags;
    }

    public static void incrementExecutionCount(String artifactId, String arguments, Goal goal, String forkVersion, boolean incrementalEnabled, boolean wasIncremental, ThrowingConsumer task) throws Exception {
        AtlassianDevMetricsIncremental atlassianDevMetricsIncremental;
        boolean failed;
        block5: {
            failed = false;
            try {
                task.invoke();
                if (incrementalEnabled) {
                    atlassianDevMetricsIncremental = wasIncremental ? AtlassianDevMetricsIncremental.REBUILDING_SKIPPED : AtlassianDevMetricsIncremental.BUILT;
                    break block5;
                }
                atlassianDevMetricsIncremental = AtlassianDevMetricsIncremental.NOT_ENABLED;
            }
            catch (Exception exception) {
                try {
                    failed = true;
                    throw exception;
                }
                catch (Throwable throwable) {
                    AtlassianDevMetricsIncremental incremental = incrementalEnabled ? (wasIncremental ? AtlassianDevMetricsIncremental.REBUILDING_SKIPPED : AtlassianDevMetricsIncremental.BUILT) : AtlassianDevMetricsIncremental.NOT_ENABLED;
                    boolean finalFailed = failed;
                    AtlassianDevMetricsReporter.incrementCount("execute", artifactId, forkVersion, (Map<String, String>)new HashMap<String, String>(goal, finalFailed, arguments, incremental){
                        final /* synthetic */ Goal val$goal;
                        final /* synthetic */ boolean val$finalFailed;
                        final /* synthetic */ String val$arguments;
                        final /* synthetic */ AtlassianDevMetricsIncremental val$incremental;
                        {
                            this.val$goal = goal;
                            this.val$finalFailed = bl;
                            this.val$arguments = string;
                            this.val$incremental = atlassianDevMetricsIncremental;
                            this.put("goal", this.val$goal.toString());
                            this.put("failed", Boolean.toString(this.val$finalFailed));
                            this.put("script", AtlassianDevMetricsReporter.getScriptFromArguments(this.val$arguments));
                            this.put("incremental", this.val$incremental.toString());
                        }
                    });
                    throw throwable;
                }
            }
        }
        AtlassianDevMetricsIncremental incremental = atlassianDevMetricsIncremental;
        boolean finalFailed = failed;
        AtlassianDevMetricsReporter.incrementCount("execute", artifactId, forkVersion, (Map<String, String>)new /* invalid duplicate definition of identical inner class */);
    }

    public static void incrementCount(String name, String artifactId, String forkVersion, Map<String, String> tags) {
        if (isOffline) {
            log.debug("Not reporting count {} because not online!", (Object)name);
            return;
        }
        EXECUTOR_SERVICE.submit(() -> {
            tags.putAll(AtlassianDevMetricsReporter.getDefaultTags(artifactId, forkVersion));
            AtlassianDevMetric count = new AtlassianDevMetric(AtlassianDevMetricType.COUNTER, METRIC_NAME_PREFIX + name, String.valueOf(1), tags);
            AtlassianDevMetric countByArtifact = new AtlassianDevMetric(AtlassianDevMetricType.COUNTER, METRIC_NAME_PREFIX + name + METRIC_BY_ARTIFACT_SUFFIX, String.valueOf(1), tags);
            AtlassianDevMetricsReporter.sendMetricOverHttp(count);
            AtlassianDevMetricsReporter.sendMetricOverHttp(countByArtifact);
        });
    }

    public static String formatBunVersionForMetric(String bunVersion) {
        Matcher matcher = BUN_VERSION_PATTERN.matcher(bunVersion);
        matcher.find();
        return matcher.group(1);
    }

    public static String formatNodeVersionForMetric(String nodeVersion) {
        return nodeVersion.substring(0, nodeVersion.indexOf(46)).replaceFirst("v", "");
    }

    public static String getHostForMetric(String hostSetting, String defaultHost, boolean triedToUsePac, boolean failedToUsePac) {
        String PAC = "packages.atlassian.com";
        String unknown = "unknown";
        List<String> hosts = Arrays.asList(PAC, "github.com", "npmjs.org", "nodejs.org");
        if (!Utils.isBlank(hostSetting)) {
            if (triedToUsePac && !failedToUsePac) {
                return PAC;
            }
            for (String candidateHost : hosts) {
                if (!hostSetting.contains(candidateHost)) continue;
                return candidateHost;
            }
            return unknown;
        }
        for (String candidateHost : hosts) {
            if (!defaultHost.contains(candidateHost)) continue;
            return candidateHost;
        }
        return unknown;
    }

    static String getScriptFromArguments(String arguments) {
        if (Objects.isNull(arguments)) {
            arguments = "";
        }
        if (arguments.contains("test") || arguments.contains("check") || arguments.contains("visreg") || arguments.contains("jest") || arguments.contains("storybook")) {
            return "test";
        }
        if (arguments.contains("lint") || arguments.contains("prettier") || arguments.contains("checkstyle") || arguments.contains("format")) {
            return "lint";
        }
        if (arguments.contains("webpack") || arguments.contains("gulp") || arguments.contains("build") || arguments.contains("dist") || arguments.contains("tsc")) {
            return "build";
        }
        if (arguments.contains("install") || arguments.startsWith("ci ") || "ci".equals(arguments)) {
            return "install";
        }
        return "other";
    }

    public static class Timer {
        private final Instant start = Instant.now();

        public void stop(String name, String artifactId, String forkVersion, String runtimeVersion, Map<String, String> tags) {
            if (isOffline) {
                log.debug("Not reporting timer {} because not online!", (Object)name);
                return;
            }
            Instant end = Instant.now();
            EXECUTOR_SERVICE.submit(() -> {
                tags.put("profiler-cores", Integer.toString(Runtime.getRuntime().availableProcessors()));
                tags.put(AtlassianDevMetricsReporter.RUNTIME_VERSION_TAG_NAME, runtimeVersion);
                tags.putAll(AtlassianDevMetricsReporter.getDefaultTags(artifactId, forkVersion));
                AtlassianDevMetric timer = new AtlassianDevMetric(AtlassianDevMetricType.TIME, AtlassianDevMetricsReporter.METRIC_NAME_PREFIX + name, String.valueOf(Duration.between(this.start, end).toMillis()), tags);
                AtlassianDevMetric timerByArtifact = new AtlassianDevMetric(AtlassianDevMetricType.TIME, AtlassianDevMetricsReporter.METRIC_NAME_PREFIX + name + AtlassianDevMetricsReporter.METRIC_BY_ARTIFACT_SUFFIX, String.valueOf(Duration.between(this.start, end).toMillis()), tags);
                AtlassianDevMetricsReporter.sendMetricOverHttp(timer);
                AtlassianDevMetricsReporter.sendMetricOverHttp(timerByArtifact);
            });
        }
    }

    public static enum Goal {
        BOWER,
        BUN,
        COREPACK,
        EMBER,
        GRUNT,
        GULP,
        JSPM,
        KARMA,
        NPM,
        NPX,
        PNPM,
        WEBPACK,
        YARN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

