/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsInstallationWork;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorepackInstaller {
    private static final String VERSION = "version";
    public static final String ATLASSIAN_COREPACK_DOWNLOAD_ROOT = "https://packages.atlassian.com/artifactory/api/npm/npm-remote/corepack/-/";
    public static final String DEFAULT_COREPACK_DOWNLOAD_ROOT = "https://registry.npmjs.org/corepack/-/";
    private static final Object LOCK = new Object();
    private String corepackVersion;
    private String corepackDownloadRoot;
    private String userName;
    private String password;
    private Map<String, String> httpHeaders;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    CorepackInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public CorepackInstaller setNodeVersion(String nodeVersion) {
        return this;
    }

    public CorepackInstaller setCorepackVersion(String corepackVersion) {
        this.corepackVersion = corepackVersion;
        return this;
    }

    public CorepackInstaller setCorepackDownloadRoot(String corepackDownloadRoot) {
        this.corepackDownloadRoot = corepackDownloadRoot;
        return this;
    }

    public CorepackInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public CorepackInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    public CorepackInstaller setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtlassianDevMetricsInstallationWork install() throws InstallationException {
        AtlassianDevMetricsInstallationWork work = AtlassianDevMetricsInstallationWork.INSTALLED;
        Object object = LOCK;
        synchronized (object) {
            if (this.corepackDownloadRoot == null || this.corepackDownloadRoot.isEmpty()) {
                this.corepackDownloadRoot = DEFAULT_COREPACK_DOWNLOAD_ROOT;
            }
            if (!this.corepackIsAlreadyInstalled()) {
                work = this.installCorepack();
            }
            if (this.config.getPlatform().isWindows()) {
                this.linkExecutableWindows();
            } else {
                this.linkExecutable();
            }
        }
        return work;
    }

    private boolean corepackIsAlreadyInstalled() {
        try {
            File corepackPackageJson = new File(this.config.getInstallDirectory() + Utils.normalize("/node/node_modules/corepack/package.json"));
            if (corepackPackageJson.exists()) {
                if ("provided".equals(this.corepackVersion)) {
                    return true;
                }
                HashMap data = (HashMap)new ObjectMapper().readValue(corepackPackageJson, HashMap.class);
                if (data.containsKey(VERSION)) {
                    String foundCorepackVersion = data.get(VERSION).toString();
                    if (foundCorepackVersion.equals(this.corepackVersion.replaceFirst("^v", ""))) {
                        this.logger.info("corepack {} is already installed.", (Object)foundCorepackVersion);
                        return true;
                    }
                    this.logger.info("corepack {} was installed, but we need version {}", (Object)foundCorepackVersion, (Object)this.corepackVersion);
                    return false;
                }
                this.logger.info("Could not read corepack version from package.json");
                return false;
            }
            return false;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read package.json", ex);
        }
    }

    private AtlassianDevMetricsInstallationWork installCorepack() throws InstallationException {
        try {
            this.logger.info("Installing corepack version {}", (Object)this.corepackVersion);
            String corepackVersionClean = this.corepackVersion.replaceFirst("^v(?=[0-9]+)", "");
            String downloadUrl = this.corepackDownloadRoot + "corepack-" + corepackVersionClean + ".tgz";
            CacheDescriptor cacheDescriptor = new CacheDescriptor("corepack", corepackVersionClean, "tar.gz");
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            AtlassianDevMetricsInstallationWork work = this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password, this.httpHeaders);
            File installDirectory = this.getNodeInstallDirectory();
            File nodeModulesDirectory = new File(installDirectory, "node_modules");
            File oldDirectory = new File(installDirectory, "corepack");
            File corepackDirectory = new File(nodeModulesDirectory, "corepack");
            try {
                if (oldDirectory.isDirectory()) {
                    FileUtils.deleteDirectory((File)oldDirectory);
                }
                FileUtils.deleteDirectory((File)corepackDirectory);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete existing corepack installation.");
            }
            File packageDirectory = new File(nodeModulesDirectory, "package");
            try {
                this.extractFile(archive, nodeModulesDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                    if (packageDirectory.exists()) {
                        FileUtils.deleteDirectory((File)packageDirectory);
                    }
                }
                throw e;
            }
            if (packageDirectory.exists() && !corepackDirectory.exists() && !packageDirectory.renameTo(corepackDirectory)) {
                this.logger.warn("Cannot rename corepack directory, making a copy.");
                FileUtils.copyDirectory((File)packageDirectory, (File)corepackDirectory);
            }
            this.logger.info("Installed corepack locally.");
            return work;
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download corepack", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the corepack archive", e);
        }
        catch (IOException e) {
            throw new InstallationException("Could not copy corepack", e);
        }
    }

    private void linkExecutable() throws InstallationException {
        File nodeInstallDirectory = this.getNodeInstallDirectory();
        File corepackExecutable = new File(nodeInstallDirectory, "corepack");
        if (corepackExecutable.exists()) {
            this.logger.info("Existing corepack executable found, skipping linking.");
            return;
        }
        InstallNodeExecutorConfig executorConfig = new InstallNodeExecutorConfig(this.config);
        File corepackJsExecutable = executorConfig.getCorepackPath();
        if (!corepackJsExecutable.exists()) {
            throw new InstallationException("Could not link to corepack executable, no corepack installation found.");
        }
        this.logger.info("No corepack executable found, creating symbolic link to {}.", (Object)corepackJsExecutable.toPath());
        try {
            Files.createSymbolicLink(corepackExecutable.toPath(), corepackJsExecutable.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InstallationException("Could not create symbolic link for corepack executable.", e);
        }
    }

    private void linkExecutableWindows() throws InstallationException {
        File nodeInstallDirectory = this.getNodeInstallDirectory();
        File corepackExecutable = new File(nodeInstallDirectory, "corepack.cmd");
        if (corepackExecutable.exists()) {
            this.logger.info("Existing corepack executable found, skipping linking.");
            return;
        }
        InstallNodeExecutorConfig executorConfig = new InstallNodeExecutorConfig(this.config);
        File corepackJsExecutable = executorConfig.getCorepackPath();
        if (!corepackJsExecutable.exists()) {
            throw new InstallationException("Could not link to corepack executable, no corepack installation found.");
        }
        this.logger.info("No corepack executable found, creating proxy script to {}.", (Object)corepackJsExecutable.toPath());
        Path nodePath = executorConfig.getNodePath().toPath();
        Path relativeNodePath = nodeInstallDirectory.toPath().relativize(nodePath);
        Path relativeCorepackPath = nodeInstallDirectory.toPath().relativize(corepackJsExecutable.toPath());
        String scriptContents = ":: Created by frontend-maven-plugin, please don't edit manually.\r\n" + "@ECHO OFF\r\n" + "\r\n" + "SETLOCAL\r\n" + "\r\n" + String.format("SET \"NODE_EXE=%%~dp0\\%s\"\r\n", relativeNodePath) + String.format("SET \"COREPACK_CLI_JS=%%~dp0\\%s\"\r\n", relativeCorepackPath) + "\r\n" + "\"%NODE_EXE%\" \"%COREPACK_CLI_JS%\" %*";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(corepackExecutable));
            writer.write(scriptContents);
            writer.close();
        }
        catch (IOException e) {
            throw new InstallationException("Could not create proxy script for corepack executable.", e);
        }
    }

    private File getNodeInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), "/node");
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private AtlassianDevMetricsInstallationWork downloadFileIfMissing(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password, httpHeaders);
            return AtlassianDevMetricsInstallationWork.DOWNLOADED;
        }
        return AtlassianDevMetricsInstallationWork.CACHED;
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password, httpHeaders);
    }
}

