/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultFileDownloader
implements FileDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDownloader.class);
    private final ProxyConfig proxyConfig;

    public DefaultFileDownloader(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public void download(String downloadUrl, String destination, String userName, String password, Map<String, String> httpHeaders) throws DownloadException {
        System.setProperty("https.protocols", "TLSv1.2");
        String fixedDownloadUrl = downloadUrl;
        try {
            fixedDownloadUrl = FilenameUtils.separatorsToUnix((String)fixedDownloadUrl);
            URI downloadURI = new URI(fixedDownloadUrl);
            if ("file".equalsIgnoreCase(downloadURI.getScheme())) {
                FileUtils.copyFile((File)new File(downloadURI), (File)new File(destination));
            } else {
                CloseableHttpResponse response = this.execute(fixedDownloadUrl, userName, password, httpHeaders);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new DownloadException("Got error code " + statusCode + " from the server.");
                }
                byte[] data = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
                new File(FilenameUtils.getFullPathNoEndSeparator((String)destination)).mkdirs();
                FileUtils.writeByteArrayToFile((File)new File(destination), (byte[])data);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new DownloadException("Could not download " + fixedDownloadUrl, e);
        }
    }

    private CloseableHttpResponse execute(String requestUrl, String userName, String password, Map<String, String> httpHeaders) throws IOException {
        HttpGet request = new HttpGet(requestUrl);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        ProxyConfig.Proxy proxy = this.proxyConfig.getProxyForUrl(requestUrl);
        if (proxy != null) {
            LOGGER.info("Downloading via proxy " + proxy.toString());
            RequestConfig requestConfig = RequestConfig.custom().setProxy(new HttpHost(proxy.host, proxy.port)).build();
            request.setConfig(requestConfig);
            if (proxy.useAuthentication()) {
                credentialsProvider.setCredentials(new AuthScope(proxy.host, proxy.port), (Credentials)new UsernamePasswordCredentials(proxy.username, proxy.password));
            }
        } else {
            LOGGER.info("No proxy was configured, downloading directly");
        }
        if (httpHeaders != null) {
            for (Map.Entry<String, String> header : httpHeaders.entrySet()) {
                LOGGER.info("Using HTTP-Header (" + header.getKey() + ") from settings.xml");
                request.addHeader(header.getKey(), header.getValue());
            }
        }
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)password)) {
            LOGGER.info("Using credentials (" + userName + ") from settings.xml");
            URL targetUrl = new URL(requestUrl);
            credentialsProvider.setCredentials(new AuthScope(targetUrl.getHost(), targetUrl.getPort()), (Credentials)new UsernamePasswordCredentials(userName, password));
            HttpClientContext localContext = this.makeLocalContext(targetUrl);
            return this.buildHttpClient((CredentialsProvider)credentialsProvider).execute((HttpUriRequest)request, (HttpContext)localContext);
        }
        return this.buildHttpClient((CredentialsProvider)credentialsProvider).execute((HttpUriRequest)request);
    }

    private HttpClientContext makeLocalContext(URL requestUrl) {
        HttpHost target = new HttpHost(requestUrl.getHost(), requestUrl.getPort(), requestUrl.getProtocol());
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        return localContext;
    }

    private CloseableHttpClient buildHttpClient(CredentialsProvider credentialsProvider) {
        return HttpClients.custom().disableContentCompression().useSystemProperties().setDefaultCredentialsProvider(credentialsProvider).build();
    }
}

