/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.rosetta.jdbi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.rosetta.RosettaBinder;
import com.hubspot.rosetta.jdbi.BindWithRosetta;
import com.hubspot.rosetta.jdbi.RosettaObjectMapperOverride;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.Binder;

public enum RosettaJdbiBinder implements Binder<BindWithRosetta, Object>
{
    INSTANCE;


    public void bind(final SQLStatement<?> q, BindWithRosetta bind, Object arg) {
        ObjectMapper objectMapper = RosettaObjectMapperOverride.resolve(q.getContext());
        JsonNode node = objectMapper.valueToTree(arg);
        String prefix = bind.value();
        if (node.isValueNode() || node.isArray()) {
            node = objectMapper.createObjectNode().set(prefix.isEmpty() ? "it" : prefix, node);
            prefix = "";
        }
        RosettaBinder.INSTANCE.bind(prefix, node, new RosettaBinder.Callback(){

            public void bind(String key, Object value) {
                q.bind(key, value);
            }
        });
    }
}

