/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.rosetta.jdbi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.rosetta.RosettaMapper;
import com.hubspot.rosetta.jdbi.RosettaObjectMapperOverride;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.BuiltInArgumentFactory;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class RosettaMapperFactory
implements ResultSetMapperFactory {
    public boolean accepts(Class type, StatementContext ctx) {
        return !type.isPrimitive() && !type.isArray() && !type.isAnnotation() && !BuiltInArgumentFactory.canAccept((Class)type);
    }

    public ResultSetMapper mapperFor(Class rawType, StatementContext ctx) {
        ObjectMapper objectMapper = RosettaObjectMapperOverride.resolve(ctx);
        Type genericType = ctx.getSqlObjectMethod() == null ? rawType : RosettaMapperFactory.determineGenericReturnType(rawType, ctx.getSqlObjectMethod().getGenericReturnType());
        final RosettaMapper mapper = new RosettaMapper(genericType, objectMapper, RosettaMapperFactory.extractTableName(ctx.getRewrittenSql()));
        return new ResultSetMapper(){

            public Object map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                return mapper.mapRow(r);
            }
        };
    }

    static Type determineGenericReturnType(Class rawType, Type returnType) {
        if (rawType == returnType || !(returnType instanceof ParameterizedType)) {
            return rawType;
        }
        ParameterizedType parameterizedType = (ParameterizedType)returnType;
        if (rawType == parameterizedType.getRawType()) {
            return parameterizedType;
        }
        if (parameterizedType.getActualTypeArguments().length == 1) {
            return RosettaMapperFactory.determineGenericReturnType(rawType, parameterizedType.getActualTypeArguments()[0]);
        }
        return rawType;
    }

    static String extractTableName(String sql) {
        String from;
        String lowerCaseSql = sql.toLowerCase();
        int fromIndex = lowerCaseSql.indexOf(from = " from ");
        if (fromIndex < 0) {
            return null;
        }
        String tableString = sql.substring(fromIndex + from.length());
        if (tableString.startsWith("(")) {
            return null;
        }
        int endTableIndex = -1;
        for (int i = 0; i < tableString.length(); ++i) {
            char c = tableString.charAt(i);
            if (c != ' ' && c != ',' && c != ';') continue;
            endTableIndex = i;
            break;
        }
        return endTableIndex < 0 ? tableString : tableString.substring(0, endTableIndex);
    }
}

