/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastleconnector;

import com.itextpdf.bouncycastle.BouncyCastleFactory;
import com.itextpdf.bouncycastleconnector.BouncyCastleDefaultFactory;
import com.itextpdf.bouncycastlefips.BouncyCastleFipsFactory;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.utils.SystemUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BouncyCastleFactoryCreator {
    private static IBouncyCastleFactory factory;
    private static Map<String, Supplier<IBouncyCastleFactory>> factories;
    private static final String FACTORY_ENVIRONMENT_VARIABLE_NAME = "ITEXT_BOUNCY_CASTLE_FACTORY_NAME";
    private static final Logger LOGGER;

    private BouncyCastleFactoryCreator() {
    }

    public static void setFactory(IBouncyCastleFactory newFactory) {
        factory = newFactory;
    }

    public static IBouncyCastleFactory getFactory() {
        return factory;
    }

    private static void tryCreateFactory(Supplier<IBouncyCastleFactory> factoryCreator) {
        try {
            BouncyCastleFactoryCreator.createFactory(factoryCreator);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static void createFactory(Supplier<IBouncyCastleFactory> factoryCreator) {
        factory = factoryCreator.get();
    }

    private static void populateFactoriesMap() {
        factories.put("bouncy-castle", () -> new BouncyCastleFactory());
        factories.put("bouncy-castle-fips", () -> new BouncyCastleFipsFactory());
    }

    static {
        factories = new LinkedHashMap<String, Supplier<IBouncyCastleFactory>>();
        LOGGER = LoggerFactory.getLogger(BouncyCastleFactoryCreator.class);
        BouncyCastleFactoryCreator.populateFactoriesMap();
        String factoryName = SystemUtil.getPropertyOrEnvironmentVariable((String)FACTORY_ENVIRONMENT_VARIABLE_NAME);
        Supplier<IBouncyCastleFactory> systemVariableFactoryCreator = factories.get(factoryName);
        if (systemVariableFactoryCreator != null) {
            BouncyCastleFactoryCreator.tryCreateFactory(systemVariableFactoryCreator);
        }
        for (Supplier<IBouncyCastleFactory> factorySupplier : factories.values()) {
            if (factory != null) break;
            BouncyCastleFactoryCreator.tryCreateFactory(factorySupplier);
        }
        if (factory == null) {
            LOGGER.error("Either com.itextpdf:bouncy-castle-adapter or com.itextpdf:bouncy-castle-fips-adapter dependency must be added in order to use BouncyCastleFactoryCreator");
            factory = new BouncyCastleDefaultFactory();
        }
    }
}

