/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CSS;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.html.CssApplier;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

@Deprecated
public class NoNewLineParagraphCssApplier
implements CssApplier<NoNewLineParagraph> {
    private final CssUtils utils = CssUtils.getInstance();

    public NoNewLineParagraph apply(NoNewLineParagraph p, Tag t, MarginMemory configuration) {
        return this.apply(p, t, configuration, (PageSizeContainable)null, (HtmlPipelineContext)null);
    }

    @Override
    public NoNewLineParagraph apply(NoNewLineParagraph p, Tag t, MarginMemory configuration, PageSizeContainable psc, HtmlPipelineContext ctx) {
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        float lmb = 0.0f;
        boolean hasLMB = false;
        Map<String, String> css = t.getCSS();
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.calculateMarginTop(value, fontSize, configuration));
                continue;
            }
            if ("padding-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float after = this.utils.parseValueToPt(value, fontSize);
                p.setSpacingAfter(p.getSpacingAfter() + after);
                lmb = after;
                hasLMB = true;
                continue;
            }
            if ("padding-bottom".equalsIgnoreCase(key)) {
                p.setSpacingAfter(p.getSpacingAfter() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("text-align".equalsIgnoreCase(key)) {
                p.setAlignment(CSS.getElementAlignment(value));
                continue;
            }
            if (!"text-indent".equalsIgnoreCase(key)) continue;
            p.setFirstLineIndent(this.utils.parseValueToPt(value, fontSize));
        }
        if (null != t.getParent()) {
            String parent = t.getParent().getName();
            if (css.get("margin-top") == null && configuration.getRootTags().contains(parent)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.calculateMarginTop(fontSize + "pt", 0.0f, configuration));
            }
            if (css.get("margin-bottom") == null && configuration.getRootTags().contains(parent)) {
                p.setSpacingAfter(p.getSpacingAfter() + fontSize);
                css.put("margin-bottom", fontSize + "pt");
                lmb = fontSize;
                hasLMB = true;
            }
            if (p.getAlignment() == -1) {
                p.setAlignment(0);
            }
        }
        if (hasLMB) {
            configuration.setLastMarginBottom(Float.valueOf(lmb));
        }
        return p;
    }
}

