/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa;

import com.itextpdf.bouncycastle.cms.RecipientBC;
import com.itextpdf.bouncycastle.cms.RecipientIdBC;
import com.itextpdf.kernel.security.IExternalDecryptionProcess;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.security.ExternalDecryptionProcess;
import com.itextpdf.tool.xml.xtra.xfa.MetaData;
import com.itextpdf.tool.xml.xtra.xfa.PdfALevel;
import java.io.InputStream;
import java.security.Key;
import java.security.cert.Certificate;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;

public class XFAFlattenerProperties {
    private char pdfVersion;
    private boolean skipFormStateChecksumCheck = false;
    private boolean xmpMetaData = false;
    private boolean tagged = false;
    private OutputIntent outputIntent;
    private PdfALevel conformanceLevel;
    private MetaData metaData;
    private ReaderProperties readerProperties = new ReaderProperties();
    public static final char PDF_1_0 = '0';
    public static final char PDF_1_1 = '1';
    public static final char PDF_1_2 = '2';
    public static final char PDF_1_3 = '3';
    public static final char PDF_1_4 = '4';
    public static final char PDF_1_5 = '5';
    public static final char PDF_1_6 = '6';
    public static final char PDF_1_7 = '7';

    public XFAFlattenerProperties() {
        this.pdfVersion = (char)52;
    }

    public XFAFlattenerProperties setOutputIntent(InputStream iccInputStream, String outputConditionIdentifier, String outputCondition, String registryName, String info) {
        this.outputIntent = new OutputIntent(ICC_Profile.getInstance(iccInputStream), outputConditionIdentifier, outputCondition, registryName, info);
        return this;
    }

    public PdfALevel getConformanceLevel() {
        return this.conformanceLevel;
    }

    public XFAFlattenerProperties setConformanceLevel(PdfALevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
        return this;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public XFAFlattenerProperties setTagged() {
        this.tagged = true;
        return this;
    }

    public boolean needsXmpMetaData() {
        return this.xmpMetaData;
    }

    public XFAFlattenerProperties createXmpMetaData() {
        this.xmpMetaData = true;
        return this;
    }

    public char getPfdVersion() {
        return this.pdfVersion;
    }

    public XFAFlattenerProperties setPdfVersion(char pdfVersion) {
        this.pdfVersion = pdfVersion;
        return this;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public XFAFlattenerProperties setMetaData(MetaData metaData) {
        this.metaData = metaData;
        return this;
    }

    public XFAFlattenerProperties setOpenPassword(byte[] password) {
        this.readerProperties.setPassword(password);
        return this;
    }

    public XFAFlattenerProperties setOpenPublicKeySecurityParams(Certificate certificate, Key certificateKey, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess) {
        this.readerProperties.setPublicKeySecurityParams(certificate, certificateKey, certificateKeyProvider, externalDecryptionProcess);
        return this;
    }

    public XFAFlattenerProperties setOpenPublicKeySecurityParams(Certificate certificate, IExternalDecryptionProcess externalDecryptionProcess) {
        this.readerProperties.setPublicKeySecurityParams(certificate, externalDecryptionProcess);
        return this;
    }

    public boolean isSkipFormStateChecksumCheck() {
        return this.skipFormStateChecksumCheck;
    }

    public void setSkipFormStateChecksumCheck(boolean skipFormStateChecksumCheck) {
        this.skipFormStateChecksumCheck = skipFormStateChecksumCheck;
    }

    OutputIntent getOutputIntent() {
        return this.outputIntent;
    }

    ReaderProperties getReaderProperties() {
        return this.readerProperties;
    }

    private static class LegacyExternalDecryptionProcess
    implements ExternalDecryptionProcess {
        IExternalDecryptionProcess newExtDecrProc;

        LegacyExternalDecryptionProcess(IExternalDecryptionProcess newExtDecrProc) {
            this.newExtDecrProc = newExtDecrProc;
        }

        @Override
        public RecipientId getCmsRecipientId() {
            return ((RecipientIdBC)this.newExtDecrProc.getCmsRecipientId()).getRecipientId();
        }

        @Override
        public Recipient getCmsRecipient() {
            return ((RecipientBC)this.newExtDecrProc.getCmsRecipient()).getRecipient();
        }
    }

    static class ReaderProperties {
        byte[] password;
        Key certificateKey;
        Certificate certificate;
        String certificateKeyProvider;
        LegacyExternalDecryptionProcess externalDecryptionProcess;

        ReaderProperties() {
        }

        ReaderProperties setPassword(byte[] password) {
            this.clearEncryptionParams();
            this.password = password;
            return this;
        }

        ReaderProperties setPublicKeySecurityParams(Certificate certificate, Key certificateKey, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess) {
            this.clearEncryptionParams();
            this.certificate = certificate;
            this.certificateKey = certificateKey;
            this.certificateKeyProvider = certificateKeyProvider;
            this.externalDecryptionProcess = new LegacyExternalDecryptionProcess(externalDecryptionProcess);
            return this;
        }

        ReaderProperties setPublicKeySecurityParams(Certificate certificate, IExternalDecryptionProcess externalDecryptionProcess) {
            this.clearEncryptionParams();
            this.certificate = certificate;
            this.externalDecryptionProcess = new LegacyExternalDecryptionProcess(externalDecryptionProcess);
            return this;
        }

        private void clearEncryptionParams() {
            this.password = null;
            this.certificate = null;
            this.certificateKey = null;
            this.certificateKeyProvider = null;
            this.externalDecryptionProcess = null;
        }
    }

    class OutputIntent {
        private ICC_Profile icc;
        private String outputConditionIdentifier;
        private String outputCondition;
        private String registryName;
        private String info;

        private OutputIntent(ICC_Profile icc, String outputConditionIdentifier, String outputCondition, String registryName, String info) {
            this.icc = icc;
            this.outputConditionIdentifier = outputConditionIdentifier;
            this.outputCondition = outputCondition;
            this.registryName = registryName;
            this.info = info;
        }

        public ICC_Profile getIcc() {
            return this.icc;
        }

        public OutputIntent setIcc(ICC_Profile icc) {
            this.icc = icc;
            return this;
        }

        public String getOutputConditionIdentifier() {
            return this.outputConditionIdentifier;
        }

        public OutputIntent setOutputConditionIdentifier(String outputConditionIdentifier) {
            this.outputConditionIdentifier = outputConditionIdentifier;
            return this;
        }

        public String getOutputCondition() {
            return this.outputCondition;
        }

        public OutputIntent setOutputCondition(String outputCondition) {
            this.outputCondition = outputCondition;
            return this;
        }

        public String getRegistryName() {
            return this.registryName;
        }

        public OutputIntent setRegistryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public String getInfo() {
            return this.info;
        }

        public OutputIntent setInfo(String info) {
            this.info = info;
            return this;
        }
    }
}

