/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa;

import com.itextpdf.text.Element;
import com.itextpdf.text.FontProvider;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.css.XfaCssInheritanceRules;
import com.itextpdf.tool.xml.css.apply.XFAChunkCssApplier;
import com.itextpdf.tool.xml.css.apply.XFACssAppliersImpl;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.xtra.xfa.pipe.LocalContextElementHandlerPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.TemplateBuilderPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.XFAHtmlPipeline;
import com.itextpdf.tool.xml.xtra.xfa.resolver.SomExpression;
import com.itextpdf.tool.xml.xtra.xfa.tags.RichTextTags;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFAWorker
extends XMLWorker {
    static final Logger logger = LoggerFactory.getLogger(XFAWorker.class);
    protected SomExpression somExpession;
    protected Tag parentTag;
    protected Tag currentFragmentTag;
    protected Tag rootParsedTag;

    public XFAWorker(Pipeline<?> pipeline) {
        super(pipeline, false);
    }

    public XFAWorker(Pipeline<?> pipeline, Tag parentTag, SomExpression somExpression) {
        this(pipeline);
        this.parentTag = parentTag;
        this.somExpession = somExpression;
    }

    @Override
    public void init() {
        Pipeline<?> p = this.rootpPipe;
        if (this.parentTag == null) {
            try {
                while ((p = p.init(XFAWorker.getLocalWC())) != null) {
                }
            }
            catch (PipelineException e) {
                throw new RuntimeWorkerException(e);
            }
        }
    }

    @Override
    protected XFATemplateTag createTag(String tag, Map<String, String> attr, String ns) {
        return new XFATemplateTag(tag, attr, ns);
    }

    @Override
    public void close() {
    }

    public static WorkerContext getWorkerContext() {
        return XFAWorker.getLocalWC();
    }

    public static void closeWorkerContext() {
        XFAWorker.closeLocalWC();
    }

    public static Tag parseTemplatePart(InputStream templateStream, Charset charset) throws IOException {
        TemplateBuilderPipeline pipeline = new TemplateBuilderPipeline(null);
        XFAWorker worker = new XFAWorker(pipeline);
        XMLParser parser = new XMLParser(false, worker);
        parser.parse(templateStream, charset);
        return worker.rootParsedTag;
    }

    public static RichTextParseResult parseRichTextPart(InputStream richTextStream, FontProvider fontProvider, Charset charset) throws IOException, PipelineException {
        XFACssAppliersImpl cssAppliers = new XFACssAppliersImpl();
        cssAppliers.setChunkCssAplier(new XFAChunkCssApplier(fontProvider));
        HtmlPipelineContext hpc = new HtmlPipelineContext(cssAppliers);
        hpc.setAcceptUnknown(true).setTagFactory(RichTextTags.getRichTextTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(new StyleAttrCSSResolver(new XfaCssInheritanceRules(), new CssFilesImpl(), CssUtils.getInstance()), new XFAHtmlPipeline(hpc, new LocalContextElementHandlerPipeline(null)));
        XFAWorker worker = new XFAWorker(pipeline);
        XMLParser parser = new XMLParser(false, worker);
        parser.parse(richTextStream, charset);
        XFAHtmlPipeline htmlPipeline = (XFAHtmlPipeline)pipeline.getNext();
        List list = (List)((ObjectContext)((LocalContextElementHandlerPipeline)htmlPipeline.getNext()).getLocalContext(worker.getWorkerContext())).get();
        return new RichTextParseResult(htmlPipeline.getRootTag(), list);
    }

    @Override
    public void startElement(String tag, Map<String, String> attr, String ns) {
        Tag t = this.createTag(tag, (Map)attr, ns);
        WorkerContext ctx = XFAWorker.getLocalWC();
        if (null != ctx.getCurrentTag()) {
            ctx.getCurrentTag().addChild(t);
        }
        ctx.setCurrentTag(t);
        if (this.rootParsedTag == null) {
            this.rootParsedTag = t;
        }
        if (this.somExpession != null && this.somExpession.matchAndPop((XFATemplateTag)t) && this.somExpession.getNodePath().size() == 0) {
            this.currentFragmentTag = t;
            this.parentTag.getChildren().clear();
            for (Map.Entry<String, String> attribute : t.getAttributes().entrySet()) {
                if (this.parentTag.getAttributes().get(attribute.getKey()) != null) continue;
                this.parentTag.getAttributes().put(attribute.getKey(), attribute.getValue());
            }
            ((XFATemplateTag)this.parentTag).setBind(null);
            ctx.setCurrentTag(this.parentTag);
            if (logger.isDebugEnabled()) {
                logger.debug("Usehref: " + this.currentFragmentTag.getAttributes().get("name") + " resolved!");
            }
        }
        Pipeline<?> wp = this.rootpPipe;
        ProcessObject po = new ProcessObject();
        try {
            while (null != (wp = wp.open(ctx, t, po))) {
            }
        }
        catch (PipelineException e) {
            throw new RuntimeWorkerException(e);
        }
    }

    @Override
    public void endElement(String tag, String ns) {
        String thetag = null;
        thetag = this.parseHtml ? tag.toLowerCase() : tag;
        WorkerContext ctx = XFAWorker.getLocalWC();
        if (null != ctx.getCurrentTag() && !thetag.equals(ctx.getCurrentTag().getName())) {
            throw new RuntimeWorkerException(String.format(LocaleMessages.getInstance().getMessage("tag.invalidnesting"), thetag, ctx.getCurrentTag().getName()));
        }
        if (this.parentTag == ctx.getCurrentTag()) {
            ctx.setCurrentTag(this.currentFragmentTag);
        }
        Pipeline<?> wp = this.rootpPipe;
        ProcessObject po = new ProcessObject();
        try {
            while (null != (wp = wp.close(ctx, ctx.getCurrentTag(), po))) {
            }
        }
        catch (PipelineException e) {
            throw new RuntimeWorkerException(e);
        }
        finally {
            if (null != ctx.getCurrentTag()) {
                ctx.setCurrentTag(ctx.getCurrentTag().getParent());
            }
        }
    }

    @Override
    protected boolean ignoreCdata() {
        return false;
    }

    public static class RichTextParseResult {
        protected Tag richTextRootTag;
        protected List<Element> richTextElements;

        public RichTextParseResult(Tag richTextRootTag, List<Element> richTextElements) {
            this.richTextRootTag = richTextRootTag;
            this.richTextElements = richTextElements;
        }

        public Tag getRichTextRootTag() {
            return this.richTextRootTag;
        }

        public List<Element> getRichTextElements() {
            return this.richTextElements;
        }
    }
}

