/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.element.AbstractDrawer;
import com.itextpdf.tool.xml.xtra.xfa.format.FormattingElement;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.HashMap;
import java.util.Map;

public class ArcDrawer
extends AbstractDrawer {
    protected Boolean fill = false;
    protected BaseColor fillColor = BaseColor.BLACK;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected FormattingElement fe;
    protected float startAngle = 0.0f;
    protected float sweepAngle = 360.0f;
    protected boolean circular = false;
    boolean hasLoweredStyle = false;
    boolean hasEmbossedStyle = false;
    boolean hasEtchedStyle = false;
    boolean hasRaisedStyle = false;
    boolean hasOtherStyle = false;

    public ArcDrawer(FormNode arc) {
        FormNode fill;
        if (arc.retrieveAttributes() != null) {
            String circular;
            String sweepAngle;
            this.attributes = arc.retrieveAttributes();
            String startAngle = this.attributes.get("startAngle");
            if (startAngle != null) {
                this.startAngle = XFAUtil.parseFloat(startAngle).floatValue();
            }
            if ((sweepAngle = this.attributes.get("sweepAngle")) != null) {
                this.sweepAngle = XFAUtil.parseFloat(sweepAngle).floatValue();
            }
            if ("1".equals(circular = this.attributes.get("circular"))) {
                this.circular = true;
            }
        }
        if ((fill = arc.retrieveChild("fill")) != null) {
            String colorValue;
            this.fill = true;
            FormNode color = fill.retrieveChild("color");
            if (color != null && (colorValue = color.retrieveAttribute("value")) != null && colorValue.length() > 0) {
                this.fillColor = XFAUtil.parseXfaColor(colorValue);
            }
        }
        FormNode edge = arc.retrieveChild("edge");
        String thickness = null;
        String stroke = null;
        BaseColor color = null;
        if (edge != null) {
            String colorValue;
            FormNode colorTag;
            Map<String, String> attributes = edge.retrieveAttributes();
            if (attributes != null) {
                thickness = attributes.get("thickness");
                stroke = attributes.get("stroke");
            }
            if ((colorTag = edge.retrieveChild("color")) != null && (colorValue = colorTag.retrieveAttribute("value")) != null && colorValue.length() > 0) {
                color = XFAUtil.parseXfaColor(colorValue);
            }
        }
        this.fe = new FormattingElement();
        if (thickness != null) {
            this.fe.setThickness(Float.valueOf(CssUtils.getInstance().parsePxInCmMmPcToPt(thickness, "pt")));
        }
        if (stroke != null) {
            this.fe.setStroke(stroke);
        }
        if (color != null) {
            this.fe.setColor(color);
        }
        if ("lowered".equals(this.fe.getStroke())) {
            this.hasLoweredStyle = true;
        } else if ("embossed".equals(this.fe.getStroke())) {
            this.hasEmbossedStyle = true;
        } else if ("etched".equals(this.fe.getStroke())) {
            this.hasEtchedStyle = true;
        } else if ("raised".equals(this.fe.getStroke())) {
            this.hasRaisedStyle = true;
        } else {
            this.hasOtherStyle = true;
        }
    }

    @Override
    public void draw(PdfContentByte canvas, XFARectangle borderArea) {
        this.initArcRectangle(borderArea);
        if (this.fill.booleanValue()) {
            if (canvas.isTagged()) {
                canvas.openMCBlock(this);
            }
            canvas.saveState();
            canvas.setColorFill(this.fillColor);
            canvas.arc(this.fe.getX1().floatValue(), this.fe.getY1().floatValue(), this.fe.getX2().floatValue(), this.fe.getY2().floatValue(), this.startAngle, this.sweepAngle);
            canvas.fill();
            canvas.restoreState();
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this);
            }
        }
        if (!(this.hasEmbossedStyle || this.hasEtchedStyle || this.hasRaisedStyle)) {
            if ((double)this.fe.getThickness().floatValue() > 0.001) {
                float y2;
                float y1;
                canvas.saveState();
                if (canvas.isTagged()) {
                    canvas.openMCBlock(this);
                }
                canvas.setLineWidth(this.fe.getThickness().floatValue());
                canvas.setColorStroke(this.fe.getColor());
                this.setLineDash(canvas, this.fe);
                float x1 = this.fe.getX1().floatValue();
                float x2 = this.fe.getX2().floatValue();
                if (x1 != x2) {
                    x1 -= this.fe.getThickness().floatValue() / 2.0f;
                    x2 += this.fe.getThickness().floatValue() / 2.0f;
                }
                if ((y1 = this.fe.getY1().floatValue()) != (y2 = this.fe.getY2().floatValue())) {
                    y1 += this.fe.getThickness().floatValue() / 2.0f;
                    y2 -= this.fe.getThickness().floatValue() / 2.0f;
                }
                canvas.arc(x1, y1, x2, y2, this.startAngle, this.sweepAngle);
                canvas.stroke();
            }
            canvas.restoreState();
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this);
            }
        }
    }

    protected void setLineDash(PdfContentByte canvas, FormattingElement fe) {
        if (fe.getStroke() == null || "solid".equals(fe.getStroke())) {
            canvas.setLineDash(0.0f);
        } else if ("dotted".equals(fe.getStroke())) {
            canvas.setLineDash(fe.getThickness().floatValue(), fe.getThickness().floatValue() * 2.0f, 0.0f);
        } else if ("dashed".equals(fe.getStroke())) {
            canvas.setLineDash(fe.getThickness().floatValue() * 5.0f, fe.getThickness().floatValue() * 1.0f, 0.0f);
        } else if ("dashDot".equals(fe.getStroke())) {
            float[] arr = new float[]{3.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue(), 1.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue()};
            canvas.setLineDash(arr, 0.0f);
        } else if ("dashDotDot".equals(fe.getStroke())) {
            float[] arr = new float[]{3.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue(), 1.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue(), 1.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue()};
            canvas.setLineDash(arr, 0.0f);
        }
    }

    public void initArcRectangle(XFARectangle arcArea) {
        Float x1 = arcArea.getLlx();
        Float y1 = arcArea.getUry();
        Float x2 = Float.valueOf(arcArea.getLlx().floatValue() + arcArea.getWidth().floatValue());
        Float y2 = Float.valueOf(arcArea.getUry().floatValue() - arcArea.getHeight().floatValue());
        if (this.circular) {
            if (arcArea.getWidth().floatValue() > arcArea.getHeight().floatValue()) {
                Float xDelta = Float.valueOf((arcArea.getWidth().floatValue() - arcArea.getHeight().floatValue()) / 2.0f);
                x1 = Float.valueOf(x1.floatValue() + xDelta.floatValue());
                x2 = Float.valueOf(x2.floatValue() - xDelta.floatValue());
            } else {
                Float yDelta = Float.valueOf((arcArea.getWidth().floatValue() - arcArea.getHeight().floatValue()) / 2.0f);
                y1 = Float.valueOf(y1.floatValue() - yDelta.floatValue());
                y2 = Float.valueOf(y2.floatValue() + yDelta.floatValue());
            }
        }
        String hand = this.attributes.get("hand");
        float delta = 0.0f;
        if ("right".equals(hand)) {
            delta = this.fe.getThickness().floatValue();
        } else if (hand == null || "even".equals(hand)) {
            delta = this.fe.getThickness().floatValue() / 2.0f;
        }
        this.fe.setRectanglePoints(Float.valueOf(x1.floatValue() + delta), Float.valueOf(y1.floatValue() - delta), Float.valueOf(x2.floatValue() - delta), Float.valueOf(y2.floatValue() + delta));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

