/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.tool.xml.xtra.xfa.js.ScriptString;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;

public class BreakConditions {
    protected String type;
    protected String target;
    protected boolean startNew;
    protected final String subType;
    protected final SubFormPositioner positioner;
    protected ScriptString script;
    protected SubFormPositioner currentAttachedPositioner;

    public BreakConditions(String subType, String type, String target, boolean startNew, SubFormPositioner positioner, ScriptString script) {
        this.subType = subType;
        this.startNew = startNew;
        this.target = target;
        this.type = type;
        this.positioner = positioner;
        this.script = script;
        this.currentAttachedPositioner = positioner;
    }

    public BreakConditions(BreakConditions other, SubFormPositioner newPositioner) {
        this(other.subType, other.type, other.target, other.startNew, other.positioner, other.script);
        this.currentAttachedPositioner = newPositioner;
    }

    public String getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean getStartNew() {
        return this.startNew;
    }

    public String getSubType() {
        return this.subType;
    }

    public SubFormPositioner getPositioner() {
        return this.positioner;
    }

    public boolean evaluate() {
        if (this.script != null) {
            try {
                Object result = this.positioner.evaluateScript(this.script);
                return result instanceof Boolean && (Boolean)result != false;
            }
            catch (Exception exc) {
                return false;
            }
        }
        return true;
    }

    public static boolean targetsEqual(BreakConditions a, BreakConditions b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        String aType = a.getType();
        String bType = b.getType();
        String aTarget = a.getTarget();
        String bTarget = b.getTarget();
        return BreakConditions.stringsEqual(aType, bType) && BreakConditions.stringsEqual(aTarget, bTarget);
    }

    private static boolean stringsEqual(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }
}

