/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.util.Map;

public class TrailerLeaderElement {
    private XFATemplateTag formTag;
    private int occured = 0;
    private int maxOccur = Integer.MAX_VALUE;
    private XFARectangle boundingBox;

    public TrailerLeaderElement(XFATemplateTag formTag) {
        this.formTag = formTag;
        Tag occurTag = formTag.getChild("occur", "", false);
        if (occurTag != null) {
            Map<String, String> attrs = occurTag.getAttributes();
            String maxStr = attrs.get("max");
            if (maxStr != null && maxStr.length() > 0) {
                try {
                    this.maxOccur = Integer.parseInt(maxStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.maxOccur == -1) {
                this.maxOccur = Integer.MAX_VALUE;
            }
        }
        this.maxOccur = formTag.getMaxOccur();
    }

    public XFATemplateTag getFormTag() {
        return this.formTag;
    }

    public boolean incrementOccur() {
        ++this.occured;
        return this.maxOccur > this.occured;
    }

    public XFARectangle getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(XFARectangle boundingBox) {
        this.boundingBox = boundingBox;
    }
}

