/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.font;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.pdf.BaseFont;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class XFAFont
extends Font {
    public static final int BOLD_FONT_FAMILY = 16;
    public static final int ITALIC_FONT_FAMILY = 32;
    public static final int STYLE_NORMAL = 64;
    public static final int WEIGHT_NORMAL = 128;
    public static final int BOLD_ITALIC_FONT_FAMILY = 48;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private final int instanceId;
    private final FontProvider fontProvider;

    public XFAFont(BaseFont bf, float size, int style, BaseColor color, FontProvider fontProvider) {
        super(bf, size, style, color);
        this.fontProvider = fontProvider;
        this.instanceId = INSTANCE_COUNTER.getAndIncrement();
    }

    public XFAFont(Font.FontFamily family, float size, int style, BaseColor color, FontProvider fontProvider) {
        super(family, size, style, color);
        this.fontProvider = fontProvider;
        this.instanceId = INSTANCE_COUNTER.getAndIncrement();
    }

    public XFAFont(BaseFont bf, float size, int style, FontProvider fontProvider) {
        super(bf, size, style);
        this.fontProvider = fontProvider;
        this.instanceId = INSTANCE_COUNTER.getAndIncrement();
    }

    public XFAFont(Font.FontFamily family, float size, int style, FontProvider fontProvider) {
        super(family, size, style);
        this.fontProvider = fontProvider;
        this.instanceId = INSTANCE_COUNTER.getAndIncrement();
    }

    public XFAFont(Font.FontFamily family, float size, FontProvider fontProvider) {
        super(family, size);
        this.fontProvider = fontProvider;
        this.instanceId = INSTANCE_COUNTER.getAndIncrement();
    }

    @Override
    public Font difference(Font font) {
        return this.difference(font, null);
    }

    public Font difference(Font font, String encoding) {
        BaseColor dColor;
        if (font == null) {
            return this;
        }
        float dSize = font.getSize();
        if (dSize == -1.0f) {
            dSize = this.getSize();
        }
        int dStyle = -1;
        int style1 = this.getStyle();
        int style2 = font.getStyle();
        if (style1 != -1 || style2 != -1) {
            if (style2 == 0) {
                dStyle = 0;
            } else {
                if (style1 == -1) {
                    style1 = 0;
                } else {
                    if ((style1 & 0x10) != 0) {
                        style1 &= 0xFFFFFFEF;
                        style1 |= 1;
                    }
                    if ((style1 & 0x20) != 0) {
                        style1 &= 0xFFFFFFDF;
                        style1 |= 2;
                    }
                }
                if (style2 == -1) {
                    style2 = 0;
                } else {
                    if ((style2 & 0x10) != 0) {
                        style2 &= 0xFFFFFFEF;
                        style2 |= 1;
                    }
                    if ((style2 & 0x20) != 0) {
                        style2 &= 0xFFFFFFDF;
                        style2 |= 2;
                    }
                }
                if ((style2 & 0x80) != 0) {
                    style1 &= 0xFFFFFFFE;
                }
                if ((style2 & 0x40) != 0) {
                    style1 &= 0xFFFFFFFD;
                }
                dStyle = style1 | style2;
            }
        }
        boolean revertStyle = false;
        if (dStyle == -1) {
            revertStyle = true;
            dStyle = style2 = this.getStyle(font.getBaseFont());
        }
        if ((dColor = font.getColor()) == null) {
            dColor = this.getColor();
        }
        Font xfaFont = font.getBaseFont() != null ? (dStyle == style2 && (encoding == null || encoding.equals(font.getBaseFont().getEncoding())) ? new XFAFont(font.getBaseFont(), dSize, font.getStyle(), dColor, this.fontProvider) : this.fontProvider.getFont(font.getFamilyname(), encoding == null ? font.getBaseFont().getEncoding() : encoding, false, dSize, dStyle, dColor)) : (font.getFamily() != Font.FontFamily.UNDEFINED ? (dStyle == style2 ? new XFAFont(font.getFamily(), dSize, font.getStyle(), dColor, this.fontProvider) : this.fontProvider.getFont(font.getFamilyname(), encoding, false, dSize, dStyle, dColor)) : (this.getBaseFont() != null ? (dStyle == style1 && (encoding == null || encoding.equals(this.getBaseFont().getEncoding())) ? new XFAFont(this.getBaseFont(), dSize, this.getStyle(), dColor, this.fontProvider) : this.fontProvider.getFont(this.getFamilyname(), encoding == null ? this.getBaseFont().getEncoding() : encoding, false, dSize, dStyle, dColor)) : new XFAFont(this.getFamily(), dSize, dStyle, dColor, this.fontProvider)));
        if (revertStyle) {
            xfaFont.setStyle(-1);
        }
        return xfaFont;
    }

    private int getStyle(BaseFont font) {
        if (font == null) {
            return -1;
        }
        String fontName = font.getFullFontName()[0][3].toLowerCase();
        int style = 0;
        if (fontName.contains("bold")) {
            style |= 1;
        }
        if (fontName.contains("oblique") || fontName.contains("italic")) {
            style |= 2;
        }
        return style;
    }

    @Override
    public int compareTo(Font font) {
        if (!(font instanceof XFAFont)) {
            return -1;
        }
        if (!Objects.equals(this.getBaseFont(), font.getBaseFont())) {
            return Integer.compare(this.instanceId, ((XFAFont)font).instanceId);
        }
        if (this.getFamily() != font.getFamily()) {
            return this.getFamily().compareTo(font.getFamily());
        }
        if (this.getSize() != font.getSize()) {
            return Float.compare(this.getSize(), font.getSize());
        }
        if (this.getStyle() != font.getStyle()) {
            return Integer.compare(this.getStyle(), font.getStyle());
        }
        if (this.getColor() == null) {
            return font.getColor() == null ? 0 : -1;
        }
        if (font.getColor() == null) {
            return 1;
        }
        return Integer.compare(this.getColor().getRGB(), font.getColor().getRGB());
    }

    public String toString() {
        if (this.getBaseFont() != null) {
            return this.getBaseFont().getPostscriptFontName();
        }
        return "XFAFont{fontProvider=" + this.fontProvider + '}';
    }
}

