/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.pipe;

import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import com.itextpdf.tool.xml.xtra.xfa.pipe.DataContext;
import com.itextpdf.tool.xml.xtra.xfa.pipe.DataPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.FormBuilderPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.LocalePipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.PdfPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.TemplateBuilderPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.XFAFlattenerData;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.resolver.LocaleResolver;

public class XdpPipeline
extends AbstractPipeline {
    private final LocalePipeline localePipeline;
    private final TemplateBuilderPipeline templateBuilderPipeline;
    private final FormBuilderPipeline formBuilderPipeline;
    private final DataPipeline dataPipeline;
    private final PdfPipeline pdfPipeline;
    private boolean xdpOpen = false;
    private static final String XDP = "xdp";
    private static final String LOCALE_SET = "localeSet";
    private static final String TEMPLATE = "template";
    private static final String FORM = "form";
    private static final String DATA_SET = "datasets";
    private static final String PDF = "pdf";
    private CurrentPipeline currentPipeline = CurrentPipeline.none;
    private boolean wasLocale = false;
    private boolean wasTemplate = false;
    private boolean wasForm = false;
    private boolean wasPdf = false;

    public boolean wasLocale() {
        return this.wasLocale;
    }

    public boolean wasTemplate() {
        return this.wasTemplate;
    }

    public boolean wasForm() {
        return this.wasForm;
    }

    public boolean wasPdf() {
        return this.wasPdf;
    }

    public XdpPipeline(LocalePipeline localePipeline, TemplateBuilderPipeline templateBuilderPipeline, FormBuilderPipeline formBuilderPipeline, DataPipeline dataPipeline, PdfPipeline pdfPipeline) {
        super(null);
        this.localePipeline = localePipeline;
        this.templateBuilderPipeline = templateBuilderPipeline;
        this.formBuilderPipeline = formBuilderPipeline;
        this.dataPipeline = dataPipeline;
        this.pdfPipeline = pdfPipeline;
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        if (!this.xdpOpen) {
            if (t.getName().equals(XDP)) {
                this.xdpOpen = true;
            }
        } else {
            switch (this.currentPipeline) {
                case localePipeline: {
                    return this.localePipeline;
                }
                case templatePipeline: {
                    return this.templateBuilderPipeline;
                }
                case formPipeline: {
                    return this.formBuilderPipeline;
                }
                case dataPipeline: {
                    return this.dataPipeline;
                }
                case pdfPipeline: {
                    return this.pdfPipeline;
                }
                case none: {
                    if (t.getParent().getParent() != null || !t.getParent().getName().equals(XDP)) break;
                    if (t.getName().equals(LOCALE_SET)) {
                        this.wasLocale = true;
                        Pipeline<LocaleResolver> p = this.localePipeline;
                        while ((p = p.init(context)) != null) {
                        }
                        this.currentPipeline = CurrentPipeline.localePipeline;
                        return this.localePipeline;
                    }
                    if (t.getName().equals(TEMPLATE)) {
                        this.wasTemplate = true;
                        Pipeline<ObjectContext<XFAFlattenerData>> p = this.templateBuilderPipeline;
                        while ((p = p.init(context)) != null) {
                        }
                        this.currentPipeline = CurrentPipeline.templatePipeline;
                        return this.templateBuilderPipeline;
                    }
                    if (t.getName().equals(FORM)) {
                        this.wasForm = true;
                        Pipeline<ObjectContext<XFAFlattenerData>> p = this.formBuilderPipeline;
                        while ((p = p.init(context)) != null) {
                        }
                        this.currentPipeline = CurrentPipeline.formPipeline;
                        return this.formBuilderPipeline;
                    }
                    if (t.getName().equals(DATA_SET)) {
                        Pipeline<DataContext> p = this.dataPipeline;
                        while ((p = p.init(context)) != null) {
                        }
                        this.currentPipeline = CurrentPipeline.dataPipeline;
                        return this.dataPipeline;
                    }
                    if (!t.getName().equals(PDF)) break;
                    Pipeline<FlattenerContext> p = this.pdfPipeline;
                    while ((p = p.init(context)) != null) {
                    }
                    this.currentPipeline = CurrentPipeline.pdfPipeline;
                    return this.pdfPipeline;
                }
            }
        }
        return null;
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag t, String text, ProcessObject po) {
        switch (this.currentPipeline) {
            case localePipeline: {
                return this.localePipeline;
            }
            case templatePipeline: {
                return this.templateBuilderPipeline;
            }
            case formPipeline: {
                return this.formBuilderPipeline;
            }
            case dataPipeline: {
                return this.dataPipeline;
            }
            case pdfPipeline: {
                return this.pdfPipeline;
            }
        }
        return null;
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) {
        if (this.xdpOpen) {
            switch (this.currentPipeline) {
                case localePipeline: {
                    if (t.getParent().getParent() == null && t.getParent().getName().equals(XDP)) {
                        this.currentPipeline = CurrentPipeline.none;
                    }
                    return this.localePipeline;
                }
                case formPipeline: {
                    if (t.getParent().getParent() == null && t.getParent().getName().equals(XDP)) {
                        this.currentPipeline = CurrentPipeline.none;
                    }
                    return this.formBuilderPipeline;
                }
                case templatePipeline: {
                    if (t.getParent().getParent() == null && t.getParent().getName().equals(XDP)) {
                        this.currentPipeline = CurrentPipeline.none;
                    }
                    return this.templateBuilderPipeline;
                }
                case dataPipeline: {
                    if (t.getParent().getParent() == null && t.getParent().getName().equals(XDP)) {
                        this.currentPipeline = CurrentPipeline.none;
                    }
                    return this.dataPipeline;
                }
                case pdfPipeline: {
                    if (t.getParent().getParent() == null && t.getParent().getName().equals(XDP)) {
                        this.currentPipeline = CurrentPipeline.none;
                    }
                    return this.pdfPipeline;
                }
            }
            if (t.getName().equals(XDP) && t.getParent() == null) {
                this.xdpOpen = false;
            }
        }
        return null;
    }

    private static enum CurrentPipeline {
        localePipeline,
        templatePipeline,
        formPipeline,
        dataPipeline,
        pdfPipeline,
        none;

    }
}

