/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.positioner;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.element.BreakConditions;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentArea;
import com.itextpdf.tool.xml.xtra.xfa.element.KeepConditions;
import com.itextpdf.tool.xml.xtra.xfa.element.PageArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.TrailerLeaderElement;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContainer;
import com.itextpdf.tool.xml.xtra.xfa.js.JsInstanceManager;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTree;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.js.ScriptString;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubformSetPositioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.PdfCanvasForInvisibleElements;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Scriptable;

public class SubFormPositioner
extends Positioner {
    protected static final JsContainer subformJsObject = new JsContainer("subform");
    public static final List<String> breakConditionNodes;
    private final List<XFARectangle> internalBoxes = new ArrayList<XFARectangle>();
    protected XFARectangle internalBBox;
    protected LinkedList<BreakConditions> breakBefore = new LinkedList();
    protected LinkedList<BreakConditions> breakAfter = new LinkedList();
    protected BreakConditions breakOverflow = null;
    protected List<PdfContentByte> canvases;
    protected List<SubFormPositioner> childUnnamedSubforms = new ArrayList<SubFormPositioner>();

    public SubFormPositioner(XFATemplateTag templateTag, DataTag dataTag, FlattenerContext flattenerContext, JsNode parent) {
        super(templateTag, dataTag, flattenerContext, parent);
        this.setPrototype((Scriptable)subformJsObject);
        String name = this.getName();
        if (!SubFormPositioner.hasProperty((Scriptable)this, (String)name)) {
            this.defineProperty(name, this);
        }
        this.isEmpty = !this.isBackgroundOrBorderExist();
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object searchResult;
        Object baseResult = super.get(name, start);
        if (this == start && baseResult == NOT_FOUND && (searchResult = this.resolveNameFromUnnamedSubformRecursively(name)) != null) {
            return searchResult;
        }
        return baseResult;
    }

    public Object resolveNameFromUnnamedSubformRecursively(String name) {
        if (this.has(name, (Scriptable)this)) {
            Object result = this.get(name, (Scriptable)this);
            if (result instanceof RhinoJsNodeList) {
                result = ((RhinoJsNodeList)((Object)result)).get(0);
            }
            return result instanceof Positioner || result instanceof JsInstanceManager ? result : null;
        }
        for (SubFormPositioner unnamedSubform : this.childUnnamedSubforms) {
            Object childResult = unnamedSubform.resolveNameFromUnnamedSubformRecursively(name);
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    public List<Object> resolveAllFromUnnamedSubformRecursively(String name) {
        ArrayList<Object> resolvedInstances = new ArrayList<Object>();
        if (this.has(name, (Scriptable)this)) {
            Object result = this.get(name, (Scriptable)this);
            if (result instanceof RhinoJsNodeList) {
                resolvedInstances.addAll((List)result);
            } else if ((result instanceof Positioner || result instanceof JsInstanceManager) && !result.equals(this)) {
                resolvedInstances.add(result);
            }
        }
        for (SubFormPositioner unnamedSubform : this.childUnnamedSubforms) {
            List<Object> childResult = unnamedSubform.resolveAllFromUnnamedSubformRecursively(name);
            if (childResult == null) continue;
            resolvedInstances.addAll(childResult);
        }
        return resolvedInstances;
    }

    @Override
    public void addChild(JsTree child) {
        super.addChild(child);
        if (child instanceof SubFormPositioner && ((SubFormPositioner)child).getTemplate().retrieveAttribute("name") == null) {
            this.childUnnamedSubforms.add((SubFormPositioner)child);
        }
    }

    @Override
    public String getClassName() {
        return "subform";
    }

    public Object getInstanceManager() {
        return this.parent != null ? this.parent.getInstanceManagerByTemplate(this.template) : new JsInstanceManager(this.template, this.parent, this.flattenerContext);
    }

    public JsInstanceManager getInstanceManagerByTemplate(XFATemplateTag templateTag) {
        return this.getInstanceManagerByTemplate((Tag)templateTag);
    }

    public Object getInstanceIndex() {
        int index = 0;
        Object instances = this.parent.getOwnProperty(this.getName());
        if (instances instanceof RhinoJsNodeList) {
            while ((long)index < ((RhinoJsNodeList)((Object)instances)).getLength() && ((RhinoJsNodeList)((Object)instances)).item(index) != this) {
                ++index;
            }
        }
        return index;
    }

    public void addInstance(boolean bind) {
        JsInstanceManager instanceManager;
        if (this.parent != null && (instanceManager = this.parent.getInstanceManagerByTemplate(this.template)) != null) {
            instanceManager.addInstance(bind);
        }
    }

    @Override
    protected void initLayout() {
        super.initLayout();
        this.createBreakConditions();
        Positioner previous = this.flattenerContext.getCurrentNode();
        this.flattenerContext.setCurrentNode(this);
        String layout = this.getLayout();
        boolean isHeadRow = false;
        boolean isFootRow = false;
        if ("row".equals(layout)) {
            if (this.role == PdfName.THEAD) {
                isHeadRow = true;
            } else if (this.role == PdfName.TFOOT) {
                isFootRow = true;
            }
        }
        int taggedChildrenNumber = 0;
        boolean childDiv = false;
        for (Positioner child : this.childElements) {
            if (child.isHidden() || child.isInactive()) continue;
            child.place();
            if (this.isEmpty) {
                this.isEmpty = child.isEmpty();
            }
            if (!this.isEmpty && child.isContentTagged()) {
                ++taggedChildrenNumber;
            } else if (taggedChildrenNumber < 2 && !child.isEmpty() && child.isContentTagged()) {
                ++taggedChildrenNumber;
            }
            if (isHeadRow && child.role != PdfName.TR) {
                this.role = PdfName.TR;
                child.role = PdfName.TH;
            }
            if (isFootRow && child.role != PdfName.TR) {
                this.role = PdfName.TR;
                isFootRow = false;
            }
            if (child.role == PdfName.DIV || child.role == PdfName.SECT) {
                childDiv = true;
            }
            this.addInternalBox(child.getBBox());
        }
        this.isContentTagged = taggedChildrenNumber > 0;
        boolean bl = this.isTagged = !(this instanceof SubformSetPositioner) && (this.role != PdfName.DIV && taggedChildrenNumber > 0 || taggedChildrenNumber > 1);
        if (this.isTagged && this.role == PdfName.DIV && childDiv) {
            this.role = PdfName.SECT;
        }
        this.flattenerContext.setCurrentNode(previous);
    }

    public void createBreakConditions() {
        for (String breakNodeClassName : breakConditionNodes) {
            String target;
            String type;
            FormNode breakNode = this.retrieveChild(breakNodeClassName);
            if (breakNode == null) continue;
            ScriptString scriptString = ScriptString.createScriptString(breakNode.retrieveChild("script"));
            Map<String, String> attributes = breakNode.retrieveAttributes();
            String startNew = attributes.get("startNew");
            Boolean startNewValue = false;
            if (startNew != null && startNew.equalsIgnoreCase("1")) {
                startNewValue = true;
            }
            if (breakNodeClassName.equalsIgnoreCase("break")) {
                type = attributes.get("before");
                target = attributes.get("beforeTarget");
                if (type != null || target != null) {
                    this.breakBefore.add(new BreakConditions("before", type, target, startNewValue, this, scriptString));
                }
                type = attributes.get("after");
                target = attributes.get("afterTarget");
                if (type != null || target != null) {
                    this.breakAfter.add(new BreakConditions("after", type, target, startNewValue, this, scriptString));
                }
                type = attributes.get("overflow");
                target = attributes.get("overflowTarget");
                if (type == null && target == null) continue;
                this.breakOverflow = new BreakConditions("overflow", type, target, false, this, scriptString);
                continue;
            }
            type = attributes.get("targetType");
            target = attributes.get("target");
            if (type == null && target == null) continue;
            if (breakNodeClassName.equalsIgnoreCase("breakBefore")) {
                this.breakBefore.add(new BreakConditions("before", type, target, startNewValue, this, scriptString));
                continue;
            }
            if (breakNodeClassName.equalsIgnoreCase("breakAfter")) {
                this.breakAfter.add(new BreakConditions("after", type, target, startNewValue, this, scriptString));
                continue;
            }
            this.breakOverflow = new BreakConditions("overflow", type, target, false, this, scriptString);
        }
    }

    @Override
    public Positioner checkOverflowing(XFARectangle parentBoundingBox, PageArea currentPageArea, boolean breakableStatus, float bottomMargin) {
        if (this.checkBreakBeforeCondition(currentPageArea)) {
            this.propagateBreakConditions();
            return this;
        }
        XFARectangle childPageBoundingBox = null;
        if (parentBoundingBox != null) {
            if (breakableStatus && !this.isCurrentPageContentAreaOverflowed(currentPageArea)) {
                Positioner nextBreakablePositioner;
                TrailerLeaderElement trailer;
                float contentAreaBottom = parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue();
                if (this.overflowConditions != null && (trailer = this.overflowConditions.getCurrentTrailer()) != null) {
                    if (trailer.getBoundingBox() == null) {
                        Positioner trailerPositioner = (Positioner)this.flattenerContext.getFormBuilder().buildSubForm(trailer.getFormTag(), null, null);
                        trailerPositioner.place(Float.valueOf(0.0f), Float.valueOf(0.0f));
                        trailer.setBoundingBox(trailerPositioner.getBBox());
                    }
                    if (trailer.getFormTag() != this.template) {
                        contentAreaBottom += trailer.getBoundingBox().getHeight().floatValue();
                    }
                }
                if ((nextBreakablePositioner = this.findNextBreakableElement()) == this) {
                    Positioner nextPositionerWithKeepPrevious;
                    if (!nextBreakablePositioner.isBreakable() && this.doesNotFitContentArea(bottomMargin, contentAreaBottom)) {
                        return this;
                    }
                    if (this.parent instanceof SubFormPositioner && this.isBreakable() && !this.doesNotFitContentArea(bottomMargin, contentAreaBottom) && (nextPositionerWithKeepPrevious = ((SubFormPositioner)this.parent).checkKeepPreviousForChildPositioner(this.parent.getChildren().indexOf(this) + 1)) != null && !nextPositionerWithKeepPrevious.isBreakable() && nextPositionerWithKeepPrevious instanceof SubFormPositioner && ((SubFormPositioner)nextPositionerWithKeepPrevious).doesNotFitContentArea(bottomMargin, contentAreaBottom)) {
                        ((SubFormPositioner)nextPositionerWithKeepPrevious).doesNotFitContentArea(bottomMargin, contentAreaBottom);
                        return this;
                    }
                } else {
                    if (nextBreakablePositioner instanceof SubFormPositioner && ((SubFormPositioner)nextBreakablePositioner).checkBreakBeforeCondition(currentPageArea)) {
                        return this.parent == this.flattenerContext.getDomPositioner() ? null : this;
                    }
                    Positioner overflowPositioner = nextBreakablePositioner.checkOverflowing(parentBoundingBox, currentPageArea, breakableStatus, 0.0f);
                    if (overflowPositioner != null) {
                        overflowPositioner.addOverflowedPageContentArea(currentPageArea);
                        return this;
                    }
                    return null;
                }
            }
            childPageBoundingBox = parentBoundingBox.clone();
            this.applyMargins(childPageBoundingBox);
            if (this.parent != null) {
                this.applyTransformationToRectangle(childPageBoundingBox, true);
            }
        }
        Iterator positionItr = this.childElements.iterator();
        BreakConditions breakAfter = null;
        while (positionItr.hasNext()) {
            Positioner p = (Positioner)positionItr.next();
            Positioner overflowPositioner = null;
            if (breakAfter != null && breakAfter.evaluate()) {
                overflowPositioner = p;
            } else if (!p.isVisible() && !p.isInvisible()) {
                positionItr.remove();
                if (p.isHidden() || p.isInactive() || !(p instanceof SubFormPositioner) || !((SubFormPositioner)p).checkBreakBeforeCondition(currentPageArea)) continue;
                overflowPositioner = p;
            } else if (childPageBoundingBox != null) {
                if (p instanceof SubFormPositioner) {
                    breakAfter = ((SubFormPositioner)p).getFirstBreakAfter();
                }
                overflowPositioner = p.checkOverflowing(childPageBoundingBox, currentPageArea, this.isBreakable(), 0.0f);
            }
            if (overflowPositioner != null) {
                if (p == overflowPositioner) {
                    overflowPositioner = this.findHighestNeighbour(p);
                    childPageBoundingBox.setHeight(Float.valueOf(childPageBoundingBox.getUry().floatValue() - overflowPositioner.getBBox().getUry().floatValue()));
                }
                if (this.parent != null) {
                    this.applyTransformationToRectangle(childPageBoundingBox);
                }
                parentBoundingBox.setUry(childPageBoundingBox.getUry());
                this.unapplyMargins(childPageBoundingBox);
                parentBoundingBox.setHeight(Float.valueOf(parentBoundingBox.getUry().floatValue() - childPageBoundingBox.getUry().floatValue() + childPageBoundingBox.getHeight().floatValue()));
                return overflowPositioner;
            }
            if (!p.isEmpty()) {
                return null;
            }
            positionItr.remove();
            if (this.flattenerContext.getDomPositioner() != this || !"lr-tb".equals(this.getLayout())) continue;
            XFARectangle rect = p.contentArea.clone();
            p.unapplyMargins(rect);
            this.move(-rect.getWidth().floatValue(), 0.0f);
        }
        this.isEmpty = !this.isBackgroundOrBorderExist();
        return null;
    }

    private Positioner checkKeepPreviousForChildPositioner(int startFrom) {
        int numberOfChildren = this.getChildren().size();
        for (int childInd = startFrom; childInd < numberOfChildren; ++childInd) {
            Positioner childPositioner = this.getChildren().get(childInd);
            if (childPositioner.isHidden() || childPositioner.isInactive()) continue;
            KeepConditions nextKeepConditions = childPositioner.getKeepConditions();
            if (nextKeepConditions != null && !"none".equals(nextKeepConditions.getPrevious())) {
                return childPositioner;
            }
            if (childPositioner instanceof SubFormPositioner) {
                return ((SubFormPositioner)childPositioner).checkKeepPreviousForChildPositioner(0);
            }
            return null;
        }
        if (this.parent instanceof SubFormPositioner) {
            return ((SubFormPositioner)this.parent).checkKeepPreviousForChildPositioner(this.parent.getChildren().indexOf(this) + 1);
        }
        return null;
    }

    private void propagateBreakConditions() {
        this.breakConditions = null;
        if (this.breakBefore != null && !this.breakBefore.isEmpty()) {
            this.breakConditions = this.breakBefore.removeFirst();
        }
    }

    @Override
    public Positioner position(PdfContentByte parentCanvas, XFARectangle parentBoundingBox, PageArea currentPageArea, boolean breakableStatus, float bottomMargin) throws DocumentException, IOException {
        Positioner overflowPositioner;
        if (this.isInvisible() && !(parentCanvas instanceof PdfCanvasForInvisibleElements)) {
            parentCanvas = new PdfCanvasForInvisibleElements(this.flattenerContext);
        }
        if ((overflowPositioner = this.checkOverflowing(parentBoundingBox, currentPageArea, breakableStatus, bottomMargin)) != null) {
            overflowPositioner.addOverflowedPageContentArea(currentPageArea);
            return overflowPositioner;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.flattenerContext.setCurrentNode(this);
        if (!this.childElements.isEmpty()) {
            this.savePosState(parentCanvas);
            String layout = this.getLayout();
            PdfContentByte currentCanvas = null;
            Comparator<Positioner> comparator = null;
            if ("position".equals(layout)) {
                comparator = new Positioner.PositionedLayoutComparator(this);
            } else if ("row".equals(layout)) {
                comparator = new Positioner.RowLayoutComparator(this);
            }
            if (comparator != null) {
                if (this.canvases == null) {
                    this.canvases = new ArrayList<PdfContentByte>();
                    this.populateCanvases(parentCanvas);
                    if (this.flattenerContext.getDomPositioner() != this) {
                        Collections.sort(this.childElements, comparator);
                    }
                    if ("position".equals(layout)) {
                        this.sortPositionLayout(this.childElements, comparator);
                    }
                } else {
                    Iterator<PdfContentByte> canvasItr = this.canvases.iterator();
                    while (canvasItr.hasNext()) {
                        canvasItr.next().inheritGraphicState(parentCanvas);
                    }
                }
            } else {
                currentCanvas = this.isBackgroundOrBorderExist() ? parentCanvas.getDuplicate(true) : parentCanvas;
            }
            XFARectangle childPageBoundingBox = null;
            XFARectangle originalPageBoundingBox = null;
            if (parentBoundingBox != null) {
                childPageBoundingBox = parentBoundingBox.clone();
                originalPageBoundingBox = parentBoundingBox.clone();
                this.applyMargins(childPageBoundingBox);
                if (this.parent != null) {
                    this.applyTransformationToRectangle(childPageBoundingBox, true);
                }
            }
            BreakConditions breakAfter = null;
            HashSet<PdfContentByte> overflowCanvas = new HashSet<PdfContentByte>();
            Iterator positionItr = this.childElements.iterator();
            ArrayList<Positioner> fullContentPositioned = new ArrayList<Positioner>();
            while (positionItr.hasNext()) {
                Positioner p = (Positioner)positionItr.next();
                if (breakAfter != null && this.checkBreakBeforeCondition(breakAfter, currentPageArea) && !p.isHidden()) {
                    overflowPositioner = p;
                    overflowPositioner.setBreakConditions(breakAfter);
                    overflowPositioner.addOverflowedPageContentArea(currentPageArea);
                    break;
                }
                if (!p.isVisible() && !p.isInvisible()) {
                    positionItr.remove();
                    if (p.isHidden() || p.isInactive() || !(p instanceof SubFormPositioner) || !((SubFormPositioner)p).checkBreakBeforeCondition(currentPageArea)) continue;
                    overflowPositioner = p;
                    ((SubFormPositioner)p).propagateBreakConditions();
                } else {
                    PdfContentByte canvas;
                    PdfContentByte pdfContentByte = canvas = currentCanvas != null ? currentCanvas : p.canvas;
                    if (canvas == null) {
                        canvas = parentCanvas;
                    }
                    overflowPositioner = p.position(canvas, childPageBoundingBox, currentPageArea, this.isBreakable(), this.childElements.get(this.childElements.size() - 1) == p ? this.getBottomInset() + bottomMargin : 0.0f);
                }
                if (overflowPositioner != null) {
                    if (this.flattenerContext.getDomPositioner() == this && "lr-tb".equals(this.getLayout()) && p == overflowPositioner) {
                        XFARectangle rect = p.contentArea.clone();
                        p.unapplyMargins(rect);
                        this.move(-rect.getLlx().floatValue(), 0.0f);
                    }
                    float highestOverflowUry = overflowPositioner.getBBox().getUry().floatValue();
                    Positioner lowestOverflowPositioner = null;
                    if (p == overflowPositioner && overflowPositioner.positionState == PositionResult.State.NO_CONTENT) {
                        lowestOverflowPositioner = overflowPositioner;
                    }
                    overflowCanvas.add(p.canvas);
                    while (positionItr.hasNext()) {
                        float childUry;
                        p = (Positioner)positionItr.next();
                        if (!p.isVisible() && !p.isInvisible() || !XFAUtil.lt(highestOverflowUry, childUry = p.getBBox().getUry().floatValue()) || this == this.flattenerContext.getDomPositioner()) continue;
                        XFARectangle childPageBoundingBoxClone = childPageBoundingBox.clone();
                        Positioner nextOverflowPositioner = p.position(currentCanvas != null ? currentCanvas : p.canvas, childPageBoundingBoxClone, currentPageArea, this.isBreakable(), 0.0f);
                        float lly = Math.min(childPageBoundingBox.getUry().floatValue() - childPageBoundingBox.getHeight().floatValue(), childPageBoundingBoxClone.getUry().floatValue() - childPageBoundingBoxClone.getHeight().floatValue());
                        childPageBoundingBox.setHeight(Float.valueOf(childPageBoundingBox.getUry().floatValue() - lly));
                        if (nextOverflowPositioner != null) {
                            childUry = nextOverflowPositioner.getBBox().getUry().floatValue();
                            if (XFAUtil.lt(highestOverflowUry, childUry)) {
                                if (overflowPositioner.positionState == PositionResult.State.CONTENT_PART && nextOverflowPositioner.positionState == PositionResult.State.FULL_CONTENT) {
                                    nextOverflowPositioner.adjustContentAreaUry(highestOverflowUry);
                                } else {
                                    highestOverflowUry = childUry;
                                    if (overflowPositioner.positionState == PositionResult.State.FULL_CONTENT) {
                                        overflowPositioner.adjustContentAreaUry(highestOverflowUry);
                                    }
                                    overflowPositioner = nextOverflowPositioner;
                                }
                            } else {
                                if (overflowPositioner.positionState == PositionResult.State.FULL_CONTENT) {
                                    overflowPositioner.adjustContentAreaUry(childUry);
                                    highestOverflowUry = childUry;
                                } else {
                                    nextOverflowPositioner.adjustContentAreaUry(highestOverflowUry);
                                }
                                if (nextOverflowPositioner == p && nextOverflowPositioner.positionState == PositionResult.State.NO_CONTENT) {
                                    lowestOverflowPositioner = p;
                                }
                            }
                            if (p.canvas == null) continue;
                            overflowCanvas.add(p.canvas);
                            continue;
                        }
                        XFARectangle bbox = p.getBBox();
                        if (childPageBoundingBox != null && XFAUtil.lt(bbox.getUry().floatValue() - bbox.getHeight().floatValue(), childPageBoundingBox.getUry().floatValue() - childPageBoundingBox.getHeight().floatValue())) {
                            fullContentPositioned.add(p);
                        } else {
                            positionItr.remove();
                        }
                        if (p.canvas == null) continue;
                        overflowCanvas.add(p.canvas);
                    }
                    for (Positioner positioner : fullContentPositioned) {
                        positioner.adjustContentAreaUry(highestOverflowUry);
                    }
                    if (lowestOverflowPositioner != null) {
                        childPageBoundingBox.setHeight(Float.valueOf(childPageBoundingBox.getUry().floatValue() - lowestOverflowPositioner.getBBox().getUry().floatValue()));
                    }
                    if (this.parent != null) {
                        this.applyTransformationToRectangle(childPageBoundingBox);
                    }
                    parentBoundingBox.setUry(childPageBoundingBox.getUry());
                    this.unapplyMargins(childPageBoundingBox);
                    parentBoundingBox.setHeight(Float.valueOf(parentBoundingBox.getUry().floatValue() - childPageBoundingBox.getUry().floatValue() + childPageBoundingBox.getHeight().floatValue()));
                    this.updateOverflowedBreakCondition(overflowPositioner);
                    if (breakAfter == null || overflowPositioner.getBreakConditions() != null) break;
                    overflowPositioner.setBreakConditions(breakAfter);
                    break;
                }
                BreakConditions currentBreakConditions = null;
                if (p instanceof SubFormPositioner && ((SubFormPositioner)p).getFirstBreakAfter() != null && ((SubFormPositioner)p).getFirstBreakAfter().evaluate()) {
                    breakAfter = currentBreakConditions = ((SubFormPositioner)p).getFirstBreakAfter();
                }
                XFARectangle bbox = p.getBBox();
                if (childPageBoundingBox != null && XFAUtil.lt(bbox.getUry().floatValue() - bbox.getHeight().floatValue(), childPageBoundingBox.getUry().floatValue() - childPageBoundingBox.getHeight().floatValue())) {
                    fullContentPositioned.add(p);
                    if (p.canvas == null) continue;
                    overflowCanvas.add(p.canvas);
                    continue;
                }
                positionItr.remove();
                if (!(p instanceof SubFormPositioner) || positionItr.hasNext() || currentBreakConditions == null) continue;
                ((SubFormPositioner)p).breakAfter.removeFirst();
                this.breakAfter.addFirst(new BreakConditions(currentBreakConditions, this));
            }
            fullContentPositioned.clear();
            if (originalPageBoundingBox != null) {
                originalPageBoundingBox.setHeight(Float.valueOf(originalPageBoundingBox.getUry().floatValue() - parentBoundingBox.getUry().floatValue() + parentBoundingBox.getHeight().floatValue()));
            }
            if (this.overflowConditions != null && this.overflowConditions.getCurrentTrailer() != null && this.overflowConditions.getCurrentTrailer().getBoundingBox() != null) {
                originalPageBoundingBox.setHeight(Float.valueOf(originalPageBoundingBox.getHeight().floatValue() + this.overflowConditions.getCurrentTrailer().getBoundingBox().getHeight().floatValue()));
            }
            this.restorePosState(parentCanvas);
            this.drawBorder(parentCanvas, originalPageBoundingBox);
            this.savePosState(parentCanvas);
            if (currentCanvas == null) {
                Iterator<PdfContentByte> canvasItr = this.canvases.iterator();
                while (canvasItr.hasNext()) {
                    currentCanvas = canvasItr.next();
                    if (currentCanvas.getInternalBuffer().size() <= 0) continue;
                    parentCanvas.add(currentCanvas);
                    currentCanvas.reset(false);
                    if (overflowPositioner == null || overflowCanvas.contains(currentCanvas)) continue;
                    canvasItr.remove();
                }
                if (overflowPositioner == null) {
                    this.canvases.clear();
                    this.canvases = null;
                    this.canvas = null;
                }
            } else if (this.isBackgroundOrBorderExist()) {
                parentCanvas.add(currentCanvas);
            }
            this.restorePosState(parentCanvas);
        } else if (this.isBackgroundOrBorderExist()) {
            this.drawBorder(parentCanvas, parentBoundingBox);
        }
        this.flattenerContext.setCurrentNode(this.parent);
        this.positionState = overflowPositioner != null ? PositionResult.State.CONTENT_PART : PositionResult.State.FULL_CONTENT;
        this.updatePageNumbers();
        return overflowPositioner;
    }

    private boolean nonBreakablePositionerBBoxContains(Positioner a, Positioner b) {
        return a.contentArea != null && b.contentArea != null && a.contentArea.contains(b.contentArea);
    }

    private void sortPositionLayout(List<Positioner> childElements, Comparator comparator) {
        ArrayList<Positioner> result = new ArrayList<Positioner>();
        boolean[] used = new boolean[childElements.size()];
        for (int i = 0; i < childElements.size(); ++i) {
            if (used[i]) continue;
            Positioner p = childElements.get(i);
            for (int j = i + 1; j < childElements.size(); ++j) {
                if (used[j] || childElements.get(j).isBreakable() || !this.nonBreakablePositionerBBoxContains(childElements.get(j), p)) continue;
                result.add(childElements.get(j));
                used[j] = true;
            }
            result.add(childElements.get(i));
            used[i] = true;
        }
        childElements.clear();
        childElements.addAll(result);
    }

    protected void populateCanvases(PdfContentByte parentCanvas) {
        for (Positioner p : this.childElements) {
            if (!p.isVisible() && !p.isInvisible() || p.canvas != null) continue;
            p.canvas = parentCanvas.getDuplicate(true);
            this.canvases.add(p.canvas);
        }
    }

    protected void addInternalBox(XFARectangle internalBox) {
        this.internalBoxes.add(internalBox);
    }

    @Override
    protected void adjustContentArea() {
        String layout;
        float finalWidth = this.getLargestUrx().floatValue() - this.contentArea.getLlx().floatValue();
        Float minW = this.contentArea.getMinW();
        if (minW != null && finalWidth < minW.floatValue()) {
            finalWidth = minW.floatValue();
        }
        if (this.contentArea.getWidth() == null) {
            this.contentArea.setWidth(Float.valueOf(finalWidth));
        }
        if ("row".equals(layout = this.getLayout())) {
            float maxHeight = this.getMaxBoxHeight();
            this.adjustContentAreaHeight(maxHeight);
        } else if ("tb".equals(layout) || "lr-tb".equals(layout) || this.contentArea.getHeight() == null) {
            float finalHeight = this.contentArea.getUry().floatValue() - this.getLowestLly().floatValue();
            if (this.contentArea.getHeight() == null || finalHeight > this.contentArea.getHeight().floatValue()) {
                this.contentArea.setHeight(Float.valueOf(finalHeight));
            }
        }
    }

    @Override
    protected void adjustContentAreaHeight(float newHeight) {
        super.adjustContentAreaHeight(newHeight);
        String layout = this.getLayout();
        if ("row".equals(layout)) {
            for (Positioner p : this.childElements) {
                if (p.isHidden() || p.isInactive()) continue;
                p.adjustContentAreaHeight(newHeight);
            }
        }
    }

    @Override
    public void relayout(boolean forceLayout) {
        boolean relayout;
        boolean bl = relayout = this.layoutOutOfDate || forceLayout;
        if (relayout) {
            this.internalBoxes.clear();
            this.transformation = new AffineTransform();
            this.initContentArea(null, null);
            this.applyMargins(this.contentArea);
        }
        boolean isChildOutOfDate = false;
        for (Positioner p : this.childElements) {
            if (p.isHidden() || p.isInactive()) continue;
            isChildOutOfDate = isChildOutOfDate || p.isLayoutOutOfDate();
            p.relayout(relayout);
            if (!relayout) continue;
            this.addInternalBox(p.getBBox());
        }
        if (relayout) {
            if (this.isEmpty) {
                for (Positioner child : this.childElements) {
                    if (child.isHidden() || child.isInactive() || child.isEmpty()) continue;
                    this.isEmpty = false;
                    break;
                }
            }
            this.adjustLayout();
        } else if (isChildOutOfDate && "row".equals(this.getLayout())) {
            this.adjustContentArea();
        }
        this.layoutOutOfDate = false;
    }

    protected void applyAlignment() {
        Tag globalParaTag = this.template.getChild("para", "", false);
        for (int ind = 0; ind < this.childElements.size(); ++ind) {
            boolean verRelativeLayout;
            Tag paraTag;
            Positioner child = (Positioner)this.childElements.get(ind);
            if (child.isHidden() || child.isInactive()) continue;
            Tag tag = paraTag = globalParaTag != null ? globalParaTag : child.getTemplate();
            if (paraTag == null) continue;
            Map<String, String> attributes = paraTag.getAttributes();
            String layout = this.getLayout();
            boolean horRelativeLayout = "lr-tb".equals(layout) || "tb".equals(layout) || "row".equals(layout);
            boolean bl = verRelativeLayout = "tb".equals(layout) || "lr-tb".equals(layout);
            if (this.contentArea.getHeight() != null && child.contentArea.getHeight() != null && verRelativeLayout) {
                String vAlign = attributes.get("vAlign");
                if (vAlign == null && paraTag != child.getTemplate()) {
                    vAlign = child.getTemplate().getAttributes().get("vAlign");
                }
                if ("middle".equals(vAlign)) {
                    this.initInternalBBox();
                    child.applyTranslation(0.0f, -(this.contentArea.getHeight().floatValue() - this.internalBBox.getHeight().floatValue()) / 2.0f);
                } else if ("bottom".equals(vAlign)) {
                    this.initInternalBBox();
                    child.applyTranslation(0.0f, -(this.contentArea.getHeight().floatValue() - this.internalBBox.getHeight().floatValue()));
                }
            }
            if (this.contentArea.getWidth() == null || child.contentArea.getWidth() == null || !horRelativeLayout) continue;
            String hAlign = attributes.get("hAlign");
            if (hAlign == null && paraTag != child.getTemplate()) {
                hAlign = child.getTemplate().getAttributes().get("hAlign");
            }
            if ("center".equals(hAlign)) {
                this.initInternalBBox();
                child.applyTranslation((this.contentArea.getWidth().floatValue() - this.internalBBox.getWidth().floatValue()) / 2.0f, 0.0f);
                continue;
            }
            if (!"right".equals(hAlign)) continue;
            if ("tb".equals(this.getLayout())) {
                child.applyTranslation(this.contentArea.getWidth().floatValue() - child.getBBox().getWidth().floatValue(), 0.0f);
                continue;
            }
            if ("lr-tb".equals(this.getLayout())) {
                float totalWidth = 0.0f;
                XFARectangle childBBox = child.getBBox();
                XFARectangle bBox = this.getBBox();
                ArrayList<Positioner> toTranslate = new ArrayList<Positioner>();
                float childRelativeX = childBBox.getLlx().floatValue() - bBox.getLlx().floatValue();
                for (int i = ind; i < this.childElements.size(); ++i) {
                    Positioner nextChild = (Positioner)this.childElements.get(i);
                    if (nextChild.contentArea == null || nextChild.isHidden() || nextChild.isInactive()) continue;
                    XFARectangle nextChildBBox = nextChild.getBBox();
                    if ((double)(childRelativeX + totalWidth + nextChildBBox.getWidth().floatValue()) > (double)bBox.getWidth().floatValue() + 0.001) break;
                    totalWidth += nextChildBBox.getWidth().floatValue();
                    toTranslate.add(nextChild);
                }
                float translateX = bBox.getWidth().floatValue() - childRelativeX - totalWidth;
                if (toTranslate.size() > 0) {
                    for (Positioner nextChild : toTranslate) {
                        nextChild.applyTranslation(translateX, 0.0f);
                    }
                    continue;
                }
                this.initInternalBBox();
                child.applyTranslation(this.contentArea.getWidth().floatValue() - this.internalBBox.getWidth().floatValue(), 0.0f);
                continue;
            }
            this.initInternalBBox();
            child.applyTranslation(this.contentArea.getWidth().floatValue() - this.internalBBox.getWidth().floatValue(), 0.0f);
        }
    }

    public BreakConditions getFirstBreakAfter() {
        return this.breakAfter != null && this.breakAfter.size() > 0 ? this.breakAfter.getFirst() : null;
    }

    public BreakConditions getBreakOverflow() {
        return this.breakOverflow;
    }

    public void setBreakOverflow(BreakConditions breakOverflow) {
        this.breakOverflow = breakOverflow;
    }

    private Float getLargestUrx() {
        Float largestUrx = null;
        Float width = this.contentArea.getWidth();
        if (width != null) {
            largestUrx = Float.valueOf(this.contentArea.getLlx().floatValue() + width.floatValue());
        }
        for (XFARectangle box : this.internalBoxes) {
            Float boxWidth = box.getWidth();
            if (boxWidth == null) continue;
            float urx = box.getLlx().floatValue() + boxWidth.floatValue();
            if (largestUrx == null) {
                largestUrx = Float.valueOf(urx);
                continue;
            }
            if (!(urx > largestUrx.floatValue())) continue;
            largestUrx = Float.valueOf(urx);
        }
        if (largestUrx == null) {
            largestUrx = this.contentArea.getLlx();
        }
        return largestUrx;
    }

    private Float getLowestLly() {
        Float lowestLly = null;
        Float height = this.contentArea.getHeight();
        if (height != null) {
            lowestLly = Float.valueOf(this.contentArea.getUry().floatValue() - height.floatValue());
        }
        for (XFARectangle box : this.internalBoxes) {
            Float boxHeight = box.getHeight();
            if (boxHeight == null) continue;
            float lly = box.getUry().floatValue() - boxHeight.floatValue();
            if (lowestLly == null) {
                lowestLly = Float.valueOf(lly);
                continue;
            }
            if (!(lly < lowestLly.floatValue())) continue;
            lowestLly = Float.valueOf(lly);
        }
        if (lowestLly == null) {
            lowestLly = this.contentArea.getUry();
        }
        return lowestLly;
    }

    private float getMaxBoxHeight() {
        float maxHeight = 0.0f;
        if (this.internalBoxes != null) {
            for (XFARectangle box : this.internalBoxes) {
                if (!(box.getHeight().floatValue() > maxHeight)) continue;
                maxHeight = box.getHeight().floatValue();
            }
        }
        return maxHeight;
    }

    public boolean checkBreakBeforeCondition(PageArea currentPageArea) {
        if (this.breakBefore != null && !this.breakBefore.isEmpty()) {
            if (!this.checkBreakBeforeCondition(this.breakBefore.getFirst(), currentPageArea)) {
                this.setBreakConditions(this.breakBefore.getFirst());
                this.breakBefore.removeFirst();
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkBreakBeforeCondition(BreakConditions breakCondition, PageArea currentPageArea) {
        if (breakCondition == null || !breakCondition.evaluate()) return false;
        if (breakCondition.getStartNew()) {
            if (breakCondition.getTarget() != null && this.flattenerContext.getPageSet().searchNode(breakCondition.getTarget(), false) == null) return false;
            return true;
        }
        if (currentPageArea == null) return false;
        String type = breakCondition.getType();
        String target = breakCondition.getTarget();
        if (type != null && target != null) {
            JsTree targetContentArea;
            String id;
            if (type.equalsIgnoreCase("pageArea")) {
                JsTree targetPageArea;
                String id2;
                if (!(target.startsWith("#") ? (id2 = currentPageArea.getTemplateId()) == null || !target.equalsIgnoreCase("#" + id2) : (targetPageArea = this.flattenerContext.getPageSet().searchNodeDown(target)) instanceof PageArea && ((PageArea)targetPageArea).getTemplate() != currentPageArea.getTemplate())) return false;
                return true;
            }
            if (!type.equalsIgnoreCase("contentArea")) return false;
            ContentArea contentArea = currentPageArea.getCurrentContentArea();
            if (contentArea == null) return true;
            if (!(target.startsWith("#") ? (id = contentArea.getId()) == null || !target.equalsIgnoreCase("#" + id) : (targetContentArea = this.flattenerContext.getPageSet().searchNodeDown(target)) instanceof ContentArea && ((ContentArea)targetContentArea).getTemplate() != contentArea.getTemplate())) return false;
            return true;
        }
        if (type == null) return false;
        return true;
    }

    private Positioner findHighestNeighbour(Positioner breakedPositioner) {
        float ytr = breakedPositioner.getBBox().getUry().floatValue();
        for (int childIndex = this.childElements.indexOf(breakedPositioner) + 1; childIndex < this.childElements.size(); ++childIndex) {
            float childUry;
            Positioner nextChild = (Positioner)this.childElements.get(childIndex);
            if (nextChild.isHidden() || nextChild.isInactive() || !XFAUtil.lt(ytr, childUry = nextChild.getBBox().getUry().floatValue())) continue;
            ytr = childUry;
            breakedPositioner = nextChild;
        }
        return breakedPositioner;
    }

    @Override
    public boolean isBreakable() {
        String layout = this.getLayout();
        if (this.keepConditions == null) {
            if (!"position".equals(layout) && !"row".equals(layout)) {
                if (("tb".equals(layout) || "lr-tb".equals(layout)) && this.parent != null && this.parent.getParent() != null) {
                    layout = this.parent.getLayout();
                    return !"position".equals(layout);
                }
                return true;
            }
            return this.parent == null;
        }
        return this.keepConditions.getIntact().equals("none");
    }

    private void updateOverflowedBreakCondition(Positioner overflowPositioner) {
        if (overflowPositioner.getBreakConditions() == null) {
            overflowPositioner.setBreakConditions(this.getBreakOverflow());
        } else if (this.getBreakOverflow() != null && overflowPositioner.getBreakConditions().getTarget() == null) {
            overflowPositioner.getBreakConditions().setTarget(this.getBreakOverflow().getTarget());
        }
    }

    private void initInternalBBox() {
        if (this.internalBBox == null) {
            this.internalBBox = XFARectangle.getCommonRectangle(this.internalBoxes);
        }
    }

    @Override
    public boolean supportLegacyPlusPrint() {
        return true;
    }

    static {
        subformJsObject.defineProperty("instanceManager", SubFormPositioner.class, 1);
        subformJsObject.defineProperty("instanceIndex", SubFormPositioner.class, 1);
        subformJsObject.defineFunctionProperties(new String[]{"addInstance"}, SubFormPositioner.class, 1);
        breakConditionNodes = Arrays.asList("break", "overflow", "breakAfter", "breakBefore");
    }
}

