/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.resolver;

import com.itextpdf.tool.xml.xtra.xfa.XFALocale;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.DateFormatter;

public class FormatResolver {
    public static final String[] CANONICAL_DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyyMMdd", "yyyyMM", "yyyy"};
    public static final String[] CANONICAL_TIME_PATTERNS = new String[]{"HH:mm:ss.SSS", "HH:mm:ssZ", "HH:mm"};
    private FlattenerContext flattenerContext;

    public FormatResolver(FlattenerContext flattenerContext) {
        this.flattenerContext = flattenerContext;
    }

    public String resolve(Object data, String pattern, String inputParsingPattern, FormatType type, String localeName, Map<String, String> attributes) {
        String[] alternatePatterns;
        StringBuilder normalizedStringPattern;
        XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale(localeName);
        boolean originalPatternNotDefined = false;
        if (pattern == null) {
            originalPatternNotDefined = true;
            if (type == FormatType.FLOAT) {
                pattern = xfaLocale.getNumberPattern().get("numeric");
            } else if (type == FormatType.INTEGER) {
                pattern = xfaLocale.getNumberPattern().get("numeric");
                if (pattern != null && pattern.contains(".")) {
                    pattern = pattern.substring(0, pattern.indexOf("."));
                }
            } else if (type == FormatType.DATE) {
                pattern = xfaLocale.getDatePattern().get("med");
            } else if (type == FormatType.DATE_TIME) {
                String timePattern = String.format("time{%s}", xfaLocale.getTimePattern().get("med"));
                String datePattern = String.format("date{%s}", xfaLocale.getDatePattern().get("med"));
                pattern = String.format("%s %s", datePattern, timePattern);
            }
        } else if (attributes != null) {
            attributes.remove("fracDigits");
        }
        if (pattern == null || pattern.isEmpty()) {
            if (data instanceof Number) {
                try {
                    DecimalFormat df = new DecimalFormat();
                    df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
                    return df.format(data);
                }
                catch (Exception e) {
                    return data.toString();
                }
            }
            return data != null ? data.toString() : null;
        }
        if (type == FormatType.DATE_TIME) {
            type = null;
        }
        if (inputParsingPattern != null && (inputParsingPattern.contains("|") || inputParsingPattern.contains("null") || inputParsingPattern.contains("zero"))) {
            inputParsingPattern = null;
        }
        if (inputParsingPattern != null && inputParsingPattern.matches("((num)|(date)|(time)|(text))\\.?\\w*\\{.*\\}") && this.normalizeCategorizedPattern(inputParsingPattern, normalizedStringPattern = new StringBuilder(), xfaLocale) != null) {
            inputParsingPattern = normalizedStringPattern.toString();
        }
        String[] stringArray = alternatePatterns = pattern.split("\\|");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            StringBuilder formattedText = new StringBuilder();
            String alternatePattern = stringArray[i];
            if (!this.format(data, inputParsingPattern, formattedText, alternatePattern, type, xfaLocale, attributes)) continue;
            return formattedText.toString();
        }
        if (data != null && !originalPatternNotDefined) {
            return this.resolve(data, null, inputParsingPattern, type, localeName, attributes);
        }
        return data != null ? data.toString() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean format(Object data, String inputParsingPattern, StringBuilder formattedText, String pattern, FormatType type, XFALocale xfaLocale, Map<String, String> attributes) {
        String currentFormattedValue;
        String subPattern;
        Pattern regExPattern = Pattern.compile("((num)|(date)|(time)|(text)|(null)|(zero))(\\(\\w+\\))?\\.?\\w*\\{.*?\\}");
        pattern = pattern.replaceAll("datetime\\.([a-z]*)\\{\\}", "date.$1{} time.$1{}").trim();
        Matcher matcher = regExPattern.matcher(pattern);
        boolean failedToFormatData = false;
        int index = 0;
        while (matcher.find()) {
            String currentFormattedValue2;
            FormatType category;
            if (index != matcher.start()) {
                subPattern = pattern.substring(index, matcher.start());
                currentFormattedValue = this.simpleFormat(data, inputParsingPattern, subPattern, type, xfaLocale, attributes);
                if (currentFormattedValue != null) {
                    formattedText.append(currentFormattedValue);
                } else {
                    failedToFormatData = true;
                }
            }
            String categorisedPattern = pattern.substring(matcher.start(), matcher.end());
            StringBuilder normalizeCategorisedPattern = new StringBuilder();
            XFALocale categorisedPatternLocale = null;
            if (categorisedPattern.matches("((num)|(date)|(time)|(text)|(null)|(zero))(\\(\\w+\\)).*")) {
                String localeName = categorisedPattern.replaceAll("((num)|(date)|(time)|(text)|(null)|(zero))\\(", "");
                localeName = localeName.substring(0, localeName.indexOf(")"));
                categorisedPatternLocale = this.flattenerContext.getLocaleResolver().getLocale(localeName);
            }
            if ((category = this.normalizeCategorizedPattern(categorisedPattern, normalizeCategorisedPattern, categorisedPatternLocale == null ? xfaLocale : categorisedPatternLocale)) != null) {
                categorisedPattern = normalizeCategorisedPattern.toString();
            } else if (categorisedPattern.contains("null")) {
                if (data != null) {
                    if (!(data instanceof String)) return false;
                    if (!((String)data).isEmpty()) return false;
                }
                category = FormatType.FLOAT;
                categorisedPattern = normalizeCategorisedPattern.toString();
                if (categorisedPattern.isEmpty()) {
                    return true;
                }
                data = categorisedPattern;
            } else if (categorisedPattern.contains("zero")) {
                Number value;
                if (data == null) return false;
                if (!(data instanceof Number)) {
                    if (!(data instanceof CharSequence)) return false;
                    if (((CharSequence)data).length() == 0) return false;
                }
                if (data instanceof Number) {
                    value = (Number)data;
                } else {
                    NumberParseResult numberParseResult = this.parseNumber(data.toString(), inputParsingPattern, categorisedPatternLocale == null ? xfaLocale : categorisedPatternLocale, false);
                    if (numberParseResult == null) return false;
                    Number number = numberParseResult.getNumber();
                    value = number;
                }
                if (value == null) return false;
                if (value.doubleValue() != 0.0) return false;
                category = FormatType.FLOAT;
                categorisedPattern = normalizeCategorisedPattern.toString();
                if (categorisedPattern.isEmpty()) {
                    return true;
                }
            }
            if (data == null) {
                data = "";
            }
            if ((currentFormattedValue2 = this.simpleFormat(data, inputParsingPattern, categorisedPattern, category, categorisedPatternLocale == null ? xfaLocale : categorisedPatternLocale, attributes)) != null) {
                formattedText.append(currentFormattedValue2);
            } else {
                failedToFormatData = true;
            }
            index = matcher.end();
        }
        if (index < pattern.length()) {
            subPattern = pattern.substring(index, pattern.length());
            currentFormattedValue = this.simpleFormat(data, inputParsingPattern, subPattern, type, xfaLocale, attributes);
            if (currentFormattedValue != null) {
                formattedText.append(currentFormattedValue);
            } else {
                failedToFormatData = true;
            }
        }
        if (!failedToFormatData) return true;
        formattedText.setLength(0);
        return false;
    }

    private String simpleFormat(Object data, String inputParsingPattern, String pattern, FormatType type, XFALocale xfaLocale, Map<String, String> attributes) {
        try {
            String[] patterns = pattern.split("[']");
            String formattedData = "";
            boolean isPattern = true;
            String text = null;
            for (int i = 0; i < patterns.length; ++i) {
                Date dateValue;
                if (!isPattern) {
                    formattedData = formattedData + patterns[i];
                    isPattern = true;
                    continue;
                }
                isPattern = false;
                String currentPattern = patterns[i];
                if (currentPattern.isEmpty()) continue;
                if ((type == FormatType.TEXT || type == null) && currentPattern.matches("[A|0|O|X|9|\\?|\\*|\\+|\\s|\\-|,|:|\\.]*")) {
                    StringBuffer textBuffer;
                    String formattedText;
                    if (text == null) {
                        text = data.toString();
                    }
                    if ((formattedText = this.formatText(textBuffer = new StringBuffer(text), currentPattern)) == null) {
                        return null;
                    }
                    formattedData = formattedData + formattedText;
                    text = textBuffer.toString();
                    continue;
                }
                if ((type == FormatType.DATE || type == null) && (dateValue = this.parseDate(data.toString(), inputParsingPattern, xfaLocale)) != null) {
                    if (text != null) {
                        if (text.length() > 0) {
                            return null;
                        }
                        text = null;
                    }
                    formattedData = formattedData + this.formatDate(dateValue, currentPattern, xfaLocale);
                    continue;
                }
                if ((type == FormatType.TIME || type == null) && (dateValue = this.parseTime(data.toString(), inputParsingPattern, xfaLocale)) != null) {
                    if (text != null) {
                        if (text.length() > 0) {
                            return null;
                        }
                        text = null;
                    }
                    formattedData = formattedData + this.formatTime(dateValue, currentPattern, xfaLocale);
                    continue;
                }
                if (type == FormatType.FLOAT || type == FormatType.INTEGER) {
                    Number numberValue;
                    if (text != null) {
                        if (text.length() > 0) {
                            return null;
                        }
                        text = null;
                    }
                    if (data instanceof Number) {
                        numberValue = (Number)data;
                    } else {
                        NumberParseResult numberParseResult = this.parseNumber(data.toString(), inputParsingPattern, xfaLocale, false);
                        Number number = numberValue = numberParseResult != null ? (Number)numberParseResult.getNumber() : (Number)null;
                    }
                    if (numberValue == null) {
                        return null;
                    }
                    formattedData = formattedData + this.formatNumber(numberValue, currentPattern, xfaLocale, attributes);
                    continue;
                }
                return null;
            }
            if (text != null && text.length() > 0) {
                return null;
            }
            return formattedData;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private String formatNumber(Number value, String pattern, XFALocale xfaLocale, Map<String, String> attributes) {
        String[] alternatePatterns;
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)xfaLocale.getDecimalFormatSymbols().clone();
        pattern = this.normalizeNumberPattern(pattern, true, decimalFormatSymbols);
        for (String alternatePattern : alternatePatterns = pattern.split("\\|")) {
            String formattedNumber;
            if (!FormatResolver.canFormatNumberWithPattern(alternatePattern, value)) continue;
            try {
                int fracDigits;
                DecimalFormat nf = new DecimalFormat(alternatePattern, decimalFormatSymbols);
                if (attributes != null && attributes.containsKey("fracDigits") && (double)this.flattenerContext.getXfaVersion() <= 3.0 && (fracDigits = Integer.parseInt(attributes.get("fracDigits"))) >= 0) {
                    ((NumberFormat)nf).setMaximumFractionDigits(fracDigits);
                    ((NumberFormat)nf).setMinimumFractionDigits(fracDigits);
                    ((NumberFormat)nf).setRoundingMode(RoundingMode.FLOOR);
                }
                formattedNumber = nf.format(value);
            }
            catch (Exception e) {
                continue;
            }
            return formattedNumber;
        }
        String defaultPattern = this.normalizeNumberPattern(xfaLocale.getNumberPattern().get("numeric"), true, decimalFormatSymbols);
        DecimalFormat nf = new DecimalFormat(defaultPattern, xfaLocale.getDecimalFormatSymbols());
        return nf.format(value);
    }

    public String formatDate(Date date, String pattern, XFALocale xfaLocale) throws ParseException {
        pattern = this.normalizeDatePattern(pattern);
        DateFormatter nf = new DateFormatter(new SimpleDateFormat(pattern, xfaLocale.getDateFormatSymbols()));
        return nf.valueToString(date);
    }

    public String formatTime(Date date, String pattern, XFALocale xfaLocale) throws ParseException {
        pattern = this.normalizeTimePattern(pattern);
        DateFormatter nf = new DateFormatter(new SimpleDateFormat(pattern, xfaLocale.getDateFormatSymbols()));
        return nf.valueToString(date);
    }

    private String formatText(StringBuffer text, String pattern) {
        String[] regExs;
        String formattedText = "";
        pattern = this.normalizeTextPattern(pattern);
        for (String regEx : regExs = pattern.split("[,|\\-|:|/|\\.|\\s}]")) {
            int regExIndex = pattern.indexOf(regEx);
            int regExLength = regEx.length();
            formattedText = formattedText + pattern.substring(0, regExIndex);
            pattern = pattern.substring(regExIndex + regExLength, pattern.length());
            regEx = regEx.replace("A", "[a-zA-Z]");
            regEx = regEx.replace("X", "?");
            regEx = regEx.replace("O", "\\w");
            regEx = regEx.replace("0", "\\w");
            Pattern regExPattern = Pattern.compile(regEx = regEx.replace("9", "\\d"));
            Matcher matcher = regExPattern.matcher(text);
            if (!matcher.find()) {
                return null;
            }
            String matched = text.substring(matcher.start(), matcher.end());
            formattedText = formattedText + matched;
            text.delete(0, matcher.end());
        }
        if (pattern.length() > 0) {
            formattedText = formattedText + pattern;
            text.delete(0, text.length());
        }
        return formattedText;
    }

    private String normalizeDatePattern(String origPattern) {
        String pattern = origPattern;
        pattern = pattern.replace('Y', 'y');
        pattern = pattern.replace('D', 'd');
        pattern = pattern.replace('A', 'a');
        pattern = pattern.replace('m', 'M');
        return pattern;
    }

    private String normalizeTimePattern(String origPattern) {
        String pattern = origPattern;
        pattern = pattern.replace('A', 'a');
        pattern = pattern.replace('Z', 'z');
        pattern = pattern.replace('M', 'm');
        pattern = pattern.replace('S', 's');
        return pattern;
    }

    private String normalizeTextPattern(String origPattern) {
        String pattern = origPattern;
        pattern = pattern.replace('+', ' ');
        pattern = pattern.replace('*', ' ');
        pattern = pattern.replace('?', ' ');
        return pattern;
    }

    private FormatType normalizeCategorizedPattern(String origPattern, StringBuilder categorisedPattern, XFALocale xfaLocale) {
        FormatType category = null;
        if (origPattern.contains("date")) {
            category = FormatType.DATE;
        } else if (origPattern.contains("time")) {
            category = FormatType.TIME;
        } else if (origPattern.contains("num")) {
            category = FormatType.FLOAT;
        } else if (origPattern.contains("text")) {
            category = FormatType.TEXT;
        }
        if (origPattern.matches("((num)|(date)|(time))\\.\\w+\\{\\}")) {
            String patternName = origPattern.substring(origPattern.indexOf(".") + 1, origPattern.indexOf(123));
            String predefinedPattern = null;
            if (category == FormatType.DATE) {
                predefinedPattern = patternName.equalsIgnoreCase("default") || patternName.equalsIgnoreCase("medium") ? xfaLocale.getDatePattern().get("med") : xfaLocale.getDatePattern().get(patternName);
            } else if (category == FormatType.TIME) {
                predefinedPattern = patternName.equalsIgnoreCase("default") || patternName.equalsIgnoreCase("medium") ? xfaLocale.getTimePattern().get("med") : xfaLocale.getTimePattern().get(patternName);
            } else if (category == FormatType.FLOAT) {
                if (patternName.equalsIgnoreCase("decimal")) {
                    predefinedPattern = xfaLocale.getNumberPattern().get("numeric");
                } else if (patternName.equalsIgnoreCase("integer")) {
                    predefinedPattern = xfaLocale.getNumberPattern().get("numeric");
                    if (predefinedPattern != null && predefinedPattern.contains(".")) {
                        predefinedPattern = predefinedPattern.substring(0, predefinedPattern.indexOf("."));
                    }
                } else {
                    predefinedPattern = xfaLocale.getNumberPattern().get(patternName);
                }
            }
            if (predefinedPattern != null) {
                categorisedPattern.append(predefinedPattern);
            }
        } else {
            String patternPart = origPattern.substring(origPattern.indexOf(123) + 1, origPattern.indexOf(125));
            if (origPattern.startsWith("null") && patternPart.matches("[0-9\\sv]+")) {
                patternPart = patternPart.replace("v", "");
            }
            categorisedPattern.append(patternPart);
        }
        return category;
    }

    private String normalizeNumberPattern(String origPattern, boolean isOutput, DecimalFormatSymbols decimalFormatSymbols) {
        int decimalIndex;
        String pattern = origPattern;
        pattern = pattern.replace('z', '#').replace('9', '0').replace('8', '0').replace("(", "").replace(")", "").replaceAll("s|S", "");
        if (isOutput && (decimalIndex = pattern.indexOf(46)) >= 0) {
            String intPart = pattern.substring(0, decimalIndex);
            String fracPart = pattern.substring(decimalIndex + 1, pattern.length());
            fracPart = fracPart.replace('Z', '0');
            pattern = String.format("%s.%s", intPart, fracPart);
        } else {
            pattern = pattern.replace('Z', '#');
        }
        pattern = pattern.contains("$$") ? pattern.replace("$$", "\u00a4\u00a4") : pattern.replace("$", "\u00a4");
        if (pattern.contains("v")) {
            int index = pattern.indexOf("v");
            if (index < pattern.length() - 1) {
                char decimalRadix = pattern.charAt(index + 1);
                if (decimalRadix == ' ' || decimalRadix == '.' || decimalRadix == ',') {
                    decimalFormatSymbols.setDecimalSeparator(decimalRadix);
                }
                pattern = pattern.substring(0, index + 1) + pattern.substring(index + 2, pattern.length());
                pattern = pattern.replace("v", ".");
            } else {
                pattern = pattern.substring(0, index) + pattern.substring(index + 1, pattern.length());
            }
        }
        String checker = "^([^0#\\.\\,Ee;\\-\\%\\?\u00a4]*[0#\\.\\,Ee;\\-\\%\\?\u00a4 ]*[^0#\\.\\,Ee;\\-\\%\\?\u00a4]*)(\\|[^0#\\.\\,Ee;\\-\\%\\?\u00a4]*[0#\\.\\,Ee;\\-\\%\\?\u00a4 ]*[^0#\\.\\,Ee;\\-\\%\\?\u00a4]*)*$";
        return pattern.matches("^([^0#\\.\\,Ee;\\-\\%\\?\u00a4]*[0#\\.\\,Ee;\\-\\%\\?\u00a4 ]*[^0#\\.\\,Ee;\\-\\%\\?\u00a4]*)(\\|[^0#\\.\\,Ee;\\-\\%\\?\u00a4]*[0#\\.\\,Ee;\\-\\%\\?\u00a4 ]*[^0#\\.\\,Ee;\\-\\%\\?\u00a4]*)*$") ? pattern : "";
    }

    public Date parseDate(String data, String inputParsingPattern, XFALocale xfaLocale) {
        Date date;
        if (inputParsingPattern != null) {
            try {
                inputParsingPattern = this.normalizeDatePattern(inputParsingPattern);
                SimpleDateFormat df = new SimpleDateFormat(inputParsingPattern, xfaLocale.getDateFormatSymbols());
                df.setLenient(false);
                date = df.parse(data);
            }
            catch (Exception parsExc) {
                return this.parseDate(data, xfaLocale);
            }
        } else {
            return this.parseDate(data, xfaLocale);
        }
        return date;
    }

    public Date parseDate(String data, XFALocale xfaLocale) {
        if (data == null || !data.matches("\\d{4}-?((0[1-9])|(1[0-2]))?-?((0[1-9])|([1,2][0-9])|(3[01]))?(T.+)?")) {
            return null;
        }
        Date date = null;
        for (String canonicalPattern : CANONICAL_DATE_PATTERNS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(canonicalPattern, xfaLocale.getLocale());
                df.setLenient(false);
                date = df.parse(data);
                break;
            }
            catch (Exception parsExc) {
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        if (year < 1900) {
            return null;
        }
        return date;
    }

    public Date parseTime(String data, String inputParsingPattern, XFALocale xfaLocale) {
        Date date;
        if (inputParsingPattern != null) {
            try {
                inputParsingPattern = this.normalizeTimePattern(inputParsingPattern);
                SimpleDateFormat df = new SimpleDateFormat(inputParsingPattern, xfaLocale.getLocale());
                df.setLenient(false);
                date = df.parse(data);
            }
            catch (Exception parsExc) {
                return this.parseTime(data, xfaLocale);
            }
        } else {
            return this.parseTime(data, xfaLocale);
        }
        return date;
    }

    public Date parseTime(String data, XFALocale xfaLocale) {
        String timeData = data.replaceAll("([^+-]*)(\\+|-)(\\d\\d):(\\d\\d)", "$1$2$3$4");
        if (timeData.contains("T")) {
            timeData = timeData.substring(timeData.indexOf("T") + 1, timeData.length());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", xfaLocale.getLocale());
        timeData = df.format(new Date()) + " " + timeData;
        Date date = null;
        for (String canonicalPattern : CANONICAL_TIME_PATTERNS) {
            try {
                df = new SimpleDateFormat("yyyy-MM-dd " + canonicalPattern, xfaLocale.getLocale());
                df.setLenient(false);
                date = df.parse(timeData);
                break;
            }
            catch (Exception parsExc) {
            }
        }
        return date;
    }

    public NumberParseResult parseNumber(String data, String inputParsingPattern, XFALocale xfaLocale) {
        return this.parseNumber(data, inputParsingPattern, xfaLocale, true);
    }

    private NumberParseResult parseNumber(String alternatePattern, DecimalFormatSymbols decimalFormatSymbols, String data) {
        ParsePosition pos = new ParsePosition(0);
        try {
            Number value = new DecimalFormat(alternatePattern, decimalFormatSymbols).parse(data, pos);
            if (pos.getIndex() == data.length() && pos.getErrorIndex() == -1) {
                Integer numberOfDecimalSymbols = data.indexOf(decimalFormatSymbols.getDecimalSeparator());
                numberOfDecimalSymbols = numberOfDecimalSymbols == -1 ? null : Integer.valueOf(data.length() - numberOfDecimalSymbols - 1);
                return new NumberParseResult(value, numberOfDecimalSymbols);
            }
            return null;
        }
        catch (Exception parsExc) {
            return null;
        }
    }

    public NumberParseResult parseNumber(String data, String inputParsingPattern, XFALocale xfaLocale, boolean returnZeroIfFailed) {
        data = data.trim();
        if (xfaLocale.getDecimalFormatSymbols().getGroupingSeparator() == '\u00a0') {
            data = data.replace(' ', '\u00a0');
        }
        if (data.isEmpty()) {
            return null;
        }
        if (inputParsingPattern != null && inputParsingPattern.length() > 0) {
            String[] alternatePatterns = inputParsingPattern.split("\\|");
            NumberParseResult value = returnZeroIfFailed ? new NumberParseResult(0, null) : null;
            boolean foundPattern = false;
            for (String alternatePattern : alternatePatterns) {
                StringBuilder normalizedStringPattern;
                if (alternatePattern.startsWith("zero") || alternatePattern.startsWith("null")) continue;
                foundPattern = true;
                if (alternatePattern.matches("((num)|(date)|(time)|(text))\\.?\\w*\\{.*\\}") && this.normalizeCategorizedPattern(alternatePattern, normalizedStringPattern = new StringBuilder(), xfaLocale) != null) {
                    alternatePattern = normalizedStringPattern.toString();
                }
                alternatePattern = alternatePattern.trim();
                value = this.parseNumber(alternatePattern = this.normalizeNumberPattern(alternatePattern, false, null), xfaLocale.getDecimalFormatSymbols(), data);
                if (value != null || alternatePattern.contains("\u00a4") && (value = this.parseNumber(alternatePattern.replace("\u00a4", "").trim(), new DecimalFormatSymbols(Locale.US), data)) != null) break;
                value = returnZeroIfFailed ? new NumberParseResult(0, null) : null;
            }
            if (foundPattern) {
                return value;
            }
        }
        return this.parseNumber(data, returnZeroIfFailed, xfaLocale);
    }

    private NumberParseResult parseNumber(String data, boolean returnZeroIfFailed, XFALocale xfaLocale) {
        Number value;
        Locale locale = xfaLocale.getLocale();
        if (data.matches("[\\+|\\-]?[0-9]*\\.*([e|E][\\+|\\-]*[0-9]*)*") || data.matches("[\\+|\\-]?[0-9]*\\.*[0-9]*([e|E][\\+|\\-]*[0-9]*)*")) {
            locale = Locale.US;
        }
        Integer numberOfFractionalDigits = null;
        ParsePosition pos = new ParsePosition(0);
        try {
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
            value = df.parse(data, pos);
            if (pos.getIndex() == data.length()) {
                Integer decimalSeparatorPos = data.indexOf(df.getDecimalFormatSymbols().getDecimalSeparator());
                boolean hasExponentSeparator = data.contains(df.getDecimalFormatSymbols().getExponentSeparator());
                Integer minusExponentSeparator = data.indexOf(df.getDecimalFormatSymbols().getMinusSign(), (int)decimalSeparatorPos);
                numberOfFractionalDigits = hasExponentSeparator && minusExponentSeparator < 0 ? Integer.valueOf(0) : (decimalSeparatorPos == -1 ? null : Integer.valueOf(data.length() - decimalSeparatorPos - 1));
            } else {
                value = null;
            }
        }
        catch (Exception parsExc) {
            value = null;
        }
        if (value == null && returnZeroIfFailed) {
            value = 0;
        }
        return new NumberParseResult(value, numberOfFractionalDigits);
    }

    private static boolean canFormatNumberWithPattern(String pattern, Number value) {
        if (pattern.contains("%") && !pattern.contains(".")) {
            int maximalNumOfDigitsInIntegerPart = 0;
            for (int i = 0; i < pattern.length(); ++i) {
                if (pattern.charAt(i) == '#' || pattern.charAt(i) == '0') {
                    ++maximalNumOfDigitsInIntegerPart;
                    continue;
                }
                if (pattern.charAt(i) == '%') break;
            }
            double maximalValueToFit = Math.pow(10.0, maximalNumOfDigitsInIntegerPart) - 1.0;
            if (value.doubleValue() * 100.0 > maximalValueToFit) {
                return false;
            }
        }
        return true;
    }

    public static class NumberParseResult {
        Number number;
        Integer numberOfFractionalDigits;

        public NumberParseResult(Number number, Integer numberOfFractionalDigits) {
            this.number = number;
            this.numberOfFractionalDigits = numberOfFractionalDigits;
        }

        public Number getNumber() {
            return this.number;
        }

        public Integer getNumberOfFractionalDigits() {
            return this.numberOfFractionalDigits;
        }
    }

    public static enum FormatType {
        TEXT,
        FLOAT,
        INTEGER,
        DATE,
        TIME,
        DATE_TIME;

    }
}

